/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.linkage;

import java.io.IOException;

public class Sample {
    private String id;
    private char[] alleles;
    private String family;
    private String father;
    private String mother;
    private int sex;

    public Sample(String line) throws IOException {
        String[] tiles = line.split("\\s{1}(?!\\s)|(/)");
        if (tiles.length < 6) {
            throw new IOException("Expected: at last 6 columns. Found: " + tiles.length + " columns.");
        }
        this.family = tiles[0];
        this.id = tiles[1];
        this.father = tiles[2];
        this.mother = tiles[3];
        try {
            this.sex = Integer.parseInt(tiles[4]);
        }
        catch (Exception e) {
            throw new IOException("Sex is not an integer: " + tiles[4] + ".");
        }
        this.alleles = new char[tiles.length - 5];
        for (int i = 0; i < tiles.length - 5; ++i) {
            if (tiles[i + 5].length() != 1) {
                throw new IOException("Genotype coding is invalid: " + tiles[i + 5] + ".");
            }
            this.alleles[i] = tiles[i + 5].charAt(0);
        }
    }

    public Sample(Sample sample, char[] alleles) {
        this.family = sample.family;
        this.id = sample.id;
        this.father = sample.father;
        this.mother = sample.mother;
        this.sex = sample.sex;
        this.alleles = alleles;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public char[] getAlleles() {
        return this.alleles;
    }

    public void setAlleles(char[] alleles) {
        this.alleles = alleles;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getFather() {
        return this.father;
    }

    public void setFather(String father) {
        this.father = father;
    }

    public String getMother() {
        return this.mother;
    }

    public void setMother(String mother) {
        this.mother = mother;
    }

    public int getSex() {
        return this.sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public String toString() {
        return this.id + " (" + this.family + ") " + this.sex + " " + this.alleles.length / 2 + " snps " + this.alleles[this.alleles.length - 1];
    }

    public int getNoAlleles() {
        return this.alleles.length;
    }

    public int getNoSnps() {
        return this.alleles.length / 2;
    }

    public static void main(String[] args) throws IOException {
        new Sample("1000-10D 1000-10D 0 0 0 4/4 2/2 2/2 1/1 4/4 3/3 2/2 4/4 2/2 4/4 1/1 1/1 2/2 2/2 2/2 2/2 2/2 3/3 4/4 1/1 2/2 2/2 1/1 1/3 3/3 3/3 4/4 3/3 2/2 1/1 4/4 1/1 4/4 2/2 2/2 3/3 4/4 2/2 3/3 4/4 1/1 2/2 3/3 3/3 2/2 4/4 3/3 2/2 2/2 1/1 3/3 1/1 3/3 2/2 1/1 1/1 3/3 2/2 3/3 4/4 4/4 4/4 3/3 3/3 4/4 2/2 3/3 3/3 4/4 2/2 2/2 3/3 2/2 2/2 3/3 1/1 2/2 3/1 2/2 4/4 2/2 3/3 4/4 1/1 4/4 4/4 1/2 2/2 3/3 3/3 4/4 1/1 2/2 2/2 2/2 1/1 4/4 4/4 4/4 3/3 2/2 3/3 2/2 3/3 2/2 3/3 2/2 2/2 3/3 2/4 4/4 2/2 3/3 3/3 1/3 4/4 3/3 3/3 1/1 2/2 2/2 2/2 4/2 3/3 1/1 3/3 4/4 1/1 3/3 4/4 3/3 2/2 1/1 1/1 4/4 2/2 1/1 4/4 1/1 4/4 3/3 2/2 3/3 2/2 1/1 2/2 2/2 1/1 4/4 2/4 1/1 2/2 4/1 3/2 3/3 2/2 1/1 1/1 2/2 2/2 2/2 1/1 3/3 1/1 3/3 4/4 2/2 3/3 3/3 1/1 2/1 2/2 4/4 1/1 2/2 1/2 1/1 1/1 2/2 4/4 3/3 2/1 3/3 4/4 3/1 4/4 3/3 2/2 2/2 1/3 1/1 2/4 2/2 2/2 2/2 3/3 2/2 2/2 3/3 1/1 3/3 2/2 4/4 4/4 1/1 4/4 3/1 4/4 4/4 1/1 4/4 1/1 3/3 1/3 2/2 4/4 4/4 4/4 4/4 3/3 1/1 4/3 4/4 4/4 4/4 1/1 2/2 2/2 2/2 2/2 3/1 2/2 4/4 4/2 1/1 3/1 3/3 4/4 1/1 4/4 4/4 4/4 1/1 2/2 2/2 1/1 4/4 1/3 3/3 3/3 2/2 4/4 2/2 3/3 1/1 2/2 2/2 3/3 4/4 2/2 4/2 2/2 1/1 4/4 4/4 4/4 3/1 1/1 3/3 4/4 3/3 2/4 1/1 3/3 1/1 2/2 2/2 1/1 1/3 4/4 2/2 4/1 2/2 3/3 1/1 4/4 4/4 3/3 4/4 4/2 1/1 2/2 1/1 1/1 1/1 2/2 1/1 1/3 1/1 2/2 2/2 3/3 1/1 2/2 4/4 1/1 4/4 4/4 4/4 2/2 4/4 2/2 3/3 2/2 3/3 1/1 1/1 3/4 2/2 1/1 3/3 1/1 4/4 1/1 3/3 1/1 4/4 2/2 3/3 1/1 2/2 3/3 1/1 1/1 2/3 3/1 3/3 2/2 1/1 3/1 3/3 3/3 1/1 3/3 3/3 1/1");
    }
}

