/*
 * Decompiled with CFR 0.152.
 */
package genepi.haplogrep.main;

import core.SampleFile;
import core.TestSample;
import genepi.base.Tool;
import genepi.haplogrep.util.HgClassifier;
import importer.FastaImporter;
import importer.HsdImporter;
import importer.VcfImporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import util.ExportUtils;
import vcf.Sample;

public class Haplogrep
extends Tool {
    public static String VERSION = "v2.3.0";

    public Haplogrep(String[] args) {
        super(args);
    }

    @Override
    public void createParameters() {
        this.addParameter("in", "input VCF, fasta or hsd file");
        this.addParameter("out", "haplogroup output file");
        this.addParameter("format", "vcf, fasta, hsd");
        this.addOptionalParameter("phylotree", "specifiy phylotree version", 2);
        this.addFlag("rsrs", "use RSRS Version");
        this.addFlag("fixNomenclature", "Fix mtDNA nomenclature conventions based on rules");
        this.addFlag("extend-report", "add flag for a extended final output");
        this.addFlag("chip", "VCF data from a genotype chip");
        this.addOptionalParameter("metric", "specifiy other metric (hamming or jaccard) than default (kulczynski)", 2);
        this.addOptionalParameter("lineage", "export lineage information as dot file, \n0=no tree, 1=with SNPs, 2=only structure, no SNPs", 2);
        this.addOptionalParameter("hits", "calculate best n hits", 2);
        this.addOptionalParameter("hetLevel", "add heteroplasmies with a level > X to profile (default: 0.9)", 2);
    }

    @Override
    public void init() {
        System.out.println("Welcome to Haplogrep Classify " + VERSION);
        System.out.println("");
    }

    @Override
    public int run() {
        long start;
        String out;
        block19: {
            File input;
            String in = (String)this.getValue("in");
            out = (String)this.getValue("out");
            String tree = (String)this.getValue("phylotree");
            String format = (String)this.getValue("format");
            String metric = (String)this.getValue("metric");
            String hits = (String)this.getValue("hits");
            String hetLevel = (String)this.getValue("hetLevel");
            String lineage = (String)this.getValue("lineage");
            boolean extended = this.isFlagSet("extend-report");
            boolean chip = this.isFlagSet("chip");
            boolean rsrs = this.isFlagSet("rsrs");
            boolean fixNomenclature = this.isFlagSet("fixNomenclature");
            if (fixNomenclature && !format.toLowerCase().equals("fasta")) {
                System.out.println("The --fixNomenclature flag only works for FASTA.");
                return -1;
            }
            if (chip && !format.toLowerCase().equals("vcf")) {
                System.out.println("The --chip flag only works for VCF. For hsd, please specify the included variants in the Haplogrep range.");
                return -1;
            }
            if (metric == null) {
                metric = "kulczynski";
            }
            if (tree == null) {
                tree = "17";
            }
            if (hits == null) {
                hits = "1";
            }
            if (hetLevel == null) {
                hetLevel = "0.9";
            }
            if (lineage == null) {
                lineage = "0";
            }
            if (!(input = new File(in)).exists()) {
                System.out.println("Error. Please check if input file exists");
                return -1;
            }
            String phylotree = "phylotree$VERSION$RSRS.xml";
            String fluctrates = "weights$VERSION$RSRS.txt";
            phylotree = phylotree.replace("$VERSION", tree);
            fluctrates = fluctrates.replace("$VERSION", tree);
            if (rsrs) {
                phylotree = phylotree.replace("$RSRS", "_rsrs");
                fluctrates = fluctrates.replace("$RSRS", "_rsrs");
            } else {
                phylotree = phylotree.replace("$RSRS", "");
                fluctrates = fluctrates.replace("$RSRS", "");
            }
            System.out.println(phylotree);
            System.out.println("Parameters:");
            System.out.println("Input Format: " + format);
            System.out.println("Phylotree Version: " + tree);
            System.out.println("Reference: " + (rsrs ? "RSRS" : "rCRS"));
            System.out.println("Extended Report: " + extended);
            System.out.println("Fix Nomenclature: " + fixNomenclature);
            System.out.println("Used Metric: " + metric);
            System.out.println("Chip array data: " + chip);
            System.out.println("Lineage: " + lineage);
            System.out.println("");
            start = System.currentTimeMillis();
            System.out.println("Start Classification...");
            try {
                if (input.isFile()) {
                    Object importer;
                    ArrayList<String> lines = new ArrayList();
                    if (format.equals("hsd")) {
                        importer = new HsdImporter();
                        lines = ((HsdImporter)importer).load(input);
                    } else if (format.equals("vcf")) {
                        VcfImporter importerVcf = new VcfImporter();
                        HashMap<String, Sample> samples = importerVcf.load(input, chip);
                        lines = ExportUtils.vcfTohsd(samples, Double.valueOf(hetLevel));
                    } else if (format.equals("fasta")) {
                        importer = new FastaImporter();
                        lines = rsrs ? ((FastaImporter)importer).load(input, FastaImporter.References.RSRS) : ((FastaImporter)importer).load(input, FastaImporter.References.RCRS);
                    }
                    if (lines != null) {
                        SampleFile newSampleFile = new SampleFile(lines);
                        HgClassifier classifier = new HgClassifier();
                        classifier.run(newSampleFile, phylotree, fluctrates, metric, Integer.valueOf(hits), fixNomenclature);
                        ArrayList<TestSample> samples = newSampleFile.getTestSamples();
                        ExportUtils.createReport(samples, out, extended);
                        ExportUtils.calcLineage(samples, Integer.valueOf(lineage), out);
                    }
                    break block19;
                }
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        System.out.println("HaploGrep file written to " + new File(out).getAbsolutePath() + " (Time: " + (System.currentTimeMillis() - start) / 1000L + " sec)");
        return 0;
    }

    public static void main(String[] args) throws IOException {
        Haplogrep haplogrep = new Haplogrep(args);
        haplogrep.start();
    }
}

