/*
 * Decompiled with CFR 0.152.
 */
package genepi.base;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public abstract class Tool {
    private CommandLineParser parser;
    private Options options;
    private CommandLine line = null;
    public static final int FLAG = 0;
    public static final int INTEGER = 1;
    public static final int STRING = 2;
    public static final int DOUBLE = 4;
    private Map<String, Integer> parameters;
    private String[] args;

    public Tool(String[] args) {
        this.args = args;
        this.parser = new PosixParser();
        this.options = new Options();
        this.parameters = new HashMap<String, Integer>();
    }

    public void addParameter(String param, String description) {
        this.addParameter(param, description, 2);
    }

    public void addParameter(String param, String description, int type) {
        Option option = new Option(null, param, true, description);
        option.setRequired(true);
        switch (type) {
            case 1: {
                option.setArgName("int");
                break;
            }
            case 4: {
                option.setArgName("double");
                break;
            }
            case 2: {
                option.setArgName("string");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.options.addOption(option);
        this.parameters.put(param, type);
    }

    public void addFlag(String param, String description) {
        Option option = new Option(null, param, false, description);
        option.setRequired(false);
        this.options.addOption(option);
        this.parameters.put(param, 0);
    }

    public void addOptionalParameter(String param, String description, int type) {
        Option option = new Option(null, param, true, description);
        option.setRequired(false);
        switch (type) {
            case 1: {
                option.setType(Integer.class);
                break;
            }
            case 4: {
                option.setType(Double.class);
                break;
            }
            case 2: {
                option.setType(String.class);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.options.addOption(option);
        this.parameters.put(param, type);
    }

    public Object getValue(String param) {
        String value = this.line.getOptionValue(param);
        int type = this.parameters.get(param);
        switch (type) {
            case 1: {
                return Integer.parseInt(value);
            }
            case 4: {
                return Double.parseDouble(value);
            }
            case 2: {
                return value;
            }
        }
        throw new IllegalArgumentException();
    }

    public String[] getRemainingArgs() {
        return this.line.getArgs();
    }

    public boolean isFlagSet(String param) {
        return this.line.hasOption(param);
    }

    public void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(" ", this.options, true);
    }

    public abstract void init();

    public abstract int run();

    public abstract void createParameters();

    public int start() {
        this.createParameters();
        boolean error = false;
        try {
            this.init();
            this.line = this.parser.parse(this.options, this.args);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage() + "\n");
            this.help();
            error = true;
        }
        if (!error) {
            try {
                for (String param : this.parameters.keySet()) {
                    if (this.parameters.get(param) == 0) continue;
                    this.getValue(param);
                }
            }
            catch (Exception e) {
                System.out.println("Datatype Error: " + e.getMessage() + "\n");
                this.help();
                error = true;
            }
            if (!error) {
                int res = this.run();
                return res;
            }
        }
        return -1;
    }
}

