/*
 * Decompiled with CFR 0.152.
 */
package dataVisualizers;

import core.TestSample;
import dataVisualizers.OverviewTreeInnerNode;
import dataVisualizers.OverviewTreeLeafNode;
import dataVisualizers.TreeNode;
import java.util.ArrayList;
import search.SearchResultTreeNode;

public class OverviewTree {
    private OverviewTreeInnerNode root;
    private ArrayList<OverviewTreeLeafNode> leafNodes = new ArrayList();

    public void addNewPath(TestSample testSample, ArrayList<SearchResultTreeNode> newPath) {
        int i = 0;
        if (this.root == null) {
            this.root = new OverviewTreeInnerNode(null, newPath.get(i));
            ++i;
        }
        this.addNewPathNode(testSample, this.root, newPath, 1);
    }

    public void addNewPathNode(TestSample currentSample, TreeNode currentTreeRootNode, ArrayList<SearchResultTreeNode> pathToAdd, int currentIteration) {
        SearchResultTreeNode currentNodeToAdd = pathToAdd.get(currentIteration);
        boolean foundChild = false;
        for (TreeNode currentChildNode : currentTreeRootNode.getChildren()) {
            if (!(currentChildNode instanceof OverviewTreeInnerNode) || !currentChildNode.getPhyloTreeNode().equals(pathToAdd.get(currentIteration).getPhyloTreeNode())) continue;
            ((OverviewTreeInnerNode)currentChildNode).addDistinctFoundPolys(currentNodeToAdd.getExpectedPolys());
            if (currentIteration + 1 < pathToAdd.size()) {
                this.addNewPathNode(currentSample, currentChildNode, pathToAdd, currentIteration + 1);
            } else {
                OverviewTreeLeafNode newTreeNode = new OverviewTreeLeafNode(currentChildNode, currentSample, pathToAdd.get(pathToAdd.size() - 1));
                currentTreeRootNode = newTreeNode;
                this.leafNodes.add(newTreeNode);
            }
            foundChild = true;
            break;
        }
        if (!foundChild) {
            for (int i = currentIteration; i < pathToAdd.size(); ++i) {
                OverviewTreeInnerNode newNode = new OverviewTreeInnerNode(currentTreeRootNode, pathToAdd.get(i));
                newNode.addDistinctFoundPolys(pathToAdd.get(i).getFoundPolys());
                currentTreeRootNode = newNode;
            }
            OverviewTreeLeafNode newTreeNode = new OverviewTreeLeafNode(currentTreeRootNode, currentSample, pathToAdd.get(pathToAdd.size() - 1));
            currentTreeRootNode = newTreeNode;
            this.leafNodes.add(newTreeNode);
        }
    }

    public void generateLeafNodes(boolean includeHotspots) {
        boolean i = false;
        for (OverviewTreeLeafNode currentLeafNode : this.leafNodes) {
            currentLeafNode.updatePolys(includeHotspots);
        }
    }

    public OverviewTreeInnerNode getRootNode() {
        return this.root;
    }
}

