/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Haplogroup;
import core.Polymorphism;
import core.Sample;
import core.SampleRanges;
import exceptions.parse.HsdFileException;
import exceptions.parse.sample.HsdFileSampleParseException;
import exceptions.parse.sample.InvalidPolymorphismException;
import exceptions.parse.samplefile.InvalidColumnCountException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import phylotree.Phylotree;
import search.ClusteredSearchResults;
import search.SearchResultTreeNode;
import search.ranking.RankingMethod;
import search.ranking.results.RankedResult;

public class TestSample
implements Comparable<TestSample> {
    final Logger log = Logger.getLogger(TestSample.class);
    ArrayList<RankedResult> searchResults = new ArrayList();
    ClusteredSearchResults clusteredResults = new ClusteredSearchResults(this.searchResults);
    private String testSampleID = "Unknown";
    private Haplogroup expectedHaplogroup;
    private Haplogroup detectedHaplogroup;
    private Sample sample;
    private int qualityRulesLevelReached = 0;
    private boolean reset = false;

    private TestSample() {
    }

    public TestSample(String sampleID, ArrayList<Polymorphism> polymorphisms, SampleRanges sampleRange) {
        this.testSampleID = sampleID.replace(" ", "_");
        this.sample = new Sample(polymorphisms, sampleRange);
    }

    public static TestSample parse(String inputString) throws HsdFileException {
        TestSample parsedSample = new TestSample();
        SampleRanges sampleRange = null;
        Pattern p = Pattern.compile("(\\d*(-|;)?)*");
        try {
            String[] columns = inputString.split("\t");
            if (columns.length < 3) {
                throw new InvalidColumnCountException(columns.length);
            }
            parsedSample.testSampleID = columns[0].trim().replace("|", "_").replace(" ", "_");
            columns[1] = columns[1].replaceAll("\"", "");
            sampleRange = new SampleRanges(columns[1], true);
            parsedSample.expectedHaplogroup = columns[2].equals("?") || columns[2].equals("SEQ") ? new Haplogroup("") : new Haplogroup(columns[2]);
            StringBuffer sampleString = new StringBuffer();
            for (int i = 3; i < columns.length; ++i) {
                sampleString.append(columns[i] + " ");
            }
            parsedSample.sample = new Sample(sampleString.toString(), sampleRange, 0);
        }
        catch (InvalidPolymorphismException e) {
            HsdFileSampleParseException ex = new HsdFileSampleParseException(e.getMessage());
            ex.setTestSampleID(parsedSample.testSampleID);
            throw ex;
        }
        return parsedSample;
    }

    public Haplogroup getExpectedHaplogroup() {
        return this.expectedHaplogroup;
    }

    public void setExpectedHaplogroup(Haplogroup expectedHaplogroup) {
        this.expectedHaplogroup = expectedHaplogroup;
    }

    public Haplogroup getDetectedHaplogroup() {
        if (this.getTopResult() != null) {
            this.detectedHaplogroup = this.getTopResult().getSearchResult().getHaplogroup();
            return this.detectedHaplogroup;
        }
        return null;
    }

    public Sample getSample() {
        return this.sample;
    }

    public String getSampleID() {
        return this.testSampleID;
    }

    public String toString() {
        String result = this.testSampleID + "\t" + this.expectedHaplogroup + "\t";
        for (Polymorphism currentPoly : this.sample.sample) {
            result = result + currentPoly.toString() + " ";
        }
        return result;
    }

    @Override
    public int compareTo(TestSample o) {
        if (this.getSampleID().compareTo(o.getSampleID()) < 0) {
            return -1;
        }
        if (this.getSampleID().compareTo(o.getSampleID()) > 0) {
            return 1;
        }
        return 0;
    }

    public RankedResult getResult(Haplogroup haplogroup) {
        for (RankedResult currentResult : this.searchResults) {
            if (!currentResult.getHaplogroup().equals(haplogroup)) continue;
            return currentResult;
        }
        return null;
    }

    public List<RankedResult> getResults() {
        return this.searchResults;
    }

    public JSONObject getSelectetHaplogroupSubtree(ArrayList<String> selectedHaplogroups) {
        ArrayList<RankedResult> selectedResults = new ArrayList<RankedResult>();
        for (String string : selectedHaplogroups) {
            Haplogroup selectedHaplogroup = new Haplogroup(string);
            ArrayList<RankedResult> currentResults = this.clusteredResults.getCluster(selectedHaplogroup);
            if (currentResults != null) {
                selectedResults.addAll(currentResults);
                continue;
            }
            selectedResults.add(this.getResult(selectedHaplogroup));
        }
        ArrayList<ArrayList<SearchResultTreeNode>> paths = new ArrayList<ArrayList<SearchResultTreeNode>>();
        for (RankedResult currentResult : selectedResults) {
            ArrayList<SearchResultTreeNode> newPath = currentResult.getSearchResult().getDetailedResult().getPhyloTreePath();
            paths.add(newPath);
        }
        try {
            JSONObject jSONObject = this.combinePathsToTree(paths, this.searchResults.get(0));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private JSONObject combinePathsToTree(ArrayList<ArrayList<SearchResultTreeNode>> paths, RankedResult list) throws JSONException {
        JSONObject currentNode;
        JSONObject result = currentNode = new JSONObject();
        currentNode.put("id", "root");
        JSONObject dataNode = new JSONObject();
        dataNode.put("type", "hg");
        currentNode.put("data", dataNode);
        currentNode.put("name", "sample");
        int ipath = 0;
        for (ArrayList<SearchResultTreeNode> currentPath : paths) {
            currentNode = result;
            if (currentNode.has("children")) {
                JSONArray currentChildren = currentNode.getJSONArray("children");
                ipath = 0;
                int i = 0;
                while (i < currentChildren.length() && ipath < currentPath.size()) {
                    JSONObject childNode = currentChildren.getJSONObject(i);
                    if (childNode.get("name").toString().equals(currentPath.get(ipath).getHaplogroup() + "_Polys")) {
                        currentNode = childNode;
                        currentChildren = currentNode.getJSONArray("children");
                        i = 0;
                        continue;
                    }
                    if (childNode.get("name").equals(currentPath.get(ipath).getHaplogroup())) {
                        this.log.info(currentPath.get(ipath).getHaplogroup() + " ");
                        currentNode = childNode;
                        currentChildren = currentNode.getJSONArray("children");
                        i = 0;
                        ++ipath;
                        continue;
                    }
                    ++i;
                }
            }
            for (int i1 = ipath; i1 < currentPath.size(); ++i1) {
                JSONObject poly;
                dataNode = new JSONObject();
                dataNode.put("type", "poly");
                for (Polymorphism currentPoly : currentPath.get(i1).getExpectedPolys()) {
                    poly = new JSONObject();
                    poly.put("name", currentPoly);
                    if (currentPath.get(i1).getFoundPolys().contains(currentPoly)) {
                        poly.put("state", "found");
                    } else if (currentPoly.isHeteroplasmy) {
                        poly.put("state", "hetero");
                    } else if (list != null) {
                        if (list.getSearchResult().getDetailedResult().getCorrectedBackmutations().contains(currentPoly)) {
                            poly.put("state", "corrected");
                        } else {
                            poly.put("state", "notfound");
                        }
                    }
                    dataNode.append("polys", poly);
                }
                for (Polymorphism currentPoly : currentPath.get(i1).getNotInRangePolys()) {
                    poly = new JSONObject();
                    poly.put("name", currentPoly);
                    poly.put("state", "notInRange");
                    dataNode.append("polys", poly);
                }
                int numAllPolys = currentPath.get(i1).getExpectedPolys().size() + currentPath.get(i1).getNotInRangePolys().size();
                dataNode.put("$height", numAllPolys * 13 + 10);
                dataNode.put("$width", 50);
                JSONObject newPolyNode = new JSONObject();
                newPolyNode.put("id", currentPath.get(i1).getHaplogroup() + "_Polys");
                newPolyNode.put("data", dataNode);
                newPolyNode.put("name", currentPath.get(i1).getHaplogroup() + "_Polys");
                dataNode = new JSONObject();
                dataNode.put("type", "hg");
                JSONObject newNode = new JSONObject();
                newNode.put("id", currentPath.get(i1).getHaplogroup());
                newNode.put("data", dataNode);
                newNode.put("name", currentPath.get(i1).getHaplogroup());
                newNode.put("children", new JSONArray());
                newPolyNode.append("children", newNode);
                currentNode.append("children", newPolyNode);
                currentNode = newNode;
            }
        }
        return result;
    }

    public void clearSearchResults() {
        this.searchResults.clear();
        this.clusteredResults = null;
    }

    public void updateSearchResults(Phylotree phyloTreeToUse, RankingMethod rankingMethod) {
        List<RankedResult> results = phyloTreeToUse.search(this, rankingMethod.clone());
        this.searchResults = (ArrayList)results;
        this.clusteredResults = new ClusteredSearchResults(results);
    }

    public JSONArray getClusteredSearchResults() {
        if (this.clusteredResults != null) {
            return this.clusteredResults.toJSON();
        }
        return new JSONArray();
    }

    public ClusteredSearchResults getClusteredSearchResultsAsObject() {
        return this.clusteredResults;
    }

    public RankedResult getTopResult() {
        if (this.searchResults.size() > 0) {
            return this.searchResults.get(0);
        }
        return null;
    }

    public int getQualityLevelReached() {
        return this.qualityRulesLevelReached;
    }

    public void setReachedQualityLevel(int level) {
        this.qualityRulesLevelReached = level;
    }

    public ArrayList<TestSample> createFragmentsOld(SampleRanges fragmentRanges) {
        HashMap fragmentsHashMap = new HashMap();
        ArrayList<TestSample> resultFragments = new ArrayList<TestSample>();
        for (int i = 0; i < fragmentRanges.getStarts().size(); ++i) {
            fragmentsHashMap.put(i, new ArrayList());
        }
        for (Polymorphism currentPoly : this.sample.getPolymorphisms()) {
            int key = fragmentRanges.getSubrangeID(currentPoly);
            ArrayList currentFragment = (ArrayList)fragmentsHashMap.get(key);
            if (currentFragment == null) {
                fragmentsHashMap.put(key, new ArrayList());
            }
            ((ArrayList)fragmentsHashMap.get(key)).add(currentPoly);
        }
        int i = 0;
        for (ArrayList currentFragment : fragmentsHashMap.values()) {
            resultFragments.add(new TestSample(this.testSampleID + "_Frag_" + fragmentRanges.getStarts().get(i), currentFragment, fragmentRanges.getSubrange(i)));
            ++i;
        }
        return resultFragments;
    }

    public ArrayList<TestSample> createFragmentsSimple(SampleRanges fragmentRanges) {
        ArrayList<TestSample> resultFragments = new ArrayList<TestSample>();
        for (int i = 0; i < fragmentRanges.getStarts().size(); ++i) {
            resultFragments.add(new TestSample(this.testSampleID + "_Frag_" + fragmentRanges.getStarts().get(i), this.sample.getPolymorphisms(), fragmentRanges.getSubrange(i)));
        }
        return resultFragments;
    }

    public void setDetectedHaplogroup(Haplogroup detectedHaplogroup) {
        this.detectedHaplogroup = detectedHaplogroup;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }
}

