/*
 * Decompiled with CFR 0.152.
 */
package com.github.lindenb.jbwa.jni;

import com.github.lindenb.jbwa.jni.AlnRgn;
import com.github.lindenb.jbwa.jni.BwaIndex;
import com.github.lindenb.jbwa.jni.ShortRead;
import java.io.IOException;
import java.util.List;

public class BwaMem {
    protected long ref = BwaMem.mem_opt_init();
    private BwaIndex bwaIndex = null;

    public BwaMem(BwaIndex bwaIndex) {
        this.bwaIndex = bwaIndex;
    }

    public void updateScoringParameters(int baseMismatchPen, int gapOpenPenIns, int gapOpenPenDel, int gapExtPenIns, int gapExtPenDel, int clipPen5, int clipPen3) {
        this.update_score_parameters(baseMismatchPen, gapOpenPenIns, gapOpenPenDel, gapExtPenIns, gapExtPenDel, clipPen5, clipPen3);
    }

    public AlnRgn[] align(ShortRead read) throws IOException {
        if (this.ref == 0L) {
            return null;
        }
        return this.align(this.bwaIndex, read.getBases());
    }

    public String[] align(List<ShortRead> ks1, List<ShortRead> ks2) throws IOException {
        if (this.ref == 0L) {
            return null;
        }
        if (ks1 == null) {
            throw new IllegalArgumentException("ks1 is null");
        }
        if (ks2 == null) {
            throw new IllegalArgumentException("ks2 is null");
        }
        return this.align(ks1.toArray(new ShortRead[ks1.size()]), ks2.toArray(new ShortRead[ks2.size()]));
    }

    public String[] align(ShortRead[] ks1, ShortRead[] ks2) throws IOException {
        if (this.ref == 0L) {
            return null;
        }
        if (ks1 == null) {
            throw new IllegalArgumentException("ks1 is null");
        }
        if (ks2 == null) {
            throw new IllegalArgumentException("ks2 is null");
        }
        if (ks1.length != ks2.length) {
            throw new IllegalArgumentException("ks1.length!=ks2.length");
        }
        if (ks1.length == 0) {
            return null;
        }
        return this.align2(this.bwaIndex, ks1, ks2);
    }

    protected void finalize() {
        this.dispose();
    }

    public native void dispose();

    private static native long mem_opt_init();

    public native void set_verbosity(int var1);

    private native void update_score_parameters(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native AlnRgn[] align(BwaIndex var1, byte[] var2) throws IOException;

    private native String[] align2(BwaIndex var1, ShortRead[] var2, ShortRead[] var3) throws IOException;
}

