/*
 * Decompiled with CFR 0.152.
 */
package util;

import core.Haplogroup;
import core.Polymorphism;
import core.SampleRanges;
import core.TestSample;
import exceptions.parse.sample.InvalidPolymorphismException;
import genepi.io.table.writer.CsvTableWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.collections.map.MultiValueMap;
import search.SearchResult;
import search.SearchResultTreeNode;
import search.ranking.results.RankedResult;
import vcf.Sample;
import vcf.Variant;

public class ExportUtils {
    public static ArrayList<String> vcfTohsd(HashMap<String, Sample> samples) {
        return ExportUtils.vcfTohsd(samples, 0.9);
    }

    public static ArrayList<String> vcfTohsd(HashMap<String, Sample> samples, double hetLevel) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Sample sam : samples.values()) {
            StringBuilder build = new StringBuilder();
            build.append(sam.getId() + "\t" + sam.getRange() + "\t?");
            for (Variant var : sam.getVariants()) {
                if (var.getType() == 1 || var.getType() == 4 || var.getType() == 2 && var.getLevel() >= hetLevel) {
                    build.append("\t" + var.getPos() + "" + var.getVariant());
                    continue;
                }
                if (var.getType() != 5) continue;
                build.append("\t" + var.getInsertion());
            }
            build.append("\n");
            lines.add(build.toString());
        }
        return lines;
    }

    public static void createReport(Collection<TestSample> sampleCollection, String outFilename, boolean extended) throws IOException {
        CsvTableWriter writer = new CsvTableWriter(outFilename, '\t');
        Collections.sort((List)sampleCollection);
        if (!extended) {
            writer.setColumns(new String[]{"SampleID", "Haplogroup", "Rank", "Quality", "Range"});
        } else {
            writer.setColumns(new String[]{"SampleID", "Haplogroup", "Rank", "Quality", "Range", "Not_Found_Polys", "Found_Polys", "Remaining_Polys", "AAC_In_Remainings", "Input_Sample"});
        }
        if (sampleCollection != null) {
            for (TestSample sample : sampleCollection) {
                int rank = 0;
                for (RankedResult currentResult : sample.getResults()) {
                    ++rank;
                    SampleRanges range = sample.getSample().getSampleRanges();
                    ArrayList<Integer> startRange = range.getStarts();
                    ArrayList<Integer> endRange = range.getEnds();
                    String resultRange = "";
                    for (int i = 0; i < startRange.size(); ++i) {
                        if (i != 0) {
                            resultRange = resultRange + " ";
                        }
                        resultRange = startRange.get(i).equals(endRange.get(i)) ? resultRange + startRange.get(i) : resultRange + startRange.get(i) + "-" + endRange.get(i);
                    }
                    writer.setString("SampleID", sample.getSampleID());
                    writer.setString("Range", resultRange);
                    writer.setString("Haplogroup", currentResult.getHaplogroup().toString());
                    writer.setString("Rank", rank + "");
                    writer.setString("Quality", String.format(Locale.ROOT, "%.4f", currentResult.getDistance()));
                    if (extended) {
                        Object currentPoly32;
                        ArrayList<Polymorphism> foundPolys = currentResult.getSearchResult().getDetailedResult().getFoundPolys();
                        ArrayList<Polymorphism> expectedPolys = currentResult.getSearchResult().getDetailedResult().getExpectedPolys();
                        Collections.sort(foundPolys);
                        Collections.sort(expectedPolys);
                        StringBuffer result = new StringBuffer();
                        for (Polymorphism polymorphism : expectedPolys) {
                            if (foundPolys.contains(polymorphism)) continue;
                            result.append(" " + polymorphism.toString());
                        }
                        writer.setString("Not_Found_Polys", result.toString().trim());
                        result = new StringBuffer();
                        for (Polymorphism polymorphism : foundPolys) {
                            result.append(" " + polymorphism);
                        }
                        writer.setString("Found_Polys", result.toString().trim());
                        ArrayList<Polymorphism> allChecked = currentResult.getSearchResult().getDetailedResult().getRemainingPolysInSample();
                        Collections.sort(allChecked);
                        result = new StringBuffer();
                        for (Object currentPoly32 : allChecked) {
                            String type = ExportUtils.getTypeRemaining((Polymorphism)currentPoly32, currentResult.getSearchResult());
                            result.append(" " + currentPoly32 + " (" + type + ")");
                        }
                        writer.setString("Remaining_Polys", result.toString().trim());
                        ArrayList<Polymorphism> arrayList = currentResult.getSearchResult().getDetailedResult().getRemainingPolysInSample();
                        Collections.sort(arrayList);
                        result = new StringBuffer();
                        currentPoly32 = arrayList.iterator();
                        while (currentPoly32.hasNext()) {
                            Polymorphism currentPoly4 = (Polymorphism)currentPoly32.next();
                            if (currentPoly4.getAnnotation() == null) continue;
                            result.append(" " + currentPoly4 + " [" + currentPoly4.getAnnotation().getAminoAcidChange() + "| Codon " + currentPoly4.getAnnotation().getCodon() + " | " + currentPoly4.getAnnotation().getGene() + " ]");
                        }
                        writer.setString("AAC_In_Remainings", result.toString().trim());
                        ArrayList<Polymorphism> inputPolys = sample.getSample().getPolymorphisms();
                        Collections.sort(inputPolys);
                        result = new StringBuffer();
                        for (Polymorphism input : inputPolys) {
                            result.append(" " + input);
                        }
                        writer.setString("Input_Sample", result.toString().trim());
                    }
                    writer.next();
                }
            }
        }
        writer.close();
    }

    private static String getTypeRemaining(Polymorphism p, SearchResult result) {
        if (result.getPhyloTree().getMutationRate(p) == 0.0) {
            if (p.isMTHotspot()) {
                return "hotspot";
            }
            return "globalPrivateMutation";
        }
        return "localPrivateMutation";
    }

    public static void createHsdInput(List<TestSample> sampleCollection, String out) throws IOException {
        StringBuffer result = new StringBuffer();
        Collections.sort(sampleCollection);
        result.append("SampleID\tRange\tHaplogroup\tInput_Sample\n");
        if (sampleCollection != null) {
            for (TestSample sample : sampleCollection) {
                result.append(sample.getSampleID() + "\t");
                for (RankedResult currentResult : sample.getResults()) {
                    SampleRanges range = sample.getSample().getSampleRanges();
                    ArrayList<Integer> startRange = range.getStarts();
                    ArrayList<Integer> endRange = range.getEnds();
                    String resultRange = "";
                    for (int i = 0; i < startRange.size(); ++i) {
                        resultRange = startRange.get(i).equals(endRange.get(i)) ? resultRange + startRange.get(i) + ";" : resultRange + startRange.get(i) + "-" + endRange.get(i) + ";";
                    }
                    result.append(resultRange);
                    result.append("\t" + currentResult.getHaplogroup());
                    result.append("\t");
                    ArrayList<Polymorphism> input = sample.getSample().getPolymorphisms();
                    Collections.sort(input);
                    for (Polymorphism currentPoly : input) {
                        result.append(" " + currentPoly);
                    }
                    result.append("\n");
                }
            }
        }
        FileWriter fileWriter = new FileWriter(out);
        fileWriter.write(result.toString().replace("\t ", "\t"));
        fileWriter.close();
    }

    public static void calcLineage(Collection<TestSample> sampleCollection, int tree, String out) throws IOException {
        if (tree == 0) {
            return;
        }
        Collections.sort((List)sampleCollection);
        MultiValueMap remainingSet = new MultiValueMap();
        if (out.endsWith(".txt")) {
            out = out.substring(0, out.lastIndexOf("."));
        }
        HashSet<String> set = new HashSet<String>();
        String tmpNode = "";
        String graphViz = out + ".dot";
        FileWriter graphVizWriter = new FileWriter(graphViz);
        graphVizWriter.write("digraph {  label=\"Sample File: " + out + "\"\n");
        if (tree == 1 || tree == 3) {
            graphVizWriter.write("graph [layout = dot, rankdir = TB]\n");
        } else if (tree == 2) {
            graphVizWriter.write("graph [layout = dot, rankdir = LR]\n");
        }
        graphVizWriter.write("node [shape = oval,style = filled,color = lightblue]\n");
        for (TestSample sample : sampleCollection) {
            Object notfound = "";
            String remaining = "";
            notfound = "";
            for (RankedResult currentResult : sample.getResults()) {
                int i;
                ArrayList<SearchResultTreeNode> currentPath = currentResult.getSearchResult().getDetailedResult().getPhyloTreePath();
                for (i = 0; i < currentPath.size(); ++i) {
                    Haplogroup currentHg = currentPath.get(i).getHaplogroup();
                    if (i == 0) {
                        tmpNode = "\"" + currentHg + "\" -> ";
                        continue;
                    }
                    StringBuilder polys = new StringBuilder();
                    if (currentPath.get(i).getExpectedPolys().size() == 0) {
                        polys.append("");
                    } else {
                        for (Polymorphism currentPoly : currentPath.get(i).getExpectedPolys()) {
                            polys.append(currentPoly + " ");
                            if (!currentPath.get(i).getFoundPolys().contains(currentPoly)) {
                                notfound = (String)notfound + currentPoly + "@ ";
                                notfound = (String)notfound + "\n";
                            }
                            polys.append("\n");
                        }
                    }
                    String node = "";
                    if (tree == 1) {
                        node = "\"" + currentHg + "\"[label=\"" + polys.toString().trim() + "\"];\n";
                    } else if (tree >= 2) {
                        node = "\"" + currentHg + "\"[label=\"\"];\n";
                    }
                    if (!set.contains(tmpNode + node)) {
                        graphVizWriter.write(tmpNode + node);
                        set.add(tmpNode + node);
                        tmpNode = "";
                    }
                    if (i == currentPath.size() - 1) continue;
                    tmpNode = "\"" + currentHg + "\" -> ";
                }
                for (i = 0; i < currentResult.getSearchResult().getDetailedResult().getRemainingPolysInSample().size(); ++i) {
                    Polymorphism poly = currentResult.getSearchResult().getDetailedResult().getRemainingPolysInSample().get(i);
                    if (ExportUtils.polyToExclude(poly)) continue;
                    remaining = remaining + poly + " ";
                    remaining = remaining + "\n";
                }
            }
            remainingSet.put((Object)((String)notfound + " " + remaining), (Object)sample);
        }
        HashMap<String, Integer> groupedMap = new HashMap<String, Integer>();
        TreeSet keys = new TreeSet(remainingSet.keySet());
        for (String key : keys) {
            String sampleLabels = "";
            List nodes = (List)remainingSet.get((Object)key);
            for (int j = 0; j < nodes.size(); ++j) {
                TestSample s1 = (TestSample)nodes.get(j);
                if (j > 0) {
                    if (tree == 1) {
                        sampleLabels = sampleLabels + "\n";
                    } else if (tree == 2) {
                        sampleLabels = sampleLabels + " ";
                    }
                }
                sampleLabels = sampleLabels + s1.getSampleID();
                String HG = s1.getDetectedHaplogroup().toString();
                if (groupedMap.containsKey(HG)) {
                    groupedMap.put(HG, Integer.valueOf((Integer)groupedMap.get(HG)) + 1);
                    continue;
                }
                groupedMap.put(HG, 1);
            }
            graphVizWriter.write("\"" + ((TestSample)nodes.get(0)).getDetectedHaplogroup() + "\"[color=deepskyblue]\n");
            if (tree == 1) {
                graphVizWriter.write("\"" + ((TestSample)nodes.get(0)).getDetectedHaplogroup() + "\" -> \"" + sampleLabels + " \"[color=steelblue, label=\"" + key + "\"]\n");
                graphVizWriter.write("\"" + sampleLabels + " \"[shape=rectangle, color=steelblue]\n");
                continue;
            }
            if (tree != 2) continue;
            graphVizWriter.write("\"" + ((TestSample)nodes.get(0)).getDetectedHaplogroup() + "\" -> \"" + sampleLabels + " \"[color=steelblue, label=\"\"]\n");
            graphVizWriter.write("\"" + sampleLabels + " \"[shape=rectangle, color=steelblue]\n");
        }
        if (tree == 3) {
            Iterator it = groupedMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                int value = (Integer)pair.getValue();
                graphVizWriter.write("\"" + pair.getKey() + "\" -> \"" + pair.getKey() + " = " + value + " \"[color=steelblue, label=\"\"]\n");
                if (value < 2) {
                    graphVizWriter.write("\"" + pair.getKey() + " = " + value + " \"[shape=rectangle, color=steelblue]\n");
                } else if (value >= 2 && value < 10) {
                    graphVizWriter.write("\"" + pair.getKey() + " = " + value + " \"[shape=rectangle, color=darkorange]\n");
                } else {
                    graphVizWriter.write("\"" + pair.getKey() + " = " + value + " \"[shape=rectangle, color=firebrick1]\n");
                }
                it.remove();
            }
            graphVizWriter.write("subgraph cluster_legend {\n");
            graphVizWriter.write("label = \"Legend\"\n");
            graphVizWriter.write("shape=rectangle\n");
            graphVizWriter.write("color = black\n");
            graphVizWriter.write("\"Intermediate haplogroup\" [color=lightblue]\n");
            graphVizWriter.write("\"Terminal haplogroup\"  [color=deepskyblue]\n");
            graphVizWriter.write("\"1 sample \\n in Haplogroup\"  [shape=rectangle, color=steelblue]\n");
            graphVizWriter.write("\">= 2 Samples \\n in Haplogroup\"  [shape=rectangle, color=darkorange]\n");
            graphVizWriter.write("\">=10 Samples \\n in Haplogroup\"  [shape=rectangle, color=firebrick1]\n");
            graphVizWriter.write("}\n");
        }
        graphVizWriter.write("}");
        graphVizWriter.close();
    }

    private static boolean polyToExclude(Polymorphism polymorphism) {
        int pos = polymorphism.getPosition();
        switch (pos) {
            case 309: {
                return true;
            }
            case 315: {
                return true;
            }
            case 523: {
                return true;
            }
            case 524: {
                return true;
            }
            case 525: {
                return true;
            }
            case 3107: {
                return true;
            }
            case 16182: {
                return true;
            }
            case 16183: {
                return true;
            }
            case 16193: {
                return true;
            }
            case 16519: {
                return true;
            }
        }
        return false;
    }

    public static void generateFasta(Collection<TestSample> sampleCollection, String out) throws IOException {
        String fastafile = out + "_haplogrep2.fasta";
        FileWriter fasta = new FileWriter(fastafile);
        for (TestSample sample : sampleCollection) {
            Collections.sort(sample.getSample().getPolymorphisms());
            String fastaResult = Polymorphism.rCRS;
            int insertions = 0;
            int deletions = 0;
            System.out.println("sample " + sample.getSampleID());
            for (Polymorphism poly : sample.getSample().getPolymorphisms()) {
                poly.getPosition();
                if (poly.getMutation().toString().equals("INS")) {
                    for (int i = 0; i < poly.getInsertedPolys().length(); ++i) {
                        fastaResult = ExportUtils.insertChar(fastaResult, poly.getInsertedPolys().toString().charAt(i), poly.getPosition() - 1 + ++insertions - deletions);
                        System.out.println("!ins " + poly.getPosition() + " " + (Object)((Object)poly.getMutation()) + " " + poly.getInsertedPolys().toString());
                    }
                    continue;
                }
                if (poly.getMutation().toString().equals("DEL")) {
                    System.out.println(poly + " poly " + (Object)((Object)poly.getMutation()));
                    fastaResult = ExportUtils.deleteChar(fastaResult, poly.getPosition() - 1 + insertions - deletions);
                    ++deletions;
                    continue;
                }
                fastaResult = ExportUtils.replaceChar(fastaResult, poly.getMutation().toString().charAt(0), poly.getPosition() - 1 + insertions - deletions);
            }
            fasta.write(">" + sample.getSampleID() + "\n" + fastaResult + "\n");
        }
        fasta.close();
    }

    public static void generateFastaMSA(Collection<TestSample> sampleCollection, String out) throws IOException {
        String fasta = out + "_haplogrep2_MSA.fasta";
        FileWriter fastaMSA = new FileWriter(fasta);
        String result = "";
        long start = new Date().getTime();
        StringBuffer sbresult = new StringBuffer();
        Vector<Polymorphism> vectorPolys = new Vector<Polymorphism>();
        Vector<String> vectorhelp = new Vector<String>();
        Vector samplepoly = new Vector();
        Collections.sort((List)sampleCollection);
        if (sampleCollection != null) {
            for (TestSample sample : sampleCollection) {
                Vector<Polymorphism> v1 = new Vector<Polymorphism>();
                for (Polymorphism poly : sample.getSample().getPolymorphisms()) {
                    if (poly.getMutation().toString().length() == 1) {
                        v1.add(poly);
                    } else if (poly.getMutation().toString().contains("DEL")) {
                        v1.add(poly);
                    } else {
                        for (int i = 0; i < poly.getInsertedPolys().length(); ++i) {
                            try {
                                Polymorphism p1 = new Polymorphism(poly.getPosition() + ".1" + poly.getInsertedPolys().substring(1, i + 1) + poly.getInsertedPolys().charAt(i));
                                v1.add(p1);
                                continue;
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (InvalidPolymorphismException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (vectorhelp.contains(poly.toString())) continue;
                    if (poly.getMutation().toString().contains("INS")) {
                        String h = poly.getInsertedPolys().toString();
                        for (int i = 0; i < h.length(); ++i) {
                            Polymorphism p1 = null;
                            try {
                                p1 = new Polymorphism(poly.getPosition() + ".1" + h.substring(0, i + 1));
                                if (vectorhelp.contains(p1.toString())) continue;
                                vectorhelp.add(p1.toString());
                                vectorPolys.add(p1);
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        continue;
                    }
                    vectorhelp.add(poly.toString());
                    vectorPolys.add(poly);
                }
                Collections.sort(v1);
                samplepoly.add(v1);
            }
            Collections.sort(vectorPolys);
            int count = 0;
            Vector vsamplep = new Vector();
            for (TestSample sample : sampleCollection) {
                fastaMSA.write(">" + sample.getSampleID() + "_" + sample.getDetectedHaplogroup() + "\n");
                vsamplep.clear();
                vsamplep = (Vector)samplepoly.get(count);
                ++count;
                int j = 0;
                String fastaResult = Polymorphism.rCRS;
                int insertion = 0;
                for (int i = 0; i < vectorPolys.size(); ++i) {
                    if (j < vsamplep.size()) {
                        if (((Polymorphism)vsamplep.get(j)).getPosition() == ((Polymorphism)vectorPolys.get(i)).getPosition() && ((Polymorphism)vsamplep.get(j)).getMutation() == ((Polymorphism)vectorPolys.get(i)).getMutation()) {
                            String help = ((Polymorphism)vectorPolys.get(i)).getMutation().toString();
                            if (help.contains("DEL")) {
                                if (((Polymorphism)vsamplep.get(j)).getMutation().toString().charAt(0) == 'D') {
                                    fastaResult = ExportUtils.replaceChar(fastaResult, '-', ((Polymorphism)vectorPolys.get(i)).getPosition() - 1 + insertion);
                                }
                            } else if (help.equals("INS")) {
                                fastaResult = ExportUtils.insertChar(fastaResult, ((Polymorphism)vectorPolys.get(i)).getInsertedPolys().charAt(((Polymorphism)vectorPolys.get(i)).getInsertedPolys().length() - 1), ((Polymorphism)vectorPolys.get(i)).getPosition() + insertion);
                                ++insertion;
                            } else if (((Polymorphism)vsamplep.get(j)).getMutation().toString().charAt(0) != 'I') {
                                fastaResult = ExportUtils.replaceChar(fastaResult, ((Polymorphism)vsamplep.get(j)).getMutation().toString().charAt(0), ((Polymorphism)vectorPolys.get(i)).getPosition() - 1 + insertion);
                            }
                            ++j;
                            continue;
                        }
                        if (!((Polymorphism)vectorPolys.get(i)).getMutation().toString().equals("INS")) continue;
                        fastaResult = ExportUtils.insertChar(fastaResult, '-', ((Polymorphism)vectorPolys.get(i)).getPosition() + insertion);
                        ++insertion;
                        continue;
                    }
                    if (!((Polymorphism)vectorPolys.get(i)).getMutation().toString().equals("INS")) continue;
                    fastaResult = ExportUtils.insertChar(fastaResult, '-', ((Polymorphism)vectorPolys.get(i)).getPosition() + insertion);
                    ++insertion;
                }
                fastaMSA.write(fastaResult + "\n");
            }
        }
        fastaMSA.close();
    }

    public static String replaceChar(String data, char ch, int myIndex) {
        StringBuilder builderString = new StringBuilder(data);
        builderString.setCharAt(myIndex, ch);
        return builderString.toString();
    }

    public static String insertChar(String data, char ch, int myIndex) {
        return new StringBuffer(data).insert(myIndex, ch).toString();
    }

    public static String deleteChar(String data, int myIndex) {
        return data.substring(0, myIndex) + data.substring(myIndex + 1);
    }
}

