/*
 * Decompiled with CFR 0.152.
 */
package search;

import core.Polymorphism;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Element;
import phylotree.PhyloTreeNode;
import search.SearchResult;
import search.SearchResultTreeNode;

public class SearchResultDetailed
implements Serializable {
    private static final long serialVersionUID = 3578717605511291419L;
    static final Log log = LogFactory.getLog(SearchResultDetailed.class);
    private ArrayList<Polymorphism> expectedPolys;
    private ArrayList<Polymorphism> foundPolys;
    private ArrayList<Polymorphism> remainingPolys;
    private ArrayList<Polymorphism> remainingPolysNotInRange;
    private ArrayList<Polymorphism> correctedBackmutations;
    private ArrayList<Polymorphism> missingPolysOutOfRange;
    private ArrayList<SearchResultTreeNode> path = new ArrayList();
    private transient SearchResult searchResult;

    SearchResultDetailed(SearchResult searchResult) {
        this.searchResult = searchResult;
        this.expectedPolys = new ArrayList();
        this.foundPolys = new ArrayList();
        this.remainingPolys = new ArrayList();
        this.remainingPolysNotInRange = new ArrayList();
        this.correctedBackmutations = new ArrayList();
        this.missingPolysOutOfRange = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    void updateResult() {
        void var3_8;
        Polymorphism newPoly;
        for (PhyloTreeNode startNode = this.searchResult.getAttachedPhyloTreeNode(); startNode != null; startNode = startNode.getParent()) {
            SearchResultTreeNode newNode = new SearchResultTreeNode(startNode);
            for (Polymorphism polymorphism : startNode.getExpectedPolys()) {
                if (polymorphism.getMutation().equals("INS")) continue;
                if (this.searchResult.getSample().getSampleRanges().contains(polymorphism)) {
                    if (this.searchResult.getSample().containsWithBackmutation(polymorphism)) {
                        newNode.addFoundPoly(polymorphism);
                        newNode.addExpectedPoly(polymorphism);
                        if (polymorphism.isBackMutation()) {
                            this.correctedBackmutations.add(polymorphism);
                        }
                        this.expectedPolys.add(polymorphism);
                        continue;
                    }
                    newNode.addExpectedPoly(polymorphism);
                    if (polymorphism.isBackMutation()) {
                        this.correctedBackmutations.add(polymorphism);
                    }
                    newPoly = new Polymorphism(polymorphism);
                    newPoly.setBackMutation(!polymorphism.isBackMutation());
                    if (this.expectedPolys.contains(polymorphism) || this.expectedPolys.contains(newPoly)) continue;
                    this.expectedPolys.add(polymorphism);
                    continue;
                }
                if (polymorphism.isBackMutation()) {
                    newNode.addFoundPoly(polymorphism);
                    continue;
                }
                newNode.addNotInRangePoly(polymorphism);
                this.missingPolysOutOfRange.add(polymorphism);
            }
            this.path.add(newNode);
        }
        if (this.searchResult.getSample() != null) {
            this.remainingPolys.addAll(this.searchResult.getSample().getPolymorphisms());
        }
        for (SearchResultTreeNode searchResultTreeNode : this.path) {
            for (Polymorphism currentFoundPoly : searchResultTreeNode.getFoundPolys()) {
                this.foundPolys.add(currentFoundPoly);
                if (currentFoundPoly.isBackMutation()) continue;
                this.remainingPolys.remove(currentFoundPoly);
            }
        }
        ArrayList<Polymorphism> helper = new ArrayList<Polymorphism>();
        for (Polymorphism polymorphism : this.expectedPolys) {
            if (this.foundPolys.contains(polymorphism) || !polymorphism.isBackMutation() || !this.correctedBackmutations.contains(polymorphism)) continue;
            newPoly = new Polymorphism(polymorphism);
            newPoly.setBackMutation(false);
            helper.add(newPoly);
        }
        boolean bl = false;
        while (var3_8 < this.remainingPolys.size()) {
            if (!this.searchResult.getSample().getSampleRanges().contains(this.remainingPolys.get((int)var3_8))) {
                this.remainingPolysNotInRange.add(this.remainingPolys.get((int)var3_8));
            }
            ++var3_8;
        }
        this.remainingPolys.addAll(helper);
        Collections.reverse(this.path);
    }

    public double getSumWeightsRemainingTransitions() {
        double sumTransitions = 0.0;
        for (Polymorphism currentRemainingPoly : this.remainingPolys) {
            if (!currentRemainingPoly.isTransitionPoly()) continue;
            sumTransitions += 1.0;
        }
        for (Polymorphism current : this.expectedPolys) {
            if (this.foundPolys.contains(current) || !current.isTransitionPoly()) continue;
            sumTransitions += 1.0;
        }
        return sumTransitions;
    }

    public double getSumWeightsRemainingTransversion() {
        double sumTransversions = 0.0;
        for (Polymorphism currentRemainingPoly : this.remainingPolys) {
            if (currentRemainingPoly.isTransitionPoly()) continue;
            sumTransversions += 1.0;
        }
        for (Polymorphism current : this.expectedPolys) {
            if (this.foundPolys.contains(current) || current.isTransitionPoly()) continue;
            sumTransversions += 1.0;
        }
        return sumTransversions;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SearchResultDetailed)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.expectedPolys, ((SearchResultDetailed)other).expectedPolys)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.foundPolys, ((SearchResultDetailed)other).foundPolys)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.remainingPolys, ((SearchResultDetailed)other).remainingPolys)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.remainingPolysNotInRange, ((SearchResultDetailed)other).remainingPolysNotInRange)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.correctedBackmutations, ((SearchResultDetailed)other).correctedBackmutations)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.missingPolysOutOfRange, ((SearchResultDetailed)other).missingPolysOutOfRange)) {
            return false;
        }
        return Arrays.equals(this.path.toArray(), ((SearchResultDetailed)other).path.toArray());
    }

    private boolean arrayEqualsHelper(ArrayList<Polymorphism> array1, ArrayList<Polymorphism> array2) {
        for (Polymorphism currentPoly : array1) {
            if (array2.contains(currentPoly) || currentPoly.isBackMutation()) continue;
            return false;
        }
        return true;
    }

    public Element getUnusedPolysXML(boolean includeHotspots) {
        Element results = new Element("DetailedResults");
        Collections.sort(this.remainingPolys);
        ArrayList<Polymorphism> expectedPolysSuperGroup = new ArrayList<Polymorphism>();
        for (int i = 0; i < this.path.size() - 1; ++i) {
            expectedPolysSuperGroup.addAll(this.path.get(i).getExpectedPolys());
        }
        ArrayList<Polymorphism> unusedPolysWithBackmutations = new ArrayList<Polymorphism>();
        unusedPolysWithBackmutations.addAll(this.remainingPolys);
        Collections.sort(unusedPolysWithBackmutations);
        for (Polymorphism currentPoly : unusedPolysWithBackmutations) {
            Element result = new Element("DetailedResult");
            Element newUnusedPoly = new Element("unused");
            newUnusedPoly.setText(currentPoly.toStringShortVersion());
            Element reasonUnusedPoly = new Element("reasonUnused");
            if (this.remainingPolysNotInRange.contains(currentPoly)) {
                reasonUnusedPoly.setText("polyoutofrange");
                result.addContent((Content)newUnusedPoly);
                result.addContent((Content)reasonUnusedPoly);
                results.addContent((Content)result);
                continue;
            }
            if (this.searchResult.getPhyloTree().getMutationRate(currentPoly) == 0.0) {
                if (currentPoly.isBackMutation()) {
                    reasonUnusedPoly.setText("globalPrivateMutation");
                    newUnusedPoly.setText(Polymorphism.convertToATBackmutation(currentPoly.toStringShortVersion()));
                    result.addContent((Content)reasonUnusedPoly);
                    result.addContent((Content)newUnusedPoly);
                    results.addContent((Content)result);
                } else if (currentPoly.isMTHotspot()) {
                    if (includeHotspots) {
                        reasonUnusedPoly.setText("hotspot");
                        result.addContent((Content)reasonUnusedPoly);
                        result.addContent((Content)newUnusedPoly);
                        results.addContent((Content)result);
                    }
                } else {
                    if (currentPoly.isHeteroplasmy()) {
                        reasonUnusedPoly.setText("globalPrivateMutationHP");
                    } else {
                        reasonUnusedPoly.setText("globalPrivateMutation");
                    }
                    if (!currentPoly.equalsReference()) {
                        result.addContent((Content)reasonUnusedPoly);
                    } else if (currentPoly.isHeteroplasmy()) {
                        result.addContent((Content)reasonUnusedPoly.setText("rCRSHP"));
                    } else {
                        result.addContent((Content)reasonUnusedPoly.setText("rCRS"));
                    }
                    result.addContent((Content)newUnusedPoly);
                    results.addContent((Content)result);
                }
            } else {
                if (currentPoly.isHeteroplasmy()) {
                    reasonUnusedPoly.setText("localPrivateMutationHP");
                } else {
                    reasonUnusedPoly.setText("localPrivateMutation");
                }
                result.addContent((Content)newUnusedPoly);
                result.addContent((Content)reasonUnusedPoly);
                results.addContent((Content)result);
            }
            Element aac = new Element("aac");
            try {
                if (currentPoly.getAnnotation().getAminoAcidChange() != null) {
                    aac.setText(currentPoly.getAnnotation().getAminoAcidChange());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.addContent((Content)aac);
        }
        return results;
    }

    public Element getFoundNotFoundPolys() {
        Element newCorrectPoly;
        Element newExpectedPoly;
        Element result;
        Element results = new Element("DetailedResults");
        Collections.sort(this.expectedPolys);
        ArrayList<Polymorphism> unusedPolysArray = new ArrayList<Polymorphism>();
        unusedPolysArray.addAll(this.searchResult.getSample().getPolymorphisms());
        for (Polymorphism current : this.expectedPolys) {
            if (this.foundPolys.contains(current)) continue;
            result = new Element("DetailedResult");
            newExpectedPoly = new Element("expected");
            newExpectedPoly.setText(current.toStringShortVersion());
            result.addContent((Content)newExpectedPoly);
            newCorrectPoly = new Element("correct");
            newCorrectPoly.setText("no");
            result.addContent((Content)newCorrectPoly);
            results.addContent((Content)result);
        }
        for (Polymorphism current : this.expectedPolys) {
            if (!this.foundPolys.contains(current)) continue;
            result = new Element("DetailedResult");
            newExpectedPoly = new Element("expected");
            newExpectedPoly.setText(current.toStringShortVersion());
            result.addContent((Content)newExpectedPoly);
            newCorrectPoly = new Element("correct");
            newCorrectPoly.setText("yes");
            result.addContent((Content)newCorrectPoly);
            unusedPolysArray.remove(current);
            results.addContent((Content)result);
        }
        return results;
    }

    public ArrayList<Polymorphism> getFoundNotFoundPolysArray() {
        Collections.sort(this.expectedPolys);
        ArrayList<Polymorphism> results = new ArrayList<Polymorphism>();
        ArrayList<Polymorphism> unusedPolysArray = new ArrayList<Polymorphism>();
        unusedPolysArray.addAll(this.searchResult.getSample().getPolymorphisms());
        for (Polymorphism current : this.expectedPolys) {
            if (this.foundPolys.contains(current)) continue;
            results.add(current);
        }
        return results;
    }

    public Element getPhyloTreePathXML(boolean includeMissingPolys) {
        if (this.path.size() == 0) {
            return null;
        }
        Element root = null;
        Element currentEndNode = null;
        for (SearchResultTreeNode currentNode : this.path) {
            if (root == null) {
                currentEndNode = root = new Element("TreeNode");
                root.setAttribute("name", currentNode.getHaplogroup().toString());
                root.setAttribute("type", "Haplogroup");
            } else {
                Element newChildElement = new Element("TreeNode");
                newChildElement.setAttribute("name", currentNode.getHaplogroup().toString());
                newChildElement.setAttribute("type", "Haplogroup");
                currentEndNode.addContent((Content)newChildElement);
                currentEndNode = newChildElement;
            }
            Collections.sort(currentNode.getExpectedPolys());
            for (Polymorphism currentPoly : currentNode.getExpectedPolys()) {
                Element newChildElement;
                if (!currentNode.getFoundPolys().contains(currentPoly)) {
                    if (!includeMissingPolys) continue;
                    newChildElement = new Element("Poly");
                    newChildElement.setText("mis" + currentPoly.toStringShortVersion());
                    currentEndNode.addContent((Content)newChildElement);
                    continue;
                }
                newChildElement = new Element("Poly");
                newChildElement.setText(Polymorphism.convertToATBackmutation(currentPoly.toStringShortVersion()));
                currentEndNode.addContent((Content)newChildElement);
            }
        }
        return root;
    }

    public Element getNotInRangePolysXML() {
        Element results = new Element("OutOfRangePolys");
        Collections.sort(this.missingPolysOutOfRange);
        for (Polymorphism currentPoly : this.missingPolysOutOfRange) {
            Element result = new Element("OutOfRangePoly");
            Element newUnusedPoly = new Element("poly");
            newUnusedPoly.setText(currentPoly.toString());
            result.addContent((Content)newUnusedPoly);
            Element weightUnusedPoly = new Element("weight");
            weightUnusedPoly.setText(String.valueOf(this.searchResult.getPhyloTree().getMutationRate(currentPoly)));
            result.addContent((Content)weightUnusedPoly);
            results.addContent((Content)result);
        }
        return results;
    }

    public ArrayList<SearchResultTreeNode> getPhyloTreePath() {
        return this.path;
    }

    public ArrayList<Polymorphism> getRemainingPolysInSample() {
        return this.remainingPolys;
    }

    public ArrayList<Polymorphism> getCorrectedBackmutations() {
        return this.correctedBackmutations;
    }

    public ArrayList<Polymorphism> getFoundPolys() {
        return this.foundPolys;
    }

    public ArrayList<Polymorphism> getMissingPolysOutOfRange() {
        return this.missingPolysOutOfRange;
    }

    public ArrayList<Polymorphism> getExpectedPolys() {
        return this.expectedPolys;
    }
}

