/*
 * Decompiled with CFR 0.152.
 */
package search;

import core.Haplogroup;
import core.Polymorphism;
import core.Sample;
import core.TestSample;
import phylotree.PhyloTreeNode;
import phylotree.Phylotree;
import search.SearchResultDetailed;

public class SearchResult {
    private PhyloTreeNode attachedPhyloTreeNode;
    private Sample sampleChecked = null;
    private SearchResultDetailed detailedResult = null;
    private double sumWeightsAllPolysSample = 0.0;
    private double remainingPolysSumWeights = 0.0;
    private double foundPolysSumWeights = 0.0;
    private double expectedPolsysSumWeight = 0.0;
    private double missingPolysSumWeights = 0.0;
    private double missingSumWeightsPolysOutOfRange = 0.0;
    private double sumWeightedTransitions = 0.0;
    private double sumWeightedTransversions = 0.0;

    public SearchResult(PhyloTreeNode phyloNode, TestSample parentResult) {
        this.sampleChecked = parentResult.getSample();
        this.attachedPhyloTreeNode = phyloNode;
        for (Polymorphism currentPoly : this.sampleChecked.getPolymorphisms()) {
            if (!parentResult.getSample().getSampleRanges().contains(currentPoly)) continue;
            this.sumWeightsAllPolysSample += this.getPhyloTree().getMutationRate(currentPoly);
            this.remainingPolysSumWeights += this.getPhyloTree().getMutationRate(currentPoly);
        }
    }

    public SearchResult(PhyloTreeNode parentNode, SearchResult resultToCopy) {
        this.attachedPhyloTreeNode = parentNode;
        this.sampleChecked = resultToCopy.sampleChecked;
        this.sumWeightsAllPolysSample = resultToCopy.sumWeightsAllPolysSample;
        this.foundPolysSumWeights = resultToCopy.foundPolysSumWeights;
        this.expectedPolsysSumWeight = resultToCopy.expectedPolsysSumWeight;
        this.missingSumWeightsPolysOutOfRange = resultToCopy.missingSumWeightsPolysOutOfRange;
        this.remainingPolysSumWeights = resultToCopy.remainingPolysSumWeights;
        this.missingPolysSumWeights = resultToCopy.missingPolysSumWeights;
        this.sumWeightedTransitions = resultToCopy.sumWeightedTransitions;
        this.sumWeightedTransversions = resultToCopy.sumWeightedTransversions;
    }

    public Haplogroup getHaplogroup() {
        return this.attachedPhyloTreeNode.getHaplogroup();
    }

    public Sample getSample() {
        return this.sampleChecked;
    }

    public double getSumWeightsAllPolysSample() {
        return this.sumWeightsAllPolysSample;
    }

    public double getWeightFoundPolys() {
        return this.foundPolysSumWeights;
    }

    public double getExpectedWeightPolys() {
        return this.expectedPolsysSumWeight;
    }

    public void addFoundPolyWeight(Polymorphism newFoundPoly) {
        this.foundPolysSumWeights += this.getPhyloTree().getMutationRate(newFoundPoly);
        this.remainingPolysSumWeights -= this.getPhyloTree().getMutationRate(newFoundPoly);
        this.missingPolysSumWeights -= this.getPhyloTree().getMutationRate(newFoundPoly);
        if (newFoundPoly.isTransitionPoly()) {
            this.sumWeightedTransitions -= 1.0;
        } else {
            this.sumWeightedTransversions -= 1.0;
        }
    }

    public void removeFoundPolyWeight(Polymorphism polyToRemove, Sample sample) {
        if (polyToRemove.isBackMutation()) {
            Polymorphism newPoly = new Polymorphism(polyToRemove);
            newPoly.setBackMutation(false);
            if (sample.contains(newPoly) > 0) {
                this.foundPolysSumWeights -= this.getPhyloTree().getMutationRate(newPoly);
                this.remainingPolysSumWeights += this.getPhyloTree().getMutationRate(newPoly);
                if (newPoly.isTransitionPoly()) {
                    this.sumWeightedTransitions += 1.0;
                } else {
                    this.sumWeightedTransversions += 1.0;
                }
            }
        } else {
            this.foundPolysSumWeights -= this.getPhyloTree().getMutationRate(polyToRemove);
        }
    }

    public void addExpectedPolyWeight(Polymorphism newExpectedPoly) {
        this.expectedPolsysSumWeight += this.getPhyloTree().getMutationRate(newExpectedPoly);
        this.missingPolysSumWeights += this.getPhyloTree().getMutationRate(newExpectedPoly);
    }

    public void removeExpectedPolyWeight(Polymorphism polyToRemove) {
        Polymorphism newPoly = new Polymorphism(polyToRemove);
        newPoly.setBackMutation(false);
        this.expectedPolsysSumWeight -= this.getPhyloTree().getMutationRate(newPoly);
    }

    public void addMissingOutOfRangeWeight(Polymorphism outOfRangePoly) {
        this.missingSumWeightsPolysOutOfRange += this.getPhyloTree().getMutationRate(outOfRangePoly);
    }

    public void removeMissingOutOfRangeWeight(Polymorphism outOfRangePoly) {
        this.missingSumWeightsPolysOutOfRange -= this.getPhyloTree().getMutationRate(outOfRangePoly);
    }

    public double getSumMissingPhyloWeight() {
        return this.missingPolysSumWeights;
    }

    public double getWeightRemainingPolys() {
        return this.remainingPolysSumWeights;
    }

    public synchronized SearchResultDetailed getDetailedResult() {
        if (this.detailedResult == null) {
            this.detailedResult = new SearchResultDetailed(this);
            this.detailedResult.updateResult();
        }
        return this.detailedResult;
    }

    public PhyloTreeNode getAttachedPhyloTreeNode() {
        return this.attachedPhyloTreeNode;
    }

    public Phylotree getPhyloTree() {
        return this.attachedPhyloTreeNode.getTree();
    }

    public double getSumWeightedTransversions() {
        return this.sumWeightedTransversions;
    }

    public double getSumWeightedTransitions() {
        return this.sumWeightedTransitions;
    }
}

