/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.rules;

import core.Polymorphism;
import core.TestSample;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityWarning;
import qualityAssurance.rules.HaplogrepRule;
import search.SearchResult;

public class CheckForTooManyLocalPrivateMutationsHaploGroup
extends HaplogrepRule {
    static final Log log = LogFactory.getLog(CheckForTooManyLocalPrivateMutationsHaploGroup.class);
    HashMap<String, String> polyHG = new HashMap();

    public CheckForTooManyLocalPrivateMutationsHaploGroup(int priority) {
        super(priority);
    }

    @Override
    public void evaluate(QualityAssistent qualityAssistent, TestSample currentSample) {
        if (currentSample.getResults().size() != 0) {
            SearchResult topResult = currentSample.getResults().get(0).getSearchResult();
            int numLocalPrivateMuations = 0;
            StringBuffer sb = new StringBuffer();
            HashSet addHG = new HashSet();
            InputStream phyloFile = this.getClass().getClassLoader().getResourceAsStream("phylotree16.hsd.byPOS.txt");
            try {
                if (this.polyHG.isEmpty()) {
                    this.readHSD(phyloFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            String result = "";
            int max = 0;
            StringBuffer helpHGs = new StringBuffer();
            for (Polymorphism currentRemainingPoly : topResult.getDetailedResult().getRemainingPolysInSample()) {
                if (currentRemainingPoly.isMTHotspot() || qualityAssistent.getUsedPhyloTree().getMutationRate(currentRemainingPoly) == 0.0 || currentRemainingPoly.equalsReference()) continue;
                ++numLocalPrivateMuations;
                sb.append(currentRemainingPoly.toString() + " ");
                if (this.polyHG.containsKey(currentRemainingPoly.toString())) {
                    StringTokenizer st = new StringTokenizer(this.polyHG.get(currentRemainingPoly.toString()), ",");
                    while (st.hasMoreTokens()) {
                        String HG = st.nextToken();
                        if (map.containsKey(HG)) {
                            String count = (String)map.get(HG);
                            map.put(HG, count + "," + currentRemainingPoly.toString());
                            continue;
                        }
                        map.put(HG, currentRemainingPoly.toString());
                    }
                }
                for (Map.Entry entry : map.entrySet()) {
                    int count = StringUtils.countMatches((String)((String)entry.getValue()), (String)",");
                    if (count < 1 || max >= count) continue;
                    result = " - \t" + (count + 1) + "\t in \t" + (String)entry.getKey() + " \t[" + (String)entry.getValue() + "]\t ";
                    max = count;
                }
            }
            if (result.length() > 0) {
                qualityAssistent.addNewIssue(new QualityWarning(qualityAssistent, currentSample, numLocalPrivateMuations + " local private mutation(s) found " + result, IssueType.RECOMB2));
            }
        }
    }

    private void readHSD(InputStream fileHSD) throws IOException {
        String line;
        this.polyHG = new HashMap();
        BufferedReader br = new BufferedReader(new InputStreamReader(fileHSD));
        br.readLine();
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            String pos = st.nextToken();
            st.nextToken();
            st.nextToken();
            this.polyHG.put(pos, st.nextToken());
        }
        br.close();
    }

    @Override
    public void suppressIssues(QualityAssistent qualityAssistent, TestSample currentSample) {
    }
}

