/*
 * Decompiled with CFR 0.152.
 */
package phylotree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import phylotree.Phylotree;

public class PhylotreeManager {
    private Map<String, Phylotree> phylotreeMap = new HashMap<String, Phylotree>();
    private static PhylotreeManager instance = null;

    private PhylotreeManager() {
    }

    public static PhylotreeManager getInstance() {
        if (instance == null) {
            instance = new PhylotreeManager();
        }
        return instance;
    }

    public Phylotree getPhylotree(String phylotreePath, String phyloGeneticWeightsPath) {
        if (this.phylotreeMap.containsKey(phylotreePath)) {
            return this.phylotreeMap.get(phylotreePath);
        }
        InputStream phyloFile = this.getClass().getClassLoader().getResourceAsStream(phylotreePath);
        InputStream flucRates = this.getClass().getClassLoader().getResourceAsStream(phyloGeneticWeightsPath);
        try {
            if (phyloFile == null) {
                phyloFile = new FileInputStream(new File(phylotreePath));
                flucRates = new FileInputStream(new File(phyloGeneticWeightsPath));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Phylotree searchMananger = new Phylotree(phyloFile, flucRates);
        this.phylotreeMap.put(phylotreePath, searchMananger);
        return searchMananger;
    }
}

