/*
 * Decompiled with CFR 0.152.
 */
package importer;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.ArrayList;

public class VcfImporterOld {
    public ArrayList<String> load(File file, boolean chip) throws Exception {
        VCFFileReader vcfReader = new VCFFileReader(file, false);
        VCFHeader vcfHeader = vcfReader.getFileHeader();
        StringBuilder range = new StringBuilder();
        if (chip) {
            for (Object vc : vcfReader) {
                range.append(vc.getStart() + ";");
            }
            vcfReader.close();
        } else {
            range.append("1-16569");
        }
        ArrayList<StringBuilder> profiles = new ArrayList<StringBuilder>();
        for (String sample : vcfHeader.getSampleNamesInOrder()) {
            StringBuilder profile = new StringBuilder();
            profiles.add(profile.append(sample + "\t" + range + "\t?"));
        }
        for (VariantContext vc : vcfReader) {
            if (vc.getStart() > 16569) {
                System.out.println("Error! Position " + vc.getStart() + " outside the range. Please double check if VCF includes variants mapped to rCRS only.");
            }
            String reference = vc.getReference().getBaseString();
            int index = 0;
            for (String sample : vcfHeader.getSampleNamesInOrder()) {
                String hetFrequency;
                Genotype genotype = vc.getGenotype(sample);
                String genotypeString = genotype.getGenotypeString(true);
                if (genotype.getType() == GenotypeType.HOM_VAR) {
                    if (genotype.getPloidy() > 1) {
                        Allele altAllele = Allele.create((Allele)((Allele)genotype.getAlleles().get(0)), (boolean)false);
                        ArrayList<Allele> alleles = new ArrayList<Allele>();
                        alleles.add(altAllele);
                        genotype = new GenotypeBuilder(genotype).alleles(alleles).make();
                    }
                    if ((genotypeString = genotype.getGenotypeString(true)).length() == reference.length()) {
                        if (genotypeString.length() == 1) {
                            ((StringBuilder)profiles.get(index)).append("\t");
                            if (genotype.getGenotypeString().equals("*")) {
                                ((StringBuilder)profiles.get(index)).append(vc.getStart() + "d");
                            } else {
                                ((StringBuilder)profiles.get(index)).append(vc.getStart() + "" + genotypeString);
                            }
                        } else {
                            for (int i = 0; i < genotypeString.length(); ++i) {
                                if (reference.charAt(i) == genotypeString.charAt(i)) continue;
                                ((StringBuilder)profiles.get(index)).append("\t");
                                ((StringBuilder)profiles.get(index)).append(vc.getStart() + i + "" + genotypeString.charAt(i));
                                break;
                            }
                        }
                    } else if (reference.length() > genotypeString.length()) {
                        ((StringBuilder)profiles.get(index)).append("\t");
                        if (reference.length() - genotypeString.length() == 1) {
                            ((StringBuilder)profiles.get(index)).append(vc.getStart() + genotypeString.length() + "d");
                        } else {
                            ((StringBuilder)profiles.get(index)).append(vc.getStart() + genotypeString.length() + "-" + (vc.getStart() + reference.length() - 1) + "d");
                        }
                    } else if (reference.length() < genotypeString.length()) {
                        ((StringBuilder)profiles.get(index)).append("\t");
                        if (reference.length() == 1) {
                            ((StringBuilder)profiles.get(index)).append(vc.getStart() + "." + 1 + genotypeString.substring(reference.length(), genotypeString.length()));
                        } else {
                            ((StringBuilder)profiles.get(index)).append(vc.getStart() + "." + 1 + genotypeString.substring(0, genotypeString.length() - reference.length()));
                        }
                    }
                }
                if (genotype.getType() == GenotypeType.HET && genotype.hasAnyAttribute("HF") && Double.valueOf(hetFrequency = (String)vc.getGenotype(sample).getAnyAttribute("HF")) >= 0.96 && genotypeString.length() == reference.length()) {
                    if (genotypeString.length() == 1) {
                        ((StringBuilder)profiles.get(index)).append("\t");
                        ((StringBuilder)profiles.get(index)).append(vc.getStart() + "" + genotypeString);
                    } else {
                        for (int i = 0; i < genotypeString.length(); ++i) {
                            if (reference.charAt(i) == genotypeString.charAt(i)) continue;
                            ((StringBuilder)profiles.get(index)).append("\t");
                            ((StringBuilder)profiles.get(index)).append(vc.getStart() + i + "" + genotypeString.charAt(i));
                            break;
                        }
                    }
                }
                ++index;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (StringBuilder profile : profiles) {
            String profileString = profile.toString();
            if (profileString.split("\t").length > 3) {
                result.add(profileString);
                continue;
            }
            System.out.println("Info: Sample " + profileString.substring(0, profile.indexOf("\t")) + " excluded. No variants detected, assuming same haplogroup as the reference (rCRS: H2a2a1");
        }
        vcfReader.close();
        return result;
    }
}

