/*
 * Decompiled with CFR 0.152.
 */
package importer;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import vcf.Sample;
import vcf.Variant;

public class VcfImporter {
    public HashMap<String, Sample> load(File file, boolean chip) throws Exception {
        VCFFileReader vcfReader = new VCFFileReader(file, false);
        VCFHeader vcfHeader = vcfReader.getFileHeader();
        HashMap<String, Sample> samples = new HashMap<String, Sample>();
        StringBuilder range = new StringBuilder();
        if (chip) {
            for (VariantContext vc : vcfReader) {
                range.append(vc.getStart() + ";");
            }
            vcfReader.close();
        } else {
            range.append("1-16569");
        }
        for (VariantContext vc : vcfReader) {
            if (vc.getStart() > 16569) {
                System.out.println("Error! Position " + vc.getStart() + " outside the range. Please double check if VCF includes variants mapped to rCRS only.");
            }
            String reference = vc.getReference().getBaseString();
            for (String sampleVcf : vcfHeader.getSampleNamesInOrder()) {
                Genotype genotype;
                String sampleVcfFixed = sampleVcf.trim().replace("|", "_").replaceAll("\\s+", "");
                Sample sample = samples.get(sampleVcfFixed);
                if (sample == null) {
                    sample = new Sample();
                    sample.setId(sampleVcfFixed);
                    sample.setRange(range.toString());
                }
                if ((genotype = vc.getGenotype(sampleVcf)).getType() == GenotypeType.HOM_VAR) {
                    Variant variant;
                    String genotypeString;
                    if (genotype.getPloidy() > 1) {
                        Allele altAllele = Allele.create((Allele)((Allele)genotype.getAlleles().get(0)), (boolean)false);
                        ArrayList<Allele> alleles = new ArrayList<Allele>();
                        alleles.add(altAllele);
                        genotype = new GenotypeBuilder(genotype).alleles(alleles).make();
                    }
                    if ((genotypeString = genotype.getGenotypeString(true)).length() == reference.length()) {
                        if (genotypeString.length() == 1) {
                            char base = genotypeString.charAt(0);
                            Variant variant2 = new Variant();
                            variant2.setPos(vc.getStart());
                            variant2.setRef(reference.charAt(0));
                            if (genotype.getGenotypeString().equals("*")) {
                                variant2.setVariantBase('d');
                                variant2.setType(4);
                            } else {
                                variant2.setVariantBase(base);
                                variant2.setType(1);
                            }
                            if (genotype.hasAnyAttribute("DP")) {
                                int coverage = (Integer)vc.getGenotype(sampleVcf).getAnyAttribute("DP");
                                variant2.setCoverage(coverage);
                            }
                            sample.addVariant(variant2);
                        } else {
                            for (int i = 0; i < genotypeString.length(); ++i) {
                                if (reference.charAt(i) == genotypeString.charAt(i)) continue;
                                int pos = vc.getStart() + i;
                                char base = genotypeString.charAt(i);
                                variant = new Variant();
                                variant.setPos(pos);
                                variant.setRef(reference.charAt(0));
                                variant.setVariantBase(base);
                                variant.setType(1);
                                if (genotype.hasAnyAttribute("DP")) {
                                    int coverage = (Integer)vc.getGenotype(sampleVcf).getAnyAttribute("DP");
                                    variant.setCoverage(coverage);
                                }
                                sample.addVariant(variant);
                            }
                        }
                    } else if (reference.length() > genotypeString.length()) {
                        int diff = reference.length() - genotypeString.length();
                        for (int i = 0; i < diff; ++i) {
                            int pos = vc.getStart() + genotypeString.length() + i;
                            variant = new Variant();
                            variant.setPos(pos);
                            variant.setRef(reference.charAt(0));
                            variant.setVariantBase('d');
                            variant.setType(4);
                            sample.addVariant(variant);
                            if (!genotype.hasAnyAttribute("DP")) continue;
                            int coverage = (Integer)vc.getGenotype(sampleVcf).getAnyAttribute("DP");
                            variant.setCoverage(coverage);
                        }
                    } else if (reference.length() < genotypeString.length()) {
                        String insertion;
                        int pos;
                        Variant variant3 = new Variant();
                        if (reference.length() == 1) {
                            pos = vc.getStart();
                            variant3.setPos(pos);
                            variant3.setRef(reference.charAt(0));
                            variant3.setType(5);
                            insertion = pos + "." + 1 + genotypeString.substring(reference.length(), genotypeString.length());
                            variant3.setInsertion(insertion);
                            sample.addVariant(variant3);
                        } else {
                            pos = vc.getStart();
                            variant3.setPos(pos);
                            variant3.setRef(reference.charAt(0));
                            variant3.setType(5);
                            insertion = pos + "." + 1 + genotypeString.substring(0, genotypeString.length() - reference.length());
                            variant3.setInsertion(insertion);
                            sample.addVariant(variant3);
                        }
                        if (genotype.hasAnyAttribute("DP")) {
                            int coverage = (Integer)vc.getGenotype(sampleVcf).getAnyAttribute("DP");
                            variant3.setCoverage(coverage);
                        }
                    }
                } else if (genotype.getType() == GenotypeType.HET && genotype.hasAnyAttribute("AF")) {
                    char minor;
                    char major;
                    double minorLevel;
                    double majorLevel;
                    char var;
                    String afTag = (String)vc.getGenotype(sampleVcf).getAnyAttribute("AF");
                    String[] splits = afTag.split(",");
                    double hetFrequency = Double.valueOf(splits[0]);
                    double hetFrequencySecond = splits.length > 1 ? Double.valueOf(splits[1]) : 1.0 - hetFrequency;
                    char allele1 = ((Allele)genotype.getAlleles().get(0)).getBaseString().charAt(0);
                    char allele2 = ((Allele)genotype.getAlleles().get(1)).getBaseString().charAt(0);
                    if (allele1 == '*') {
                        allele1 = 'd';
                    }
                    if (allele2 == '*') {
                        allele2 = 'd';
                    }
                    if (allele1 == reference.charAt(0)) {
                        var = allele2;
                        if (hetFrequency >= 0.5) {
                            majorLevel = hetFrequency;
                            minorLevel = hetFrequencySecond;
                            major = allele2;
                            minor = allele1;
                        } else {
                            majorLevel = hetFrequencySecond;
                            minorLevel = hetFrequency;
                            major = allele1;
                            minor = allele2;
                        }
                    } else {
                        var = allele1;
                        majorLevel = hetFrequency;
                        minorLevel = hetFrequencySecond;
                        major = allele1;
                        minor = allele2;
                    }
                    Variant variant = new Variant();
                    int pos = vc.getStart();
                    variant.setPos(pos);
                    variant.setRef(reference.charAt(0));
                    variant.setVariantBase(var);
                    variant.setLevel(hetFrequency);
                    variant.setMajor(major);
                    variant.setMajorLevel(majorLevel);
                    variant.setMinor(minor);
                    variant.setMinorLevel(minorLevel);
                    variant.setType(2);
                    if (genotype.hasAnyAttribute("DP")) {
                        int coverage = (Integer)vc.getGenotype(sampleVcf).getAnyAttribute("DP");
                        variant.setCoverage(coverage);
                    }
                    sample.addVariant(variant);
                }
                samples.put(sampleVcfFixed, sample);
            }
        }
        vcfReader.close();
        return samples;
    }
}

