/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Polymorphism;
import exceptions.parse.sample.InvalidRangeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;

public class SampleRanges {
    private ArrayList<Integer> starts = new ArrayList();
    private ArrayList<Integer> ends = new ArrayList();
    static HashSet<Integer> metaboChipPositions = null;
    private int length;

    public SampleRanges() {
        if (metaboChipPositions == null) {
            metaboChipPositions = new HashSet();
        }
    }

    private void loadMetaboChipPositions() {
        try {
            InputStream phyloFile = this.getClass().getClassLoader().getResourceAsStream("metaboChipPositions");
            if (phyloFile == null) {
                phyloFile = new FileInputStream(new File("testDataFiles/metaboChipPositions"));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(phyloFile));
            String currentLine = reader.readLine();
            while (currentLine != null) {
                Scanner sc = new Scanner(currentLine);
                sc.next();
                sc.next();
                Integer newPosition = Integer.parseInt(sc.next().replace("mt", ""));
                metaboChipPositions.add(newPosition);
                currentLine = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SampleRanges(String rangesToParse, boolean splitRange16569) throws InvalidRangeException {
        if (rangesToParse.equals("")) {
            return;
        }
        String[] ranges = rangesToParse.split(";");
        this.length = ranges.length;
        for (int i = 0; i < ranges.length; ++i) {
            if (ranges[i].contains("-")) {
                String[] rangeParts = ranges[i].split("-");
                if (rangeParts.length != 2) {
                    throw new InvalidRangeException(rangesToParse);
                }
                int from = 0;
                int to = 0;
                try {
                    from = Integer.valueOf(rangeParts[0].trim());
                    to = Integer.valueOf(rangeParts[1].trim());
                }
                catch (NumberFormatException e) {
                    throw new InvalidRangeException(rangeParts[0] + " " + rangeParts[1]);
                }
                if (to > 16570 || from > 16570) {
                    throw new InvalidRangeException(to + " > " + from);
                }
                try {
                    if (from > to) {
                        if (splitRange16569) {
                            this.addCustomRange(from, 16569);
                            this.addCustomRange(1, to);
                            continue;
                        }
                        this.addCustomRange(Integer.parseInt(rangeParts[0].trim()), Integer.parseInt(rangeParts[1].trim()));
                        continue;
                    }
                    this.addCustomRange(Integer.parseInt(rangeParts[0].trim()), Integer.parseInt(rangeParts[1].trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidRangeException(rangesToParse);
                }
            }
            try {
                this.addCustomRange(Integer.parseInt(ranges[i].trim()), Integer.parseInt(ranges[i].trim()));
                continue;
            }
            catch (NumberFormatException e) {
                throw new InvalidRangeException(rangesToParse);
            }
        }
    }

    public void addCompleteRange() {
        this.starts.add(1);
        this.ends.add(16569);
    }

    public void addControlRange() {
        this.starts.add(16024);
        this.ends.add(16569);
        this.starts.add(1);
        this.ends.add(576);
    }

    public void addMetaboChipRange() {
        for (int currentMetaboPosition : metaboChipPositions) {
            this.starts.add(currentMetaboPosition);
            this.ends.add(currentMetaboPosition);
        }
    }

    public void addCustomRange(int newRangeStart, int newRangeEnd) {
        this.starts.add(newRangeStart);
        this.ends.add(newRangeEnd);
    }

    public boolean contains(Polymorphism polyToCheck) {
        return this.getSubrangeID(polyToCheck) != -1;
    }

    public ArrayList<Integer> getStarts() {
        return this.starts;
    }

    public ArrayList<Integer> getEnds() {
        return this.ends;
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.starts.size(); ++i) {
            result = this.starts.get(i) == this.ends.get(i) ? result + this.starts.get(i) + " ; " : result + this.starts.get(i) + "-" + this.ends.get(i) + " ; ";
        }
        return result.trim();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ends == null ? 0 : this.ends.hashCode());
        result = 31 * result + (this.starts == null ? 0 : this.starts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SampleRanges other = (SampleRanges)obj;
        if (this.ends == null) {
            if (other.ends != null) {
                return false;
            }
        } else {
            for (int i : this.ends) {
                if (other.ends.contains(i)) continue;
                return false;
            }
            for (int i : other.ends) {
                if (this.ends.contains(i)) continue;
                return false;
            }
        }
        if (this.starts == null) {
            for (int i : this.starts) {
                if (other.starts.contains(i)) continue;
                return false;
            }
        }
        if (this.starts == null) {
            for (int i : other.starts) {
                if (this.starts.contains(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMataboChipRange() {
        SampleRanges metaboChipRange = new SampleRanges();
        metaboChipRange.addMetaboChipRange();
        return metaboChipRange.equals(this);
    }

    public boolean isControlRange() {
        SampleRanges controlRange = new SampleRanges();
        controlRange.addControlRange();
        return controlRange.equals(this);
    }

    public boolean isCompleteRange() {
        SampleRanges completeRange = new SampleRanges();
        completeRange.addCompleteRange();
        return completeRange.equals(this);
    }

    public void clear() {
        this.starts.clear();
        this.ends.clear();
    }

    public boolean isCustomRange() {
        return !this.isCompleteRange() && !this.isControlRange() && !this.isMataboChipRange();
    }

    public int getSubrangeID(Polymorphism currentPoly) {
        int foundRangeID = -1;
        for (int i = 0; i < this.starts.size(); ++i) {
            if ((this.starts.get(i) > currentPoly.getPosition() || this.ends.get(i) < currentPoly.getPosition()) && (this.starts.get(i) <= this.ends.get(i) || this.starts.get(i) < currentPoly.getPosition() && this.ends.get(i) > currentPoly.getPosition())) continue;
            foundRangeID = i;
            break;
        }
        return foundRangeID;
    }

    public SampleRanges getSubrange(int i) {
        SampleRanges newSubrange = new SampleRanges();
        newSubrange.addCustomRange(this.starts.get(i), this.ends.get(i));
        return newSubrange;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

