/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Mutations;
import core.Polymorphism;
import core.SampleRanges;
import exceptions.parse.sample.InvalidPolymorphismException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sample {
    ArrayList<Polymorphism> sample = new ArrayList();
    private SampleRanges sampleRange = null;

    public Sample(String sampleToParse, SampleRanges sampleRange, int callMethod) throws InvalidPolymorphismException {
        String[] polyTokens = sampleToParse.trim().split("\\s+");
        ArrayList<String> listOfSampleTokens = new ArrayList<String>(Arrays.asList(polyTokens));
        this.sample = this.parseSample(listOfSampleTokens, callMethod);
        this.sampleRange = sampleRange;
    }

    public Sample(ArrayList<Polymorphism> polymorphisms, SampleRanges sampleRange) {
        this.sample = polymorphisms;
        this.sampleRange = sampleRange;
    }

    public ArrayList<Polymorphism> getPolymorphisms() {
        return this.sample;
    }

    public void setPolymorphisms(ArrayList<Polymorphism> sample) {
        this.sample = sample;
    }

    public int contains(Polymorphism polyToCheck) {
        for (Polymorphism currentPoly : this.sample) {
            if (currentPoly.isHeteroplasmy) {
                if (currentPoly.getPosition() != polyToCheck.getPosition() || (!currentPoly.getMutation().toString().equals("Y") || !polyToCheck.getMutation().toString().equals("C") && !polyToCheck.getMutation().toString().equals("T")) && (!currentPoly.getMutation().toString().equals("R") || !polyToCheck.getMutation().toString().equals("A") && !polyToCheck.getMutation().toString().equals("G"))) continue;
                return 2;
            }
            if (!currentPoly.equals(polyToCheck)) continue;
            return 1;
        }
        return 0;
    }

    public boolean containsWithBackmutation(Polymorphism polyToCheck) {
        boolean contains = false;
        if (polyToCheck.isBackMutation) {
            Polymorphism p = new Polymorphism(polyToCheck);
            p.setBackMutation(false);
            contains = this.sample.contains(p);
        } else {
            contains = this.sample.contains(polyToCheck);
        }
        if (!contains && polyToCheck.isBackMutation || contains && !polyToCheck.isBackMutation) {
            return true;
        }
        if (!contains && !polyToCheck.isBackMutation) {
            return false;
        }
        return false;
    }

    public String toString() {
        String result = "";
        for (Polymorphism currentPoly : this.sample) {
            result = result + currentPoly + " ";
        }
        return result.trim();
    }

    private ArrayList<Polymorphism> parseSample(ArrayList<String> sample, int callMethod) throws InvalidPolymorphismException {
        ArrayList<Polymorphism> filteredSample = new ArrayList<Polymorphism>();
        for (String currentPoly : sample) {
            Polymorphism newPoly;
            StringTokenizer st1;
            boolean isReliable = false;
            if (currentPoly.contains("|")) {
                if (currentPoly.contains("|1")) {
                    isReliable = true;
                }
                currentPoly = currentPoly.substring(0, currentPoly.length() - 2);
            }
            if (currentPoly.contains("5899.1d!") || currentPoly.contains("65.1T(T)")) continue;
            currentPoly = currentPoly.replace("(", "");
            if ((currentPoly = currentPoly.replace(")", "")).contains(".")) {
                if (callMethod == 0) {
                    if (currentPoly.contains(".1") && currentPoly.matches("\\d+\\.\\d\\w")) {
                        st1 = new StringTokenizer(currentPoly, ".");
                        String position = st1.nextToken();
                        String token1 = st1.nextToken().trim();
                        String newInsert = position + "." + token1;
                        StringBuffer buffer = new StringBuffer();
                        for (String currentPoly2 : sample) {
                            String token;
                            if (currentPoly2.contains("|")) {
                                if (currentPoly2.contains("|1")) {
                                    isReliable = true;
                                }
                                currentPoly2 = currentPoly2.substring(0, currentPoly2.length() - 2);
                            }
                            if (currentPoly2.equals(currentPoly) || !currentPoly2.contains(position + ".") || !position.equals(token = (st1 = new StringTokenizer(currentPoly2, ".")).nextToken())) continue;
                            token1 = st1.nextToken().trim();
                            Pattern p = Pattern.compile("\\d+");
                            Matcher m = p.matcher(token1);
                            m.find();
                            int ipos = Integer.parseInt(token1.substring(m.start(), m.end()));
                            if (buffer.length() < ipos - 1) {
                                buffer.setLength(ipos - 1);
                            }
                            if (ipos <= 0) continue;
                            buffer.setCharAt(ipos - 2, token1.charAt(m.end()));
                        }
                        if (!isReliable) {
                            filteredSample.add(new Polymorphism(newInsert + buffer.toString()));
                            continue;
                        }
                        filteredSample.add(new Polymorphism(newInsert + buffer.toString(), 1));
                        continue;
                    }
                    if (!currentPoly.matches("\\d+\\.1[a-zA-Z]{2,}")) continue;
                    newPoly = new Polymorphism(currentPoly);
                    filteredSample.add(newPoly);
                    continue;
                }
                newPoly = new Polymorphism(currentPoly);
                filteredSample.add(newPoly);
                continue;
            }
            if (currentPoly.contains("R")) {
                newPoly = new Polymorphism(currentPoly, true);
                filteredSample.add(newPoly);
                continue;
            }
            if (currentPoly.contains("Y")) {
                newPoly = new Polymorphism(currentPoly, true);
                filteredSample.add(newPoly);
                continue;
            }
            if (currentPoly.contains("-")) {
                st1 = new StringTokenizer(currentPoly, "-");
                String token = st1.nextToken();
                int startPosition = Integer.valueOf(token);
                token = st1.nextToken();
                int endPosition = Integer.valueOf(token.substring(0, token.length() - 1));
                for (int i = startPosition; i <= endPosition; ++i) {
                    if (!isReliable) {
                        filteredSample.add(new Polymorphism(i, Mutations.DEL));
                    } else {
                        filteredSample.add(new Polymorphism(i, Mutations.DEL, 1));
                    }
                    ++startPosition;
                }
                continue;
            }
            newPoly = !isReliable ? new Polymorphism(currentPoly) : new Polymorphism(currentPoly, 1);
            filteredSample.add(newPoly);
        }
        return filteredSample;
    }

    public SampleRanges getSampleRanges() {
        return this.sampleRange;
    }
}

