/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.AnnotationAAC;
import core.Mutations;
import exceptions.parse.sample.InvalidBaseException;
import exceptions.parse.sample.InvalidPolymorphismException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phylotree.Annotation;

public class Polymorphism
implements Comparable<Polymorphism>,
Serializable {
    private static final long serialVersionUID = 777223002615235532L;
    private int position;
    private Mutations mutation;
    boolean isBackMutation = false;
    private String numberOfIns = "";
    private String insertedPolys = "";
    boolean isHeteroplasmy = false;
    int isReliable = 0;
    private int hashCode;
    public static String rCRS = "gatcacaggtctatcaccctattaaccactcacgggagctctccatgcatttggtattttcgtctggggggtatgcacgcgatagcattgcgagacgctggagccggagcaccctatgtcgcagtatctgtctttgattcctgcctcatcctattatttatcgcacctacgttcaatattacaggcgaacatacttactaaagtgtgttaattaattaatgcttgtaggacataataataacaattgaatgtctgcacagccactttccacacagacatcataacaaaaaatttccaccaaaccccccctcccccgcttctggccacagcacttaaacacatctctgccaaaccccaaaaacaaagaaccctaacaccagcctaaccagatttcaaattttatcttttggcggtatgcacttttaacagtcaccccccaactaacacattattttcccctcccactcccatactactaatctcatcaatacaacccccgcccatcctacccagcacacacacaccgctgctaaccccataccccgaaccaaccaaaccccaaagacaccccccacagtttatgtagcttacctcctcaaagcaatacactgaaaatgtttagacgggctcacatcaccccataaacaaataggtttggtcctagcctttctattagctcttagtaagattacacatgcaagcatccccgttccagtgagttcaccctctaaatcaccacgatcaaaaggaacaagcatcaagcacgcagcaatgcagctcaaaacgcttagcctagccacacccccacgggaaacagcagtgattaacctttagcaataaacgaaagtttaactaagctatactaaccccagggttggtcaatttcgtgccagccaccgcggtcacacgattaacccaagtcaatagaagccggcgtaaagagtgttttagatcaccccctccccaataaagctaaaactcacctgagttgtaaaaaactccagttgacacaaaatagactacgaaagtggctttaacatatctgaacacacaatagctaagacccaaactgggattagataccccactatgcttagccctaaacctcaacagttaaatcaacaaaactgctcgccagaacactacgagccacagcttaaaactcaaaggacctggcggtgcttcatatccctctagaggagcctgttctgtaatcgataaaccccgatcaacctcaccacctcttgctcagcctatataccgccatcttcagcaaaccctgatgaaggctacaaagtaagcgcaagtacccacgtaaagacgttaggtcaaggtgtagcccatgaggtggcaagaaatgggctacattttctaccccagaaaactacgatagcccttatgaaacttaagggtcgaaggtggatttagcagtaaactaagagtagagtgcttagttgaacagggccctgaagcgcgtacacaccgcccgtcaccctcctcaagtatacttcaaaggacatttaactaaaacccctacgcatttatatagaggagacaagtcgtaacatggtaagtgtactggaaagtgcacttggacgaaccagagtgtagcttaacacaaagcacccaacttacacttaggagatttcaacttaacttgaccgctctgagctaaacctagccccaaacccactccaccttactaccagacaaccttagccaaaccatttacccaaataaagtataggcgatagaaattgaaacctggcgcaatagatatagtaccgcaagggaaagatgaaaaattataaccaagcataatatagcaaggactaacccctataccttctgcataatgaattaactagaaataactttgcaaggagagccaaagctaagacccccgaaaccagacgagctacctaagaacagctaaaagagcacacccgtctatgtagcaaaatagtgggaagatttataggtagaggcgacaaacctaccgagcctggtgatagctggttgtccaagatagaatcttagttcaactttaaatttgcccacagaaccctctaaatccccttgtaaatttaactgttagtccaaagaggaacagctctttggacactaggaaaaaaccttgtagagagagtaaaaaatttaacacccatagtaggcctaaaagcagccaccaattaagaaagcgttcaagctcaacacccactacctaaaaaatcccaaacatataactgaactcctcacacccaattggaccaatctatcaccctatagaagaactaatgttagtataagtaacatgaaaacattctcctccgcataagcctgcgtcagattaaaacactgaactgacaattaacagcccaatatctacaatcaaccaacaagtcattattaccctcactgtcaacccaacacaggcatgctcataaggaaaggttaaaaaaagtaaaaggaactcggcaaatcttaccccgcctgtttaccaaaaacatcacctctagcatcaccagtattagaggcaccgcctgcccagtgacacatgtttaacggccgcggtaccctaaccgtgcaaaggtagcataatcacttgttccttaaatagggacctgtatgaatggctccacgagggttcagctgtctcttacttttaaccagtgaaattgacctgcccgtgaagaggcgggcataacacagcaagacgagaagaccctatggagctttaatttattaatgcaaacagtacctaacaaacccacaggtcctaaactaccaaacctgcattaaaaatttcggttggggcgacctcggagcagaacccaacctccgagcagtacatgctaagacttcaccagtcaaagcgaactactatactcaattgatccaataacttgaccaacggaacaagttaccctagggataacagcgcaatcctattctagagtccatatcaacaatagggtttacgacctcgatgttggatcaggacatcccgatggtgcagccgctattaaaggttcgtttgttcaacgattaaagtcctacgtgatctgagttcagaccggagtaatccaggtcggtttctatctacnttcaaattcctccctgtacgaaaggacaagagaaataaggcctacttcacaaagcgccttcccccgtaaatgatatcatctcaacttagtattatacccacacccacccaagaacagggtttgttaagatggcagagcccggtaatcgcataaaacttaaaactttacagtcagaggttcaattcctcttcttaacaacatacccatggccaacctcctactcctcattgtacccattctaatcgcaatggcattcctaatgcttaccgaacgaaaaattctaggctatatacaactacgcaaaggccccaacgttgtaggcccctacgggctactacaacccttcgctgacgccataaaactcttcaccaaagagcccctaaaacccgccacatctaccatcaccctctacatcaccgccccgaccttagctctcaccatcgctcttctactatgaacccccctccccatacccaaccccctggtcaacctcaacctaggcctcctatttattctagccacctctagcctagccgtttactcaatcctctgatcagggtgagcatcaaactcaaactacgccctgatcggcgcactgcgagcagtagcccaaacaatctcatatgaagtcaccctagccatcattctactatcaacattactaataagtggctcctttaacctctccacccttatcacaacacaagaacacctctgattactcctgccatcatgacccttggccataatatgatttatctccacactagcagagaccaaccgaacccccttcgaccttgccgaaggggagtccgaactagtctcaggcttcaacatcgaatacgccgcaggccccttcgccctattcttcatagccgaatacacaaacattattataataaacaccctcaccactacaatcttcctaggaacaacatatgacgcactctcccctgaactctacacaacatattttgtcaccaagaccctacttctaacctccctgttcttatgaattcgaacagcatacccccgattccgctacgaccaactcatacacctcctatgaaaaaacttcctaccactcaccctagcattacttatatgatatgtctccatacccattacaatctccagcattccccctcaaacctaagaaatatgtctgataaaagagttactttgatagagtaaataataggagcttaaacccccttatttctaggactatgagaatcgaacccatccctgagaatccaaaattctccgtgccacctatcacaccccatcctaaagtaaggtcagctaaataagctatcgggcccataccccgaaaatgttggttatacccttcccgtactaattaatcccctggcccaacccgtcatctactctaccatctttgcaggcacactcatcacagcgctaagctcgcactgattttttacctgagtaggcctagaaataaacatgctagcttttattccagttctaaccaaaaaaataaaccctcgttccacagaagctgccatcaagtatttcctcacgcaagcaaccgcatccataatccttctaatagctatcctcttcaacaatatactctccggacaatgaaccataaccaatactaccaatcaatactcatcattaataatcataatagctatagcaataaaactaggaatagccccctttcacttctgagtcccagaggttacccaaggcacccctctgacatccggcctgcttcttctcacatgacaaaaactagcccccatctcaatcatataccaaatctctccctcactaaacgtaagccttctcctcactctctcaatcttatccatcatagcaggcagttgaggtggattaaaccaaacccagctacgcaaaatcttagcatactcctcaattacccacataggatgaataatagcagttctaccgtacaaccctaacataaccattcttaatttaactatttatattatcctaactactaccgcattcctactactcaacttaaactccagcaccacgaccctactactatctcgcacctgaaacaagctaacatgactaacacccttaattccatccaccctcctctccctaggaggcctgcccccgctaaccggctttttgcccaaatgggccattatcgaagaattcacaaaaaacaatagcctcatcatccccaccatcatagccaccatcaccctccttaacctctacttctacctacgcctaatctactccacctcaatcacactactccccatatctaacaacgtaaaaataaaatgacagtttgaacatacaaaacccaccccattcctccccacactcatcgcccttaccacgctactcctacctatctccccttttatactaataatcttatagaaatttaggttaaatacagaccaagagccttcaaagccctcagtaagttgcaatacttaatttctgtaacagctaaggactgcaaaaccccactctgcatcaactgaacgcaaatcagccactttaattaagctaagcccttactagaccaatgggacttaaacccacaaacacttagttaacagctaagcaccctaatcaactggcttcaatctacttctcccgccgccgggaaaaaaggcgggagaagccccggcaggtttgaagctgcttcttcgaatttgcaattcaatatgaaaatcacctcggagctggtaaaaagaggcctaacccctgtctttagatttacagtccaatgcttcactcagccattttacctcacccccactgatgttcgccgaccgttgactattctctacaaaccacaaagacattggaacactatacctattattcggcgcatgagctggagtcctaggcacagctctaagcctccttattcgagccgagctgggccagccaggcaaccttctaggtaacgaccacatctacaacgttatcgtcacagcccatgcatttgtaataatcttcttcatagtaatacccatcataatcggaggctttggcaactgactagttcccctaataatcggtgcccccgatatggcgtttccccgcataaacaacataagcttctgactcttacctccctctctcctactcctgctcgcatctgctatagtggaggccggagcaggaacaggttgaacagtctaccctcccttagcagggaactactcccaccctggagcctccgtagacctaaccatcttctccttacacctagcaggtgtctcctctatcttaggggccatcaatttcatcacaacaattatcaatataaaaccccctgccataacccaataccaaacgcccctcttcgtctgatccgtcctaatcacagcagtcctacttctcctatctctcccagtcctagctgctggcatcactatactactaacagaccgcaacctcaacaccaccttcttcgaccccgccggaggaggagaccccattctataccaacacctattctgatttttcggtcaccctgaagtttatattcttatcctaccaggcttcggaataatctcccatattgtaacttactactccggaaaaaaagaaccatttggatacataggtatggtctgagctatgatatcaattggcttcctagggtttatcgtgtgagcacaccatatatttacagtaggaatagacgtagacacacgagcatatttcacctccgctaccataatcatcgctatccccaccggcgtcaaagtatttagctgactcgccacactccacggaagcaatatgaaatgatctgctgcagtgctctgagccctaggattcatctttcttttcaccgtaggtggcctgactggcattgtattagcaaactcatcactagacatcgtactacacgacacgtactacgttgtagcccacttccactatgtcctatcaataggagctgtatttgccatcataggaggcttcattcactgatttcccctattctcaggctacaccctagaccaaacctacgccaaaatccatttcactatcatattcatcggcgtaaatctaactttcttcccacaacactttctcggcctatccggaatgccccgacgttactcggactaccccgatgcatacaccacatgaaacatcctatcatctgtaggctcattcatttctctaacagcagtaatattaataattttcatgatttgagaagccttcgcttcgaagcgaaaagtcctaatagtagaagaaccctccataaacctggagtgactatatggatgccccccaccctaccacacattcgaagaacccgtatacataaaatctagacaaaaaaggaaggaatcgaaccccccaaagctggtttcaagccaaccccatggcctccatgactttttcaaaaaggtattagaaaaaccatttcataactttgtcaaagttaaattataggctaaatcctatatatcttaatggcacatgcagcgcaagtaggtctacaagacgctacttcccctatcatagaagagcttatcacctttcatgatcacgccctcataatcattttccttatctgcttcctagtcctgtatgcccttttcctaacactcacaacaaaactaactaatactaacatctcagacgctcaggaaatagaaaccgtctgaactatcctgcccgccatcatcctagtcctcatcgccctcccatccctacgcatcctttacataacagacgaggtcaacgatccctcccttaccatcaaatcaattggccaccaatggtactgaacctacgagtacaccgactacggcggactaatcttcaactcctacatacttcccccattattcctagaaccaggcgacctgcgactccttgacgttgacaatcgagtagtactcccgattgaagcccccattcgtataataattacatcacaagacgtcttgcactcatgagctgtccccacattaggcttaaaaacagatgcaattcccggacgtctaaaccaaaccactttcaccgctacacgaccgggggtatactacggtcaatgctctgaaatctgtggagcaaaccacagtttcatgcccatcgtcctagaattaattcccctaaaaatctttgaaatagggcccgtatttaccctatagcaccccctctaccccctctagagcccactgtaaagctaacttagcattaaccttttaagttaaagattaagagaaccaacacctctttacagtgaaatgccccaactaaatactaccgtatggcccaccataattacccccatactccttacactattcctcatcacccaactaaaaatattaaacacaaactaccacctacctccctcaccaaagcccataaaaataaaaaattataacaaaccctgagaaccaaaatgaacgaaaatctgttcgcttcattcattgcccccacaatcctaggcctacccgccgcagtactgatcattctatttccccctctattgatccccacctccaaatatctcatcaacaaccgactaatcaccacccaacaatgactaatcaaactaacctcaaaacaaatgataaccatacacaacactaaaggacgaacctgatctcttatactagtatccttaatcatttttattgccacaactaacctcctcggactcctgcctcactcatttacaccaaccacccaactatctataaacctagccatggccatccccttatgagcgggcacagtgattataggctttcgctctaagattaaaaatgccctagcccacttcttaccacaaggcacacctacaccccttatccccatactagttattatcgaaaccatcagcctactcattcaaccaatagccctggccgtacgcctaaccgctaacattactgcaggccacctactcatgcacctaattggaagcgccaccctagcaatatcaaccattaaccttccctctacacttatcatcttcacaattctaattctactgactatcctagaaatcgctgtcgccttaatccaagcctacgttttcacacttctagtaagcctctacctgcacgacaacacataatgacccaccaatcacatgcctatcatatagtaaaacccagcccatgacccctaacaggggccctctcagccctcctaatgacctccggcctagccatgtgatttcacttccactccataacgctcctcatactaggcctactaaccaacacactaaccatataccaatgatggcgcgatgtaacacgagaaagcacataccaaggccaccacacaccacctgtccaaaaaggccttcgatacgggataatcctatttattacctcagaagtttttttcttcgcaggatttttctgagccttttaccactccagcctagcccctaccccccaattaggagggcactggcccccaacaggcatcaccccgctaaatcccctagaagtcccactcctaaacacatccgtattactcgcatcaggagtatcaatcacctgagctcaccatagtctaatagaaaacaaccgaaaccaaataattcaagcactgcttattacaattttactgggtctctattttaccctcctacaagcctcagagtacttcgagtctcccttcaccatttccgacggcatctacggctcaacattttttgtagccacaggcttccacggacttcacgtcattattggctcaactttcctcactatctgcttcatccgccaactaatatttcactttacatccaaacatcactttggcttcgaagccgccgcctgatactggcattttgtagatgtggtttgactatttctgtatgtctccatctattgatgagggtcttactcttttagtataaatagtaccgttaacttccaattaactagttttgacaacattcaaaaaagagtaataaacttcgccttaattttaataatcaacaccctcctagccttactactaataattattacattttgactaccacaactcaacggctacatagaaaaatccaccccttacgagtgcggcttcgaccctatatcccccgcccgcgtccctttctccataaaattcttcttagtagctattaccttcttattatttgatctagaaattgccctccttttacccctaccatgagccctacaaacaactaacctgccactaatagttatgtcatccctcttattaatcatcatcctagccctaagtctggcctatgagtgactacaaaaaggattagactgaaccgaattggtatatagtttaaacaaaacgaatgatttcgactcattaaattatgataatcatatttaccaaatgcccctcatttacataaatattatactagcatttaccatctcacttctaggaatactagtatatcgctcacacctcatatcctccctactatgcctagaaggaataatactatcgctgttcattatagctactctcataaccctcaacacccactccctcttagccaatattgtgcctattgccatactagtctttgccgcctgcgaagcagcggtgggcctagccctactagtctcaatctccaacacatatggcctagactacgtacataacctaaacctactccaatgctaaaactaatcgtcccaacaattatattactaccactgacatgactttccaaaaaacacataatttgaatcaacacaaccacccacagcctaattattagcatcatccctctactattttttaaccaaatcaacaacaacctatttagctgttccccaaccttttcctccgaccccctaacaacccccctcctaatactaactacctgactcctacccctcacaatcatggcaagccaacgccacttatccagtgaaccactatcacgaaaaaaactctacctctctatactaatctccctacaaatctccttaattataacattcacagccacagaactaatcatattttatatcttcttcgaaaccacacttatccccaccttggctatcatcacccgatgaggcaaccagccagaacgcctgaacgcaggcacatacttcctattctacaccctagtaggctcccttcccctactcatcgcactaatttacactcacaacaccctaggctcactaaacattctactactcactctcactgcccaagaactatcaaactcctgagccaacaacttaatatgactagcttacacaatagcttttatagtaaagatacctctttacggactccacttatgactccctaaagcccatgtcgaagcccccatcgctgggtcaatagtacttgccgcagtactcttaaaactaggcggctatggtataatacgcctcacactcattctcaaccccctgacaaaacacatagcctaccccttccttgtactatccctatgaggcataattataacaagctccatctgcctacgacaaacagacctaaaatcgctcattgcatactcttcaatcagccacatagccctcgtagtaacagccattctcatccaaaccccctgaagcttcaccggcgcagtcattctcataatcgcccacgggcttacatcctcattactattctgcctagcaaactcaaactacgaacgcactcacagtcgcatcataatcctctctcaaggacttcaaactctactcccactaatagctttttgatgacttctagcaagcctcgctaacctcgccttaccccccactattaacctactgggagaactctctgtgctagtaaccacgttctcctgatcaaatatcactctcctacttacaggactcaacatactagtcacagccctatactccctctacatatttaccacaacacaatggggctcactcacccaccacattaacaacataaaaccctcattcacacgagaaaacaccctcatgttcatacacctatcccccattctcctcctatccctcaaccccgacatcattaccgggttttcctcttgtaaatatagtttaaccaaaacatcagattgtgaatctgacaacagaggcttacgaccccttatttaccgagaaagctcacaagaactgctaactcatgcccccatgtctaacaacatggctttctcaacttttaaaggataacagctatccattggtcttaggccccaaaaattttggtgcaactccaaataaaagtaataaccatgcacactactataaccaccctaaccctgacttccctaattccccccatccttaccaccctcgttaaccctaacaaaaaaaactcatacccccattatgtaaaatccattgtcgcatccacctttattatcagtctcttccccacaacaatattcatgtgcctagaccaagaagttattatctcgaactgacactgagccacaacccaaacaacccagctctccctaagcttcaaactagactacttctccataatattcatccctgtagcattgttcgttacatggtccatcatagaattctcactgtgatatataaactcagacccaaacattaatcagttcttcaaatatctactcatcttcctaattaccatactaatcttagttaccgctaacaacctattccaactgttcatcggctgagagggcgtaggaattatatccttcttgctcatcagttgatgatacgcccgagcagatgccaacacagcagccattcaagcaatcctatacaaccgtatcggcgatatcggtttcatcctcgccttagcatgatttatcctacactccaactcatgagacccacaacaaatagcccttctaaacgctaatccaagcctcaccccactactaggcctcctcctagcagcagcaggcaaatcagcccaattaggtctccacccctgactcccctcagccatagaaggccccaccccagtctcagccctactccactcaagcactatagttgtagcaggaatcttcttactcatccgcttccaccccctagcagaaaatagcccactaatccaaactctaacactatgcttaggcgctatcaccactctgttcgcagcagtctgcgcccttacacaaaatgacatcaaaaaaatcgtagccttctccacttcaagtcaactaggactcataatagttacaatcggcatcaaccaaccacacctagcattcctgcacatctgtacccacgccttcttcaaagccatactatttatgtgctccgggtccatcatccacaaccttaacaatgaacaagatattcgaaaaataggaggactactcaaaaccatacctctcacttcaacctccctcaccattggcagcctagcattagcaggaatacctttcctcacaggtttctactccaaagaccacatcatcgaaaccgcaaacatatcatacacaaacgcctgagccctatctattactctcatcgctacctccctgacaagcgcctatagcactcgaataattcttctcaccctaacaggtcaacctcgcttccccacccttactaacattaacgaaaataaccccaccctactaaaccccattaaacgcctggcagccggaagcctattcgcaggatttctcattactaacaacatttcccccgcatcccccttccaaacaacaatccccctctacctaaaactcacagccctcgctgtcactttcctaggacttctaacagccctagacctcaactacctaaccaacaaacttaaaataaaatccccactatgcacattttatttctccaacatactcggattctaccctagcatcacacaccgcacaatcccctatctaggccttcttacgagccaaaacctgcccctactcctcctagacctaacctgactagaaaagctattacctaaaacaatttcacagcaccaaatctccacctccatcatcacctcaacccaaaaaggcataattaaactttacttcctctctttcttcttcccactcatcctaaccctactcctaatcacataacctattcccccgagcaatctcaattacaatatatacaccaacaaacaatgttcaaccagtaactactactaatcaacgcccataatcatacaaagcccccgcaccaataggatcctcccgaatcaaccctgacccctctccttcataaattattcagcttcctacactattaaagtttaccacaaccaccaccccatcatactctttcacccacagcaccaatcctacctccatcgctaaccccactaaaacactcaccaagacctcaacccctgacccccatgcctcaggatactcctcaatagccatcgctgtagtatatccaaagacaaccatcattccccctaaataaattaaaaaaactattaaacccatataacctcccccaaaattcagaataataacacacccgaccacaccgctaacaatcaatactaaacccccataaataggagaaggcttagaagaaaaccccacaaaccccattactaaacccacactcaacagaaacaaagcatacatcattattctcgcacggactacaaccacgaccaatgatatgaaaaaccatcgttgtatttcaactacaagaacaccaatgaccccaatacgcaaaactaaccccctaataaaattaattaaccactcattcatcgacctccccaccccatccaacatctccgcatgatgaaacttcggctcactccttggcgcctgcctgatcctccaaatcaccacaggactattcctagccatgcactactcaccagacgcctcaaccgccttttcatcaatcgcccacatcactcgagacgtaaattatggctgaatcatccgctaccttcacgccaatggcgcctcaatattctttatctgcctcttcctacacatcgggcgaggcctatattacggatcatttctctactcagaaacctgaaacatcggcattatcctcctgcttgcaactatagcaacagccttcataggctatgtcctcccgtgaggccaaatatcattctgaggggccacagtaattacaaacttactatccgccatcccatacattgggacagacctagttcaatgaatctgaggaggctactcagtagacagtcccaccctcacacgattctttacctttcacttcatcttgcccttcattattgcagccctagcaacactccacctcctattcttgcacgaaacgggatcaaacaaccccctaggaatcacctcccattccgataaaatcaccttccacccttactacacaatcaaagacgccctcggcttacttctcttccttctctccttaatgacattaacactattctcaccagacctcctaggcgacccagacaattataccctagccaaccccttaaacacccctccccacatcaagcccgaatgatatttcctattcgcctacacaattctccgatccgtccctaacaaactaggaggcgtccttgccctattactatccatcctcatcctagcaataatccccatcctccatatatccaaacaacaaagcataatatttcgcccactaagccaatcactttattgactcctagccgcagacctcctcattctaacctgaatcggaggacaaccagtaagctacccttttaccatcattggacaagtagcatccgtactatacttcacaacaatcctaatcctaataccaactatctccctaattgaaaacaaaatactcaaatgggcctgtccttgtagtataaactaatacaccagtcttgtaaaccggagatgaaaacctttttccaaggacaaatcagagaaaaagtctttaactccaccattagcacccaaagctaagattctaatttaaactattctctgttctttcatggggaagcagatttgggtaccacccaagtattgactcacccatcaacaaccgctatgtatttcgtacattactgccagccaccatgaatattgtacggtaccataaatacttgaccacctgtagtacataaaaacccaatccacatcaaaaccccctccccatgcttacaagcaagtacagcaatcaaccctcaactatcacacatcaactgcaactccaaagccacccctcacccactaggataccaacaaacctacccacccttaacagtacatagtacataaagccatttaccgtacatagcacattacagtcaaatcccttctcgtccccatggatgacccccctcagataggggtcccttgaccaccatcctccgtgaaatcaatatcccgcacaagagtgctactctcctcgctccgggcccataacacttgggggtagctaaagtgaactgtatccgacatctggttcctacttcagggtcataaagcctaaatagcccacacgttccccttaaataagacatcacgatg";

    Polymorphism(int newPosition, Mutations mutatedBase) {
        this.mutation = mutatedBase;
        this.position = newPosition;
        this.hashCode = this.toString().hashCode();
    }

    Polymorphism(int newPosition, Mutations mutatedBase, int isReliable) {
        this.mutation = mutatedBase;
        this.position = newPosition;
        this.hashCode = this.toString().hashCode();
        this.setReliable(isReliable);
    }

    public Polymorphism(String phyloString) throws InvalidPolymorphismException {
        this.parse(phyloString);
        this.hashCode = this.toString().hashCode();
        this.setHeteroplasmy(false);
    }

    public Polymorphism(String phyloString, int isReliable) throws InvalidPolymorphismException {
        this.parse(phyloString);
        this.hashCode = this.toString().hashCode();
        this.setHeteroplasmy(false);
        this.setReliable(isReliable);
    }

    public Polymorphism(String phyloString, boolean Heteroplasmy) throws InvalidPolymorphismException {
        this.parse(phyloString);
        this.setHeteroplasmy(Heteroplasmy);
        this.hashCode = this.toString().hashCode();
    }

    public Polymorphism(Polymorphism polyToCopy) {
        this.position = polyToCopy.position;
        this.mutation = polyToCopy.mutation;
        this.isBackMutation = polyToCopy.isBackMutation;
        this.numberOfIns = polyToCopy.numberOfIns;
        this.insertedPolys = polyToCopy.insertedPolys;
        this.isHeteroplasmy = polyToCopy.isHeteroplasmy;
        this.hashCode = this.toString().hashCode();
    }

    public String toString() {
        if (this.position > 16569) {
            return "";
        }
        if (this.position != 0) {
            if (!this.isBackMutation && !this.mutation.equals("N")) {
                if (this.mutation == Mutations.INS) {
                    return this.position + this.numberOfIns + this.insertedPolys;
                }
                if (this.mutation == Mutations.DEL) {
                    return this.position + "d";
                }
                return this.position + this.mutation.toString().trim();
            }
            return this.position + this.mutation.toString().trim() + "!";
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polymorphism other = (Polymorphism)obj;
        if (this.isBackMutation != other.isBackMutation) {
            return false;
        }
        if (this.mutation != other.mutation) {
            return false;
        }
        return this.position == other.position;
    }

    public String toStringShortVersion() {
        String convertedString = "";
        if (this.mutation == Mutations.INS) {
            convertedString = this.position + this.numberOfIns + this.insertedPolys;
        } else if (this.mutation == Mutations.DEL) {
            convertedString = this.position + "d";
        } else if (this.isTransitionPoly()) {
            convertedString = String.valueOf(this.position);
        } else if (this.position != 0) {
            convertedString = this.position + this.mutation.toString().trim();
        }
        if (this.isBackMutation) {
            return convertedString + "!";
        }
        return convertedString;
    }

    public static String convertToATBackmutation(String poly) {
        if (poly.contains("!")) {
            poly = poly.replace("!", "");
            return "@" + poly;
        }
        return poly;
    }

    public boolean equalsReference() {
        return this.equals(this.getReferenceBase(this.position));
    }

    public Polymorphism getReferenceBase() {
        return this.getReferenceBase(this.position);
    }

    private Polymorphism getReferenceBase(int position) {
        if (position < 16569 && position > 0) {
            String base = String.valueOf(rCRS.charAt(position - 1));
            base = base.toUpperCase();
            try {
                return new Polymorphism(position, Mutations.getBase(base));
            }
            catch (InvalidBaseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static String getReferenceBaseSingle(int position) throws InvalidBaseException {
        String base = String.valueOf(rCRS.charAt(position - 1));
        base = base.toUpperCase();
        return base;
    }

    private void parse(String stringToParse) throws InvalidPolymorphismException {
        StringTokenizer st1 = null;
        stringToParse = stringToParse.trim();
        try {
            if (stringToParse.contains("R") && !stringToParse.contains(".")) {
                this.position = Integer.valueOf(stringToParse.substring(0, stringToParse.length() - 1));
                if (this.getReferenceBase(this.position).equals("A")) {
                    this.mutation = Mutations.G;
                }
                if (this.getReferenceBase(this.position).equals("G")) {
                    this.mutation = Mutations.A;
                }
            }
            if (stringToParse.contains("Y") && !stringToParse.contains(".")) {
                this.position = Integer.valueOf(stringToParse.substring(0, stringToParse.length() - 1));
                if (this.getReferenceBase(this.position).equals("C")) {
                    this.mutation = Mutations.T;
                }
                if (this.getReferenceBase(this.position).equals("T")) {
                    this.mutation = Mutations.C;
                }
            }
        }
        catch (NumberFormatException e1) {
            throw new InvalidPolymorphismException(stringToParse);
        }
        if (stringToParse.startsWith("(")) {
            stringToParse = stringToParse.substring(1, stringToParse.length() - 1);
        }
        if (stringToParse.contains("!")) {
            stringToParse = stringToParse.replace("!", "");
            this.isBackMutation = true;
        }
        if (stringToParse.contains("@")) {
            stringToParse = stringToParse.replace("@", "");
            this.isBackMutation = true;
        }
        if (stringToParse.toUpperCase().contains("D")) {
            stringToParse = stringToParse.replace("del", "");
            stringToParse = stringToParse.replace("d", "");
            stringToParse = stringToParse.replace("DEL", "");
            stringToParse = stringToParse.replace("D", "");
            this.position = Integer.valueOf(stringToParse);
            this.mutation = Mutations.DEL;
        } else if (stringToParse.contains(".")) {
            int i;
            st1 = new StringTokenizer(stringToParse, ".");
            String token = st1.nextToken();
            String token1 = st1.nextToken().trim();
            Pattern p = Pattern.compile("\\d+");
            Matcher m = p.matcher(token1);
            m.find();
            this.position = Integer.valueOf(token);
            this.mutation = Mutations.INS;
            String mutationString = "";
            for (i = 0; i <= 2; ++i) {
                String number = String.valueOf(i);
                if (!token1.contains(number)) continue;
                mutationString = token1.replace(number, "");
                this.numberOfIns = "." + number;
            }
            if (token1.contains("X")) {
                mutationString = token1.replace("X", "");
                this.numberOfIns = ".X";
            }
            i = 0;
            try {
                for (i = 0; i < mutationString.length(); ++i) {
                    Mutations.getBase(String.valueOf(mutationString.charAt(i)));
                }
            }
            catch (InvalidBaseException e) {
                throw new InvalidPolymorphismException(stringToParse, String.valueOf(mutationString.charAt(i)));
            }
            this.insertedPolys = mutationString;
        } else {
            Pattern p = Pattern.compile("[a-zA-Z]");
            Matcher m = p.matcher(stringToParse);
            if (m.find()) {
                try {
                    this.mutation = Mutations.getBase(stringToParse.substring(m.start(), m.end()));
                    this.position = Integer.valueOf(stringToParse.replaceFirst("[a-zA-Z]", ""));
                }
                catch (InvalidBaseException e) {
                    throw new InvalidPolymorphismException(stringToParse, stringToParse.substring(m.start(), m.end()));
                }
                catch (NumberFormatException e) {
                    throw new InvalidPolymorphismException(stringToParse);
                }
            }
            p = Pattern.compile("\\d+");
            m = p.matcher(stringToParse);
            m.find();
            try {
                if (stringToParse.trim().length() > 0) {
                    Integer.parseInt(stringToParse.substring(m.start(), m.end()), 10);
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidPolymorphismException(stringToParse);
            }
            int position = 0;
            if (stringToParse.trim().length() > 0) {
                position = Integer.valueOf(stringToParse);
                try {
                    this.getTransitionPoly(position);
                }
                catch (Exception e) {
                    position = 0;
                    e.printStackTrace();
                }
            }
        }
    }

    private void getTransitionPoly(int position) throws InvalidBaseException {
        this.position = position;
        try {
            if (this.getReferenceBase((int)position).mutation == Mutations.C) {
                this.mutation = Mutations.T;
            }
            if (this.getReferenceBase((int)position).mutation == Mutations.T) {
                this.mutation = Mutations.C;
            }
            if (this.getReferenceBase((int)position).mutation == Mutations.G) {
                this.mutation = Mutations.A;
            }
            if (this.getReferenceBase((int)position).mutation == Mutations.A) {
                this.mutation = Mutations.G;
            }
        }
        catch (Exception e) {
            try {
                throw new InvalidPolymorphismException("" + position, "" + position);
            }
            catch (InvalidPolymorphismException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean isTransitionPoly() {
        if (this.mutation == Mutations.T && this.getReferenceBase().mutation == Mutations.C) {
            return true;
        }
        if (this.mutation == Mutations.C && this.getReferenceBase().mutation == Mutations.T) {
            return true;
        }
        if (this.mutation == Mutations.A && this.getReferenceBase().mutation == Mutations.G) {
            return true;
        }
        return this.mutation == Mutations.G && this.getReferenceBase().mutation == Mutations.A;
    }

    public String getInsertedPolys() {
        return this.insertedPolys;
    }

    @Override
    public int compareTo(Polymorphism o) {
        if (this.position < o.position) {
            return -1;
        }
        if (this.position == o.position) {
            if (this.toString().length() < o.toString().length()) {
                return -1;
            }
            if (this.toString().length() == o.toString().length()) {
                return this.mutation.name().compareTo(o.mutation.name());
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBackMutation ? 1231 : 1237);
        result = 31 * result + (this.mutation == null ? 0 : this.mutation.hashCode());
        result = 31 * result + this.position;
        return result;
    }

    public boolean isMTHotspot() {
        try {
            if (this.equals(new Polymorphism("315.1C"))) {
                return true;
            }
            if (this.equals(new Polymorphism("309.1C"))) {
                return true;
            }
            if (this.equals(new Polymorphism("309.1CC"))) {
                return true;
            }
            if (this.equals(new Polymorphism("523d"))) {
                return true;
            }
            if (this.equals(new Polymorphism("524d"))) {
                return true;
            }
            if (this.equals(new Polymorphism("524.1AC"))) {
                return true;
            }
            if (this.equals(new Polymorphism("524.1ACAC"))) {
                return true;
            }
            if (this.equals(new Polymorphism("3107d"))) {
                return true;
            }
            if (this.equals(new Polymorphism("16182C"))) {
                return true;
            }
            if (this.equals(new Polymorphism("16183C"))) {
                return true;
            }
            if (this.equals(new Polymorphism("16193.1C"))) {
                return true;
            }
            if (this.equals(new Polymorphism("16193.1CC"))) {
                return true;
            }
            return this.equals(new Polymorphism("16519"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (InvalidPolymorphismException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getPosition() {
        return this.position;
    }

    public Mutations getMutation() {
        return this.mutation;
    }

    public boolean isBackMutation() {
        return this.isBackMutation;
    }

    public void setBackMutation(boolean isBackMutation) {
        this.isBackMutation = isBackMutation;
        this.hashCode = this.toString().hashCode();
    }

    public boolean isHeteroplasmy() {
        return this.isHeteroplasmy;
    }

    public void setHeteroplasmy(boolean isHeteroplasmy) {
        this.isHeteroplasmy = isHeteroplasmy;
    }

    public int isReliable() {
        return this.isReliable;
    }

    public void setReliable(int isReliable) {
        this.isReliable = isReliable;
    }

    public AnnotationAAC getAnnotation() {
        HashMap<Polymorphism, AnnotationAAC> annotationLookup = Annotation.getInstance().getAnnotation();
        AnnotationAAC annotation = null;
        if (annotationLookup.containsKey(this)) {
            annotation = annotationLookup.get(this);
        }
        return annotation;
    }
}

