###############################################################
# The retina benchmark dataset batch-1 (n=4) and batch-2 (n=20)
###############################################################

#' @title Retina Benchmark Bulk Data - Batch 1
#'
#' @format A expression matrix with 9,558 rows and 4 columns. Rows represent genes, and columns represent samples.
#'
#' @source Generated by this study.
"retina_benchmark_bulk_batch1"

#' @title Retina Benchmark Pseudo-bulk Data - Batch 1
#'
#' @format A expression matrix with 9,558 rows and 4 columns. Rows represent genes, and columns represent samples.
#'
#' @source Generated by this study.
"retina_benchmark_pseudobulk_batch1"

#' @title Retina Benchmark Reference Data - Batch 1
#'
#' @format A list with the following components:
#' \describe{
#'   \item{reference}{A numeric matrix with 12,568 rows (genes) and 7 columns (cell types). Each entry represents the expression level of a gene in a cell type.}
#'   \item{cell.size}{A named numeric vector with 7 elements representing the cell sizes for the 7 cell types.}
#'   \item{theta}{A numeric matrix with 12,568 rows (genes) and 7 columns (cell types) representing the relative abundance (theta) of each gene in each cell type.}
#' }
#'
#' @source Generated by this study.
"retina_benchmark_reference_batch1"

#' @title Retina Benchmark Bulk Data - Batch 2
#'
#' @format A expression matrix with 10,013 rows and 20 columns. Rows represent genes, and columns represent samples.
#'
#' @source Generated by this study.
"retina_benchmark_bulk_batch2"

#' @title Retina Benchmark Pseudo-bulk Data - Batch 2
#'
#' @format A expression matrix with 10,013 rows and 20 columns. Rows represent genes, and columns represent samples.
#'
#' @source Generated by this study.
"retina_benchmark_pseudobulk_batch2"

#' @title Retina Benchmark Reference Data - Batch 2
#'
#' @format A list with the following components:
#' \describe{
#'   \item{reference}{A numeric matrix with 12,606 rows (genes) and 7 columns (cell types). Each entry represents the expression level of a gene in a cell type.}
#'   \item{cell.size}{A named numeric vector with 7 elements representing the cell sizes for the 7 cell types.}
#'   \item{theta}{A numeric matrix with 12,606 rows (genes) and 7 columns (cell types) representing the relative abundance (theta) of each gene in each cell type.}
#' }
#'
#' @source Generated by this study.
"retina_benchmark_reference_batch2"

#' @title True Cell Type Proportions for Retina Benchmark Data
#'
#' @format A matrix with 7 rows and 24 columns. Rows represent cell-types, and columns represent samples.
#'
#' @source Generated by this study.
"retina_benchmark_ground_truth"


###############################################################
# The Ratnapriya et al. AMD Cohort (n=453)
###############################################################

#' @title Retina Ratnapriya et al. AMD Cohort Raw Counts
#'
#' @format A matrix with 55881 rows and 453 columns. Rows represent genes, and columns represent samples.
#'
#' @source \url{https://www.nature.com/articles/s41588-019-0351-9}
"retina_amd_cohort_raw_counts"


#' @title Retina Ratnapriya et al. AMD Cohort Clinical Information
#'
#' @format A data frame with 453 rows and 3 variables:
#' \describe{
#'   \item{sample_id}{A character vector representing unique sample identifiers.}
#'   \item{age}{A numeric vector representing the age of the individuals in the cohort.}
#'   \item{mgs_level}{A numeric vector representing the severity of macular degeneration, using the MGS (Macular Grading Scale) level.}
#' }
#'
#' @source \url{https://www.nature.com/articles/s41588-019-0351-9}
"retina_amd_cohort_clinical_info"

#' @title Retina Consensus Reference Data
#'
#' @format A matrix with 9993 rows and 10 columns. Rows represent genes, and columns represent cell types.
#'
#' @source Generated by this study.
"retina_consensus_reference"


###############################################################
# The HGSC benchmark dataset (n=7)
###############################################################

#' @title HGSC Benchmark Bulk Data
#'
#' @format A expression matrix with 25,370 rows and 7 columns. Rows represent genes, and columns represent samples.
#'
#' @source \url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-023-03077-7}
"hgsc_benchmark_bulk"

#' @title HGSC Benchmark Pseudo-bulk Data
#'
#' @format A expression matrix with 17,109 rows and 7 columns. Rows represent genes, and columns represent samples.
#'
#' @source \url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-023-03077-7}
"hgsc_benchmark_pseudobulk"

#' @title HGSC Benchmark Reference Data
#'
#' @format A list with the following components:
#' \describe{
#'   \item{reference}{A numeric matrix with 29,131 rows (genes) and 13 columns (cell types). Each entry represents the expression level of a gene in a cell type.}
#'   \item{cell.size}{A named numeric vector with 13 elements representing the cell sizes for the 13 cell types.}
#'   \item{theta}{A numeric matrix with 29,131 rows (genes) and 13 columns (cell types) representing the relative abundance (theta) of each gene in each cell type.}
#' }
#'
#' @source \url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-023-03077-7}
"hgsc_benchmark_reference"

#' @title True Cell Type Proportions for HGSC Benchmark Data
#'
#' @format A matrix with 13 rows and 7 columns. Rows represent cell-types, and columns represent samples.
#'
#' @source \url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-023-03077-7}
"hgsc_benchmark_ground_truth"


###############################################################
# The HGSC Lee et al., cohort (41 sequencing samples form 30 patients)
###############################################################

#' @title HGSC Lee Cohort Raw Counts
#'
#' @format A matrix with 17,109 rows and 41 columns. Rows represent genes, and columns represent samples.
#'
#' @source \url{https://www.cell.com/cell-reports/fulltext/S2211-1247(20)30392-2}
"hgsc_lee_cohort_raw_counts"

#' @title HGSC Lee Cohort Clinical Information
#'
#' @format A data frame with 41 rows and 4 variables:
#' \describe{
#'   \item{external_ID}{A character vector representing external identifiers.}
#'   \item{sequencing_ID}{A character vector representing sequencing experiment identifiers.}
#'   \item{clinical_Sample_ID}{A character vector representing the clinical sample identifiers.}
#'   \item{response}{A character vector representing the clinical response to neoadjuvant chemotherapy.}
#' }
#'
#'
#' @source \url{https://www.cell.com/cell-reports/fulltext/S2211-1247(20)30392-2}
"hgsc_lee_cohort_clinical_info"

#' @title HGSC Lee Cohort Macrophage (MC) Staining Data
#'
#' @format A data frame with 21 rows and 3 variables:
#' \describe{
#'   \item{group}{A character vector indicating the response group.}
#'   \item{external_ID}{A character vector representing the external identifiers for each sample.}
#'   \item{Macrophages}{A numeric vector representing the quantitative measure of macrophages staining results.}
#' }
#'
#' @source \url{https://www.cell.com/cell-reports/fulltext/S2211-1247(20)30392-2}
"hgsc_lee_cohort_mc_staining"


#' @title HGSC Consensus Reference Data
#'
#' @format A matrix with 16,084 rows and 13 columns. Rows represent genes, and columns represent cell types.
#'
#' @source \url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-023-03077-7}
"hgsc_consensus_reference"
