#MiXCR v4.3.2 used
#Run MiXCR Upstream  on Boyd misc data 
ls raw0/boyd_public_fasta/*  |parallel -j 10 --line-buffer  'mixcr  analyze generic-bcr-amplicon -Xmx70g \
    --library IGH_alleles  \
    --species hsa --rna \
    --rigid-left-alignment-boundary \
    --floating-right-alignment-boundary C \
    --split-clones-by C \
    --assemble-clonotypes-by "{CDR1Begin:FR4End}" \
    --remove-step exportClones \
    {}  boyd/{= s:.*/::;s:.fasta:: =}'

#Run MiXCR Upstream  on PRJEB26509 data (w/ UMIs)
ls raw0/PRJEB26509_naiveIGH/*R1*.gz | parallel -j 24 --line-buffer   'mixcr analyze  generic-bcr-amplicon-umi -f \
    --species hsa   \
    --rna \
    --library IGH_alleles  \
    --rigid-left-alignment-boundary --floating-right-alignment-boundary C \
    --tag-pattern "^(R1:*) \ ^N{0:3}(UMI:N{"18"})TACG{1:10}(R2:*)"   \
    --assemble-clonotypes-by VDJRegion \
    --split-clones-by C \
    {} {= s:_R1:_R2: =} \
    PRJEB26509_naiveIGH/{= s:.*/::;s:_R1.fastq.gz::=}'

#Run MiXCR Upstream  on C. Watson data (no UMIs)
ls  /home/amikelov/paper_alleles/raw0/watson/noumi/*R1.fastq | cut -f 1-3 -d "_"| \
parallel -j 23 --line-buffer  \
'echo {}; mixcr -Xmx30g analyze generic-bcr-amplicon \
    -Massemble.cloneAssemblerParameters.badQualityThreshold=1 \
    -Massemble.cloneAssemblerParameters.minimalQuality=1 \
    --species hs --library IGH_alleles --rna -f \
    --rigid-left-alignment-boundary \
    --floating-right-alignment-boundary C \
    --assemble-clonotypes-by "{FR1Begin(+6):FR4End}" \
    --split-clones-by C {}*_R1.fastq {}*_R2.fastq \
    {= s:.*/:/home/amikelov/paper_alleles/watson/: =}.noumi'

#Run MiXCR Upstream  on C. Watson data (5'RACE with UMIs)
ls  /home/amikelov/paper_alleles/raw0/watson/5race/*R1*.fastq | parallel  \
--line-buffer -j 23 \
'mixcr -Xmx30g analyze generic-bcr-amplicon-umi -f \
    --species hs --rna \
    --rigid-left-alignment-boundary \
    --floating-right-alignment-boundary C \
    --library IGH_alleles  \
    --tag-pattern "^(R1:*) \ ^(UMI:N{"12"})GTACG{1:10}(R2:*)"   \
    --assemble-clonotypes-by VDJRegion \
    --split-clones-by C \
    {} {= s:_R1:_R2: =} \
    {= s:.*/:/home/amikelov/paper_alleles/watson/:;s:_R1.fastq:.5race: =}'
    
    
#findAlleles for Boyd lab data   
cd ~/paper_alleles/boyd
nice -n 8 ls *.clns  | cut -f 1 -d "_" |sort|uniq|parallel -j 12 --line-buffer   'echo {}*clns;
  mixcr findAlleles --use-local-temp \
  --no-clns-output \
  -r alleles/{.}.alleles.report.log \
  --export-library alleles/{.}.json \
  --export-library  alleles/{.}.mixcr.fasta  \
  --export-alleles-mutations alleles/{.}.tsv  \
  -j alleles/{.}.report.json {}*clns'
  
#findAlleles for PRJEB26509 data 
cd ~/paper_alleles/PRJEB26509_naiveIGH
nice -n 8 ls *.clns  | cut -f 1 -d "."|sort|uniq|parallel -j 12 --line-buffer \
  'echo {}*clns;
  mixcr findAlleles --use-local-temp \
  --no-clns-output \
  -r alleles/{.}.alleles.report.log \
  --export-library alleles/{.}.json \
  --export-library  alleles/{.}.mixcr.fasta  \
  --export-alleles-mutations alleles/{.}.tsv  \
  -j alleles/{.}.report.json {}*clns'
 
#findAlleles for C.Watson data 
cd /home/amikelov/paper_alleles/watson

nice -n 8 ls *.clns   | cut -f 1 -d "." | cut -f 2 -d "_" |sort|uniq|parallel -j 12 --line-buffer  'ls *{}.*.clns;
  mixcr findAlleles --use-local-temp \
  --no-clns-output \
  -r alleles/{.}.alleles.report.log \
  --export-library alleles/{.}.json \
  --export-library  alleles/{.}.mixcr.fasta  \
  --export-alleles-mutations alleles/{.}.tsv  \
  -j alleles/{.}.report.json *{}.*.clns'




