/*
 * Copyright (c) 2014-2022, MiLaboratories Inc. All Rights Reserved
 *
 * Before downloading or accessing the software, please read carefully the
 * License Agreement available at:
 * https://github.com/milaboratory/mixcr/blob/develop/LICENSE
 *
 * By downloading or accessing the software, you accept and agree to be bound
 * by the terms of the License Agreement. If you do not want to agree to the terms
 * of the Licensing Agreement, you must not download or access the software.
 */
package com.milaboratory.mixcr.util;

import com.milaboratory.mixcr.basictypes.CloneSet;
import com.milaboratory.mixcr.basictypes.CloneSetIO;
import com.milaboratory.mixcr.tests.IntegrationTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

@Category(IntegrationTest.class)
public class DummyIntegrationTest {
    @Test
    public void test1() throws IOException {
        Path file = Paths.get(DummyIntegrationTest.class.getResource("/sequences/big/yf_sample_data/Ig1_S1.contigs.clns").getFile());
        CloneSet clns = CloneSetIO.read(file);
        System.out.println(clns.getOrdering());
    }
}
