/*
 * Copyright (c) 2014-2022, MiLaboratories Inc. All Rights Reserved
 *
 * Before downloading or accessing the software, please read carefully the
 * License Agreement available at:
 * https://github.com/milaboratory/mixcr/blob/develop/LICENSE
 *
 * By downloading or accessing the software, you accept and agree to be bound
 * by the terms of the License Agreement. If you do not want to agree to the terms
 * of the Licensing Agreement, you must not download or access the software.
 */
package com.milaboratory.mixcr.postanalysis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.milaboratory.mixcr.postanalysis.WeightFunctions.TagCount;
import com.milaboratory.util.GlobalObjectMappers;
import org.junit.Assert;
import org.junit.Test;

public class WeightFunctionsTest {
    @Test
    public void test1() throws JsonProcessingException {
        Object expected = new TagCount(1);

        String str = GlobalObjectMappers.getOneLine().writeValueAsString(expected);
        TagCount actual = GlobalObjectMappers.getOneLine().readValue(str, TagCount.class);

        Assert.assertEquals(expected, actual);
    }
}