## Overview

This page contain links to the files referred in original MiXCR paper:

Bolotin, Dmitriy A., Stanislav Poslavsky, Igor Mitrophanov, Mikhail Shugay, Ilgar Z. Mamedov, Ekaterina V. Putintseva, and Dmitriy M. Chudakov. "MiXCR: software for comprehensive adaptive immunity profiling." *Nature methods* 12, no. 5 (**2015**): 380-381.

## Datasets used in the paper

* Full-length Antybody data (1.9 Gb): [link](http://files.milaboratory.com/mixcr/paper/igh_data.zip)
* Real TRB (1.5 Mb): [link](http://files.milaboratory.com/mixcr/paper/real_trb.zip)
* Real IGH (34 Mb): [link](http://files.milaboratory.com/mixcr/paper/real_igh.zip)
* Synthetic TRB (54 Mb): [link](http://files.milaboratory.com/mixcr/paper/synth_trb.zip)
* Synthetic IGH (53 Mb): [link](http://files.milaboratory.com/mixcr/paper/synth_igh.zip)

## Code used in the paper

### MiXCR-Test suite

#### Overview

MiXCR-Test suite is a set of utilities for

* Generation of synthetic repertoire data.
* Comparison of results of synthetic data analysis performed by MiXCR, MiTCR, IgBLAST, Decombinator or IMGT with expected values for CDR3 sequences and identified V, D, J, C genes.
* Comparison of results of real datasets analysis performed by MiXCR, MiTCR, IgBLAST, Decombinator or IMGT

#### Requiraments

* Java 8

#### Links

* [Executable](http://files.milaboratory.com/mixcr/paper/mixcr-test-1.1.zip)
* [Documentation](http://files.milaboratory.com/mixcr/paper/mixcr-test_documentation_1.1.html)
* [Source code](http://files.milaboratory.com/mixcr/paper/mixcr-test-1.1-src.zip)
