## 🚀 New features

- Two-fold `align` step speedup for most of the protocol-specific presets (see the list below)
- Import tags from sequence headers by parsing its content with regular expressions
- Highly optimized generic presets for amplicon/rna-seq sequence by long-read sequencers such as Pacific Biosciences and Oxford Nanopore: `generic-ont`, `generic-ont-with-umi`, `generic-pacbio`, `generic-pacbio-with-umi`

## 🐞 Bug fixes

- Fixes crush when input contains quality scores > 70
- Fixes excessive memory consumption issue for long read data
- Fix for crush in `assemble` with UMI tags but with consensus assembler turned off

## 👷 Other minor adjustments
- Long-read J gene aligner optimization
- FLAIRR-seq preset optimized with new long-read-optimized aligner
- Quality trimming is disabled for long-read aligner
- Removed qc reports for clustered alignments and clones
- The following presets have been optimized by specifying a single reverse/direct alignment mode and now work faster:
  `takara-human-rna-bcr-umi-smartseq`, `takara-human-rna-bcr-umi-smarter`,`takara-human-rna-tcr-umi-smartseq`,`takara-human-rna-tcr-umi-smarter-v2`,`takara-human-rna-tcr-smarter`,`takara-mouse-rna-bcr-smarter`,`takara-mouse-rna-tcr-smarter`,`10x-sc-xcr-vdj`,`10x-sc-5gex`,`abhelix-human-rna-xcr`,`bd-human-sc-xcr-rhapsody-cdr3`,`bd-mouse-sc-xcr-rhapsody-cdr3`,`bd-sc-xcr-rhapsody-full-length`,`cellecta-human-rna-xcr-umi-drivermap-air`,`illumina-human-rna-trb-ampliseq-sr`,`illumina-human-rna-trb-ampliseq-plus`,`irepertoire-human-rna-xcr-repseq-sr`,`irepertoire-human-rna-xcr-repseq-lr`,`irepertoire-mouse-rna-xcr-repseq-sr`,`irepertoire-mouse-rna-xcr-repseq-lr`,`irepertoire-human-rna-xcr-repseq-plus`,`irepertoire-mouse-rna-xcr-repseq-plus`,`irepertoire-human-dna-xcr-repseq-sr`,`irepertoire-human-dna-xcr-repseq-lr`,`milab-human-rna-ig-umi-multiplex`,`milab-human-rna-tcr-umi-race`,`milab-human-rna-tcr-umi-multiplex`,`milab-human-dna-tcr-multiplex`,`milab-human-dna-xcr-7genes-multiplex`,`milab-mouse-rna-tcr-umi-race`,`neb-human-rna-xcr-umi-nebnext`,`qiagen-human-rna-tcr-umi-qiaseq`