## Key changes

- Improved Otsu's method with less stringency for automated histogram thresholding for barcoded data. It allows to
  recover more "good" UMI groups. The old filter was replaced by new one in all presets for airr-seq and single cell vdj
  protocols that utilize UMI: Cellecta, Milaboratories, NEB, Qiagen, Takara, 10x Genomics, BD, Singleron.
- New group filter operators allowing to mix thresholds form multiple operators, taking lowest or highest value and
  applying it. This allows to create more universal filtering strategies, robust to edge cases like undersequencing of
  barcodes.
- Added default fallback threshold for UMI filtering: if automated UMI thresholding leaves less than 85% of reads, 
  then MiXCR will preserve UMIs to always keep minimum 85% of reads.

## Presets

- New preset for [Seq-Well VDJ data](https://www.nature.com/articles/s41590-019-0544-5)
- New presets for NEBNext® Immune Sequencing Kit TCR and BCR profiling for data with both TCR and BCR.
- Improved Takara human TCR and BCR presets

## Reference Library

- New IGHV genes added to human reference: IGHV3-30-3, IGHV4-30-4, IGHV1-69-2, IGHV2-70D,
  IGHV3-30-5
- IGHV1-69D renamed to IGHV1-69

## Minor improvements

- Threshold rounding in cumtop and top-n filters
- Support of sequence-end token (`$`) in tag pattern matching algorithm 
- Added `discardAmbiguousNucleotideCalls` parameters for contig assembly
- Added field `-cellId` in commands `exportClones` and `exportAlignments`
- Added fields `cell_id`, `umi_count` and `consensus_count` to `exportAirr` command
- Better text descriptions in align and assemble reports
- `exportAirr` command now split clones by cells if there is cell barcodes in the data
- Replace `analyze` options `--not-aligned-..` and `--not-parsed-..` with one option `--output-not-used-reads`
- Fix comma-separated chains input in postanalysis `--chains`option
- Split column with tagValue (like `tagValueCELL`) to two columns: `tagValue<tag_name>` and `tagQuality<tag_name>`
- Support of system proxy settings for license
- `#` character now can be used to separate groupName from group matcher in file expansion mechanist (additionally
  to `:`), allowing multi-sample analysis on Windows
- Fixed usage of composite features for `--assemble-contigs-by`
- Removed some restrictions for possible combinations of gene features used in analysis and export  
- Fixed behaviour of empirical alignment assignment in `assemble` if `--write-all` was used in `align`
