# Major changes

- Command `findShmTrees` now can build trees from inputs with different tags
- Added `--impute-germline-on-export` and `--dont-impute-germline-on-export` to `exportAlignments` and `exportClones`
  commands

# Minor improvements

- Now, instead of specifying separately multiple tags of the same type (i.e. CELL1+CELL2+CELL3) in filters, one can use
  convenient aliases (like `allTags:Cell`, `allTags:Molecule`). This also facilitates creation of a more generic base
  presets implementing common single-cell and UMI filtering strategies.
- Several command line interface improvements
- Migration from `<tag_name>` to `<tag_type>` semantics in export columns and `--split-by-tag` options

# Fixes

- fixes bug with `saveOriginalReads=true` on `align` leading to errors down the pipeline
- `analyze` now correctly terminates on first error
- correct progress reporting in `align` with multiple input files provided by file name expansion mechanism
- fix `--only-observed` behaviour in `exportShmTreesWithNodes`
- fix missing tile in heatmap
- fix some cases of usage of `-O...`

# Presets

- Fixed issue with mouse presets from MiLaboratories
- Fixed presets with whitelists
- Fixed missing material type and species in several presets
- Added template switch region trimming for RACE protocols
- Added presets for
  - Thermo Fisher Oncomine kits
  - ParseBio single-cell protocols
  - iRepertoire kits
  - Preset for protocol described in [Vergani *et al.* (2017)](https://doi.org/10.3389/fimmu.2017.01157)
  - Cellecta AIR kit

