# Overview

With this release we continue extending the set of supported single-cell protocols by adding new ready-to-use presets to our collection. Additionally to newly supported protocols and features required for their reliable processing this release comes with many usability optimizations and stability improvements. See details below:

# Major changes

- presets for analysis of all types of BD Rhapsody data (see [docs](https://docs.milaboratories.com/mixcr/reference/overview-built-in-presets/#bd-rhapsody) for the list of supported kits)
- analysis of data produced by single-cell protocol described in [Han et al. (2014)](https://doi.org/10.1038/nbt.2938) (see [docs](https://docs.milaboratories.com/mixcr/reference/overview-built-in-presets/#han-et-al-2014))
- special presets for exom data analysis `exom-cdr3` and `exom-full-length`
- initial support for overlap-extension-based chain pairing protocols
- possibility to export groups of similar columns specifying single option (like `-allAAFeatures <from_reference_point> <to_reference_point>`)
- user-friendly alternative for `-uniqueTagsCount` - `-allUniqueTagsCount`; allows to export counts of unique tag combinations (useful for protocols with multiple `CELL` and `UMI` barcodes)
- new "by sequence" filters for all somatic hypermutation trees (SHMT) exports
- new weighted auto-threshold selection and complementary metric histogram aggregation modes (i.e. y-axis on reads-pre-UMI plots now can show number of reads instead of number of UMIs)
- detected allelic variants are now can also be exported in fasta format right from the `findAlleles` command
- better algorithm for seed sequence selection in consensus assembly routine in `assemble`; increases productive consensus count for cases with multi-variant tag groups (i.e. birthday paradoxes in UMI data or single-cell data analysis without UMIs)

# Minor changes:

- minor adjustments for existing presets
- many CLI and parameter validation fixes, more human-readable error messages, better protection from common input errors
- support for preset-embedded tag whitelists for protocols with small number of barcode variants
- options `--use-local-temp`, `--threads`, `--not-aligned-R1`(`R2`) and `--not-parsed-R1`(`R2`)  are now available in `analyze`, additionally to individual step commands
- bugfix for imputation in export for compound gene features
- other minor fixes and enhancements
