
library(ggplot2)
library(plotly)
library(dplyr)
library(tidyr)
library(splitstackshape)
library(ggrepel)
library(grid)
source("multiplot.R")

test_CG<-read.delim("T_test_CG.txt", stringsAsFactors = FALSE)
test_CHG<-read.delim("T_test_CHG.txt", stringsAsFactors = FALSE)
test_CHH<-read.delim("T_test_CHH.txt", stringsAsFactors = FALSE)

colnames(test_CG)<-c("Significant","-Log[FDR]", "log2[mCG/CG]","Protein_name","Gene_name", "Protein_ID")
colnames(test_CHG)<-c("Significant","-Log[FDR]", "log2[mCHG/CHG]","Protein_name","Gene_name", "Protein_ID")
colnames(test_CHH)<-c("Significant","-Log[FDR]", "log2[mCHH/CHH]", "Protein_name","Gene_name", "Protein_ID")

test_CG$Significant<-ifelse(test_CG$Significant=="+",1,2)
test_CHG$Significant<-ifelse(test_CHG$Significant=="+",1,3)
test_CHH$Significant<-ifelse(test_CHH$Significant=="+",1,10)

## ID file downloaded from http://ensembl.gramene.org/biomart/martview/f688046640aaab36b10e0aa6cd8fa112/f688046640aaab36b10e0aa6cd8fa112
ID_file<-read.delim("IDs.txt", stringsAsFactors = FALSE)

test_CG_descr<-left_join(test_CG, ID_file, by = "Protein_ID")
test_CHG_descr<-left_join(test_CHG, ID_file, by = "Protein_ID")
test_CHH_descr<-left_join(test_CHH, ID_file, by = "Protein_ID")

colnames(test_CG_descr)<-c("Significant","-Log[FDR]", "log2[mCG/CG]","Protein_name","Gene_name_2", "Protein_ID", "AGI","Gene_name_1")
colnames(test_CHG_descr)<-c("Significant","-Log[FDR]", "log2[mCHG/CHG]","Protein_name","Gene_name_2", "Protein_ID", "AGI","Gene_name_1")
colnames(test_CHH_descr)<-c("Significant","-Log[FDR]", "log2[mCHH/CHH]","Protein_name","Gene_name_2", "Protein_ID", "AGI","Gene_name_1")

# To check what class the columns are!! 
#sapply(test_CHH_descr, class)

table_CG<-test_CG_descr %>%
  rowwise() %>%
  mutate(good_name=ifelse(!is.na(Gene_name_1) & Gene_name_1!="", Gene_name_1, 
                          ifelse((Gene_name_2!=""),Gene_name_2, 
                               ifelse(!is.na(AGI), AGI, Protein_ID)))) %>%
  mutate(graph=ifelse(Significant==1 && `log2[mCG/CG]` < 0, 1,
                      ifelse(Significant==1 && `log2[mCG/CG]` > 0, 2, 0)))
table_CG$graph<-as.factor(table_CG$graph)
table_CG$Significant<-as.factor(table_CG$Significant)


table_CHG<-test_CHG_descr %>%
  rowwise() %>%
  mutate(good_name=ifelse(!is.na(Gene_name_1) & Gene_name_1!="", Gene_name_1, 
                          ifelse((Gene_name_2!=""),Gene_name_2, 
                                 ifelse(!is.na(AGI), AGI, Protein_ID)))) %>%
  mutate(graph=ifelse(Significant==1 && `log2[mCHG/CHG]` < 0, 1,
                    ifelse(Significant==1 && `log2[mCHG/CHG]` > 0, 2, 0)))
table_CHG$graph<-as.factor(table_CHG$graph)
table_CHG$Significant<-as.factor(table_CHG$Significant)


table_CHH<-test_CHH_descr %>%
  rowwise() %>%
  mutate(good_name=ifelse(!is.na(Gene_name_1) & Gene_name_1!="", Gene_name_1, 
                          ifelse((Gene_name_2!=""),Gene_name_2, 
                                 ifelse(!is.na(AGI), AGI, Protein_ID)))) %>%
  mutate(graph=ifelse(Significant==1 && `log2[mCHH/CHH]` < 0, 1,
                    ifelse(Significant==1 && `log2[mCHH/CHH]` > 0, 2, 0)))
table_CHH$graph<-as.factor(table_CHH$graph)
table_CHH$Significant<-as.factor(table_CHH$Significant)



save(test_CG_modif,test_CHG_modif,test_CHH_modif,ID_file, file="MS_results_T_tests.RData")
## Start from here
load("MS_results_T_tests.RData")


plot1<-ggplot(table_CG, aes(`log2[mCG/CG]`, `-Log[FDR]`, label=`good_name`, size=`graph`, alpha=`graph`, color=`graph`)) +
  geom_point() + theme_bw() + geom_vline(xintercept = 0, color="black", alpha=0.5, linetype="dashed") +
  geom_text_repel(aes(label=ifelse(Significant==1,as.character(good_name),"")), nudge_y=0.2, segment.alpha = 0) +
  guides(size = FALSE, alpha = FALSE, color = FALSE) + scale_color_manual(values = c("black","#996633","#cc0066")) +
  scale_size_manual(values = c(1, 3, 3)) + scale_alpha_manual(values = c(0.2, 0.9, 0.9)) +
  labs(title = "CG", x = expression('Log'[2]*' [mCG/CG]'), y = "-Log [FDR]") + theme(plot.title = element_text(hjust = 0.5, size=20), 
                                axis.title = element_text(size=12))
  
plot2<-ggplot(table_CHG, aes(`log2[mCHG/CHG]`, `-Log[FDR]`, label=`good_name`, size=`graph`, alpha=`graph`, color=`graph`)) +
  geom_point() + theme_bw() + geom_vline(xintercept = 0, color="black", alpha=0.5, linetype="dashed") +
  geom_text_repel(aes(label=ifelse(Significant==1,as.character(good_name),"")), nudge_y=0.2, segment.alpha = 0) +
  guides(size = FALSE, alpha = FALSE, color = FALSE) + scale_color_manual(values = c("black","#996633","#cc0066")) +
  scale_size_manual(values = c(1, 3, 3)) + scale_alpha_manual(values = c(0.2, 0.9, 0.9)) +
  labs(title = "CHG", x = expression('Log'[2]*' [mCHG/CHG]'), y = "-Log [FDR]") + 
  theme(plot.title = element_text(hjust = 0.5, size=20), axis.title = element_text(size=12))

plot3<-ggplot(table_CHH, aes(`log2[mCHH/CHH]`, `-Log[FDR]`, label=`good_name`, size=`graph`, alpha=`graph`, color=`graph`)) +
  geom_point() + theme_bw() + geom_vline(xintercept = 0, color="black", alpha=0.5, linetype="dashed") +
  geom_text_repel(aes(label=ifelse(Significant==1,as.character(good_name),"")), nudge_y=0.2, segment.alpha = 0) +
  guides(size = FALSE, alpha = FALSE, color = FALSE) + scale_color_manual(values = c("black","#996633","#cc0066")) +
  scale_size_manual(values = c(1, 3, 3)) + scale_alpha_manual(values = c(0.2, 0.9, 0.9)) +
  labs(title = "CHH", x = expression('Log'[2]*' [mCHH/CHH]'), y = "-Log [FDR]") + 
  theme(plot.title = element_text(hjust = 0.5, size=20), axis.title = element_text(size=12))

multiplot(plot1,plot2,plot3, cols=3)

pdf("volcano_plots.pdf",15,5)
multiplot(plot1,plot2,plot3, cols=3)
dev.off()

