### ChIP script for final analysis with all samples

### Final pipeline for ChIPseq data analysis
### Prepare your environment: have a folder for the project (mine is total_pipeline), with subfolders: 
###	fastq reports mapped peaks deeptools plots methyl rna annotations merged histones mtases
### copy the fastq.gz files and rename them with your sample names

############################################################################################################################################################################
### Trim fastq files with cutadapt (need Tim's environment for the right version of cutadapt)

# source /home/tstuart/working_data/virtualenvs/env/bin/activate

# for sample in ChIP3_MBD6_HA ChIP3_MBD6_INPUT ChIP2_SUVH1_HA ChIP2_SUVH1_INPUT ChIP3_SUVH1_HA ChIP3_SUVH1_INPUT ChIP3_MBD1_HA ChIP3_MBD1_INPUT ChIP6_MBD1_HA ChIP6_MBD1_INPUT ChIP6_MBD2_rep1_HA ChIP6_MBD2_rep1_INPUT ChIP6_MBD2_rep2_HA ChIP6_MBD2_rep2_INPUT ChIP4_WT_HA ChIP4_WT_INPUT ChIP2_RLT1_HA ChIP2_RLT1_INPUT ChIP5_X3_HA ChIP5_X3_INPUT ChIP7_SUVH3_rep1_HA ChIP7_SUVH3_rep1_INPUT ChIP7_SUVH3_rep2_HA ChIP7_SUVH3_rep2_INPUT ChIP7_MBD5_rep1_HA ChIP7_MBD5_rep1_INPUT ChIP7_MBD5_rep2_HA ChIP7_MBD5_rep2_INPUT ChIP7_MBD6_HA ChIP7_MBD6_INPUT ChIP8_MBD4_rep1_HA ChIP8_MBD4_rep1_INPUT ChIP8_MBD4_rep2_HA ChIP8_MBD4_rep2_INPUT ChIP8_X1_rep1_HA ChIP8_X1_rep1_INPUT ChIP8_X1_rep2_HA ChIP8_X1_rep2_INPUT ChIP11_MBD1_HA ChIP11_MBD1_INPUT ChIP11_MBD4_HA ChIP11_MBD4_INPUT ChIP11_SUVH1_HA ChIP11_SUVH1_INPUT
# do
	# # echo "copying fastq of $sample..."	
	# # cp /dd_rundata/hiseq/Runs/180815_SNL119_0286_AC4K3BACXX/Unaligned/Ath_mC_readers_ChIP/*${sample}* fastq/${sample}.fastq.gz
	# fastqc -o reports/ fastq/${sample}.fastq.gz
	# echo "trimming adapters from $sample..."
	# cutadapt -a AGATCGGAAGAGCACACGTCTGAACTCCAGTCAC -o fastq/trim_${sample}.fastq.gz fastq/${sample}.fastq.gz > reports/trim_${sample}.txt
	# fastqc -o reports/ fastq/trim_${sample}.fastq.gz
# done

# deactivate 

##########################################################################################################################################################################
### To map fastq files with Bowtie2, mark duplicates with Picard, get mapping metrics, convert to sorted and indexed BAM files for unique and multimappers
### And to make normalized bigwig files for each HA, INPUT and their log2 FC

# A_th_index=/mnt/remoteserv/switch/userdata/usrdat01/userdata/jcahn/OpenData/Genomes/Arabidopsis_thaliana/Ensembl/TAIR10/Sequence/Bowtie2Index

# for sample in ChIP3_MBD6_HA ChIP3_MBD6_INPUT ChIP2_SUVH1_HA ChIP2_SUVH1_INPUT ChIP3_SUVH1_HA ChIP3_SUVH1_INPUT ChIP3_MBD1_HA ChIP3_MBD1_INPUT ChIP6_MBD1_HA ChIP6_MBD1_INPUT ChIP6_MBD2_rep1_HA ChIP6_MBD2_rep1_INPUT ChIP6_MBD2_rep2_HA ChIP6_MBD2_rep2_INPUT ChIP4_WT_HA ChIP4_WT_INPUT ChIP2_RLT1_HA ChIP2_RLT1_INPUT ChIP5_X3_HA ChIP5_X3_INPUT ChIP7_SUVH3_rep1_HA ChIP7_SUVH3_rep1_INPUT ChIP7_SUVH3_rep2_HA ChIP7_SUVH3_rep2_INPUT ChIP7_MBD5_rep1_HA ChIP7_MBD5_rep1_INPUT ChIP7_MBD5_rep2_HA ChIP7_MBD5_rep2_INPUT ChIP7_MBD6_HA ChIP7_MBD6_INPUT ChIP8_MBD4_rep1_HA ChIP8_MBD4_rep1_INPUT ChIP8_MBD4_rep2_HA ChIP8_MBD4_rep2_INPUT ChIP8_X1_rep1_HA ChIP8_X1_rep1_INPUT ChIP8_X1_rep2_HA ChIP8_X1_rep2_INPUT ChIP11_MBD1_HA ChIP11_MBD1_INPUT ChIP11_MBD4_HA ChIP11_MBD4_INPUT ChIP11_SUVH1_HA ChIP11_SUVH1_INPUT

# # for sample in ChIP3_MBD6_HA ChIP3_MBD6_INPUT ChIP2_SUVH1_HA ChIP2_SUVH1_INPUT ChIP3_MBD1_HA ChIP3_MBD1_INPUT ChIP6_MBD1_HA ChIP6_MBD1_INPUT ChIP6_MBD2_rep1_HA ChIP6_MBD2_rep1_INPUT ChIP6_MBD2_rep2_HA ChIP6_MBD2_rep2_INPUT ChIP4_WT_HA ChIP4_WT_INPUT ChIP7_SUVH3_rep1_HA ChIP7_SUVH3_rep1_INPUT ChIP7_SUVH3_rep2_HA ChIP7_SUVH3_rep2_INPUT ChIP7_MBD5_rep1_HA ChIP7_MBD5_rep1_INPUT ChIP7_MBD5_rep2_HA ChIP7_MBD5_rep2_INPUT ChIP7_MBD6_HA ChIP7_MBD6_INPUT ChIP8_MBD4_rep2_HA ChIP8_MBD4_rep2_INPUT ChIP11_MBD4_HA ChIP11_MBD4_INPUT ChIP11_SUVH1_HA ChIP11_SUVH1_INPUT

# printf "Sample\tMapping mode\tRaw\tMapped (%% of tot)\tMapped on Chr1-5 (%% of tot)\tMapped on ChrM-C (%% of mapped)\tMAPQ>10 (%% of tot)\tMAPQ>10 on Chr1-5 (%% of tot)\tMAPQ>10 on ChrM-C (%% of mapped)\tNot duplicates (%% of tot)\tMAPQ>10 and not duplicates (%% of tot)\tMAPQ>10 and not duplicates in Chr1-5 (%% of MAPQ>10 and not duplicates)\n" > mapped/read_count.txt

# for sample in ChIP3_MBD1_HA ChIP3_MBD1_INPUT ChIP6_MBD1_HA ChIP6_MBD1_INPUT ChIP6_MBD2_rep1_HA ChIP6_MBD2_rep1_INPUT ChIP6_MBD2_rep2_HA ChIP6_MBD2_rep2_INPUT ChIP8_MBD4_rep1_HA ChIP8_MBD4_rep1_INPUT ChIP8_MBD4_rep2_HA ChIP8_MBD4_rep2_INPUT ChIP11_MBD4_HA ChIP11_MBD4_INPUT ChIP7_MBD5_rep1_HA ChIP7_MBD5_rep1_INPUT ChIP7_MBD5_rep2_HA ChIP7_MBD5_rep2_INPUT ChIP3_MBD6_HA ChIP3_MBD6_INPUT ChIP7_MBD6_HA ChIP7_MBD6_INPUT ChIP2_SUVH1_HA ChIP2_SUVH1_INPUT ChIP3_SUVH1_HA ChIP3_SUVH1_INPUT ChIP11_SUVH1_HA ChIP11_SUVH1_INPUT ChIP7_SUVH3_rep1_HA ChIP7_SUVH3_rep1_INPUT ChIP7_SUVH3_rep2_HA ChIP7_SUVH3_rep2_INPUT ChIP4_WT_HA ChIP4_WT_INPUT
# do
	# echo "mapping reads from $sample..."
	# bowtie2 --end-to-end --no-unal -p 10 -x ${A_th_index}/genome -U fastq/trim_${sample}.fastq.gz -S mapped/${sample}_end.sam 2> reports/map_end_${sample}.txt
	# bowtie2 --local --no-unal -p 10 -x ${A_th_index}/genome -U fastq/trim_${sample}.fastq.gz -S mapped/${sample}_loc.sam 2> reports/map_loc_${sample}.txt
	# echo "converting to sorted indexed bam..."
	# java -jar /home/jcahn/working_data/Install/picard.jar SortSam I=mapped/${sample}_end.sam O=mapped/${sample}_end_sorted.bam SORT_ORDER=coordinate CREATE_INDEX=TRUE
	# java -jar /home/jcahn/working_data/Install/picard.jar SortSam I=mapped/${sample}_loc.sam O=mapped/${sample}_loc_sorted.bam SORT_ORDER=coordinate CREATE_INDEX=TRUE
	# echo "marking duplicates for each bam..."
	# java -jar /home/jcahn/working_data/Install/picard.jar MarkDuplicates I=mapped/${sample}_end_sorted.bam O=mapped/${sample}_end_marked.bam M=reports/stats_markdup_end_${sample}.txt REMOVE_DUPLICATES=FALSE
	# java -jar /home/jcahn/working_data/Install/picard.jar MarkDuplicates I=mapped/${sample}_loc_sorted.bam O=mapped/${sample}_loc_marked.bam M=reports/stats_markdup_loc_${sample}.txt REMOVE_DUPLICATES=FALSE
	# echo "sorting and indexing marked bam..."
	# java -jar /home/jcahn/working_data/Install/picard.jar SortSam I=mapped/${sample}_end_marked.bam O=mapped/sorted_end_${sample}.bam SORT_ORDER=coordinate CREATE_INDEX=TRUE
	# java -jar /home/jcahn/working_data/Install/picard.jar SortSam I=mapped/${sample}_loc_marked.bam O=mapped/sorted_loc_${sample}.bam SORT_ORDER=coordinate CREATE_INDEX=TRUE
	
	# echo "Stats $sample $type raw..."
	# raw=$(echo $(zcat fastq/trim_${sample}.fastq.gz | wc -l)/4 | bc)
	# echo "Stats end-to-end $sample $type mapped..."
	# m=$(samtools view mapped/sorted_end_${sample}.bam -c)
	# r=$(echo "scale = 1; 100*$m/$raw" | bc)
	# mO=$(samtools view mapped/sorted_end_${sample}.bam -c Mt Pt)
	# rO=$(echo "scale = 1; 100*$mO/$m" | bc)
	# mG=$((m-mO))
	# rG=$(echo "scale = 1; 100*$mG/$raw" | bc)
	# echo "Stats end-to-end $sample $type MAPQ>10..."
	# um=$(samtools view -q 10 mapped/sorted_end_${sample}.bam -c)
	# ur=$(echo "scale = 1; 100*$um/$raw" | bc)
	# umO=$(samtools view -q 10 mapped/sorted_end_${sample}.bam -c Mt Pt)
	# urO=$(echo "scale = 1; 100*$umO/$um" | bc)
	# umG=$((um-umO))
	# urG=$(echo "scale = 1; 100*$umG/$raw" | bc)
	# echo "Stats end-to-end $sample $type picard duplicates..."
	# rdup1=$(samtools view -F 1024 mapped/sorted_end_${sample}.bam -c)
	# rdup2=$(samtools view -q 10 -F 1024 mapped/sorted_end_${sample}.bam -c)
	# rdup3=$(samtools view -q 10 -F 1024 mapped/sorted_end_${sample}.bam -c 1 2 3 4 5)
	# p1=$(echo "scale = 1; 100*$rdup1/$raw" | bc)
	# p2=$(echo "scale = 1; 100*$rdup2/$raw" | bc)
	# p3=$(echo "scale = 1; 100*$rdup3/$raw" | bc)
	# printf "$sample\tend to end\t$raw\t$m ($r %%)\t$mG ($rG %%)\t$mO ($rO %%)\t$um ($ur %%)\t$umG ($urG %%)\t$umO ($urO %%)\t$rdup1 ($p1 %%)\t$rdup2 ($p2 %%)\t$rdup3 ($p3 %%)\n" >> mapped/read_count.txt	
	
	# echo "Stats local $sample $type mapped..."
	# m=$(samtools view mapped/sorted_loc_${sample}.bam -c)
	# r=$(echo "scale = 1; 100*$m/$raw" | bc)
	# mO=$(samtools view mapped/sorted_loc_${sample}.bam -c Mt Pt)
	# rO=$(echo "scale = 1; 100*$mO/$m" | bc)
	# mG=$((m-mO))
	# rG=$(echo "scale = 1; 100*$mG/$raw" | bc)
	# echo "Stats local $sample $type MAPQ>10..."
	# um=$(samtools view -q 10 mapped/sorted_loc_${sample}.bam -c)
	# ur=$(echo "scale = 1; 100*$um/$raw" | bc)
	# umO=$(samtools view -q 10 mapped/sorted_loc_${sample}.bam -c Mt Pt)
	# urO=$(echo "scale = 1; 100*$umO/$um" | bc)
	# umG=$((um-umO))
	# urG=$(echo "scale = 1; 100*$umG/$raw" | bc)
	# echo "Stats local $sample $type picard duplicates..."
	# rdup1=$(samtools view -F 1024 mapped/sorted_loc_${sample}.bam -c)
	# rdup2=$(samtools view -q 10 -F 1024 mapped/sorted_loc_${sample}.bam -c)
	# rdup3=$(samtools view -q 10 -F 1024 mapped/sorted_loc_${sample}.bam -c 1 2 3 4 5)
	# p1=$(echo "scale = 1; 100*$rdup1/$raw" | bc)
	# p2=$(echo "scale = 1; 100*$rdup2/$raw" | bc)
	# p3=$(echo "scale = 1; 100*$rdup3/$raw" | bc)
	# printf "$sample\tlocal\t$raw\t$m ($r %%)\t$mG ($rG %%)\t$mO ($rO %%)\t$um ($ur %%)\t$umG ($urG %%)\t$umO ($urO %%)\t$rdup1 ($p1 %%)\t$rdup2 ($p2 %%)\t$rdup3 ($p3 %%)\n" >> mapped/read_count.txt	
# done

# rm mapped/ChIP*

# printf "\n\n *** MAPPING FINISHED ***\n\n"

for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep1 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP3_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2 ChIP4_WT
do
	for type in HA INPUT
	do
		# echo "filtering bam $sample $type..."
		# # samtools view -h -b -q 10 -F 1024 mapped/sorted_loc_${sample}_${type}.bam 1 2 3 4 5 -o dedupbam/unique_${sample}_${type}.bam
		# samtools view -h -b -q 10 -f 1024 mapped/sorted_loc_${sample}_${type}.bam 1 2 3 4 5 -o dedupbam/multi_${sample}_${type}.bam
		# echo "indexing bam $sample $type..."
		# # samtools index -@10 dedupbam/unique_${sample}_${type}.bam
		# samtools index -@10 dedupbam/multi_${sample}_${type}.bam
		echo "making bigwig file for $sample $type..."
		# # bamCoverage -b dedupbam/unique_${sample}_${type}.bam -o dedupbam/unique_${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
		# bamCoverage -b dedupbam/multi_${sample}_${type}.bam -o dedupbam/multi_${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
		bamCoverage -b mapped/sorted_loc_${sample}_${type}.bam -o dedupbam/all_${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
	done
	# echo "making bigwigs for $sample..."
	# bamCompare -b1 dedupbam/multi_${sample}_HA.bam -b2 dedupbam/multi_${sample}_INPUT.bam -o deeptools/multivsINPUT_${sample}.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM"
	# bamCompare -b1 dedupbam/unique_${sample}_HA.bam -b2 dedupbam/unique_${sample}_INPUT.bam -o deeptools/uniquevsINPUT_${sample}.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM"
	# bamCompare -b1 mapped/sorted_loc_${sample}_HA.bam -b2 mapped/sorted_loc_${sample}_INPUT.bam -o deeptools/allvsINPUT_${sample}.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM"
done

# # for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep1 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP3_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# for sample in ChIP2_SUVH1 ChIP3_SUVH1 ChIP11_SUVH1
# do
	# echo "comparing $sample to WT..."
	# bigwigCompare -b1 deeptools/multivsINPUT_${sample}.bw -b2 deeptools/multivsINPUT_ChIP4_WT.bw -o deeptools/multivsWT_${sample}.bw -p 10 -bs 1
	# bigwigCompare -b1 deeptools/uniquevsINPUT_${sample}.bw -b2 deeptools/uniquevsINPUT_ChIP4_WT.bw -o deeptools/uniquevsWT_${sample}.bw -p 10 -bs 1
	# bigwigCompare -b1 deeptools/allvsINPUT_${sample}.bw -b2 deeptools/allvsINPUT_ChIP4_WT.bw -o deeptools/allvsWT_${sample}.bw -p 10 -bs 1
# done


#######################################################################################################################################################################
### To create a file of regions to avoid for peak calling (regions overepresented in WT input) [FC of 4 chosen based on histogram (cf. R code)]

# bamCoverage -b mapped/sorted_ChIP4_WT_INPUT.bam -o deeptools/coverage_WT.bedGraph -of "bedgraph" --ignoreDuplicates --minMappingQuality 10 --normalizeUsing "CPM"

bamCompare -b1 dedupbam/unique_ChIP4_WT_HA.bam -b2 dedupbam/unique_ChIP4_WT_INPUT.bam -o deeptools/unique_WT.bedGraph -of "bedgraph" -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM"

# awk -v OFS="\t" '$1~/^[1-9]/ && $4>4' deeptools/coverage_WT.bedGraph > deeptools/filter_coverage_WT.bedgraph
# bedtools merge -i deeptools/filter_coverage_WT.bedgraph -d 1000 > deeptools/black_listed_regions.bed

########################################################################################################################################################################
### Call peaks with macs2 (need macs2 environment), run the peak model, filter out peaks in mitochrondrial and chloroplastic chromosomes and in blacklisted regions
### (Need to change coordinates to 0-based since .xls file is 1-based)

# source /home/jcahn/working_data/Runs/Chip/apps/macs2/bin/activate

# rm reports/numbers_filtered_peaks.txt
# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# do
	# printf "calling peaks for $sample...\n\n"	
	# macs2 callpeak -t mapped/sorted_${sample}_HA.bam -c mapped/sorted_${sample}_INPUT.bam -f BAM -g dm -q 0.01 -n ${sample} --outdir peaks/
	# echo "plotting R model"
	# cd plots
	# Rscript ../peaks/${sample}_model.r
	# cd ..
	# echo "Filtering peaks in $sample"
	# awk -v OFS="\t" -v s=$sample '$0~/^[1-9]/ {$2=$2-1; print $1,$2,$3,$10,$5,$8,$9}' peaks/${sample}_peaks.xls > tables/inter_${sample}.tab
	# bedtools intersect -a tables/inter_${sample}.tab -b deeptools/black_listed_regions.bed -wa -v > tables/filtered_${sample}.txt
	# wc -l tables/filtered_${sample}.txt | awk -v OFS="\t" -v s=$sample '{print s, $0}' >> reports/numbers_filtered_peaks.txt
# done
# rm tables/inter*

#######################################################################################################################################################################
##### To get the average methylation at peaks [keep all the peaks of each sample, not on merged peaks]
##### Process the filtered_${sample} files with find_methylation_at_ChIPseq_peaks.py to get average methylation under each peak of each sample. Need python 2 (timenv works)
##### Need to check the samples in the script. The script can also be modified to get methylation levels in mutants instead of WT

# source /home/tstuart/working_data/virtualenvs/env/bin/activate

# python find_methylation_at_ChIPseq_peaks.py

# deactivate

########################################################################################################################################################################
##### to merge the methylation data into one table for each sample
##### columns are: Peak_ID mCG Cov_mCG Nb_mCG mCHG Cov_mCHG Nb_mCHG mCHH Cov_mCHH Nb_mCHH

# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# do
	# sed 's/\r//' tables/${sample}_CG_mC.tsv | sort -k1,1 > tables/interCG_${sample}.tsv
	# sed 's/\r//' tables/${sample}_CHG_mC.tsv | sort -k1,1 > tables/interCHG_${sample}.tsv 
	# sed 's/\r//' tables/${sample}_CHH_mC.tsv | sort -k1,1 > tables/interCHH_${sample}.tsv 
	# join tables/interCG_${sample}.tsv tables/interCHG_${sample}.tsv | join - tables/interCHH_${sample}.tsv | awk -v OFS="\t" '{print $1,$2,$3,$4,$5,$6,$7,$8,$9,$10}' | sort -k1,1 > tables/peaks_mC_${sample}.txt
	# head tables/peaks_mC_${sample}.txt
# done

# rm tables/inter*

###############################################################################################################################################################################
###### To get a file of annotated peaks for each sample

# awk -v OFS="\t" '$3~"transposable_element" {print $0}' annotations/TAIR10_GFF3_genes_transposons.gff | sed 's/Chr//' > annotations/TE.gff
# printf "Sample\tAnnotations\tCount\n" > annotations/annotated_peaks_stats.txt
# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# do
	# echo $sample
	# sed 's/\r//' tables/filtered_${sample}.txt | awk -v OFS="\t" '{print $1,$2,$3,$4,".","."}' | sed 's/"//g' > peaks/temp0_peaks.bed
	# annotatePeaks.pl peaks/temp0_peaks.bed tair10 -gff annotations/TAIR10_GFF3_genes_transposons.gff -annStats annotations/stats_${sample}_peaks.txt > annotations/tempA_peaks.txt
	# awk -v OFS="\t" '(NR>1) && ($9=="Intergenic" || $9=="Chr") {print $2,$3,$4,$1}' annotations/tempA_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1_peaks.bed
	# awk -v OFS="\t" '(NR>1) && $9=="promoter-TSS" {print $2,$3,$4,$1}' annotations/tempA_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1b_peaks.bed
	# awk -v OFS="\t" '(NR>1) && $9=="TTS" {print $2,$3,$4,$1}' annotations/tempA_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1c_peaks.bed
	# awk -v OFS="\t" '(NR>1) && ($9=="exon" || $9=="3'"'"'" || $9=="5'"'"'") {print $2,$3,$4,$1}' annotations/tempA_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1d_peaks.bed
	# awk -v OFS="\t" '(NR>1) && $9=="intron" {print $2,$3,$4,$1}' annotations/tempA_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1e_peaks.bed
	# bedtools intersect -a annotations/temp1_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2.txt
	# bedtools intersect -a annotations/temp1b_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2b.txt
	# bedtools intersect -a annotations/temp1c_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2c.txt
	# bedtools intersect -a annotations/temp1d_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2d.txt
	# bedtools intersect -a annotations/temp1e_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2e.txt
	# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE"; else print $1,$2,$3,$4,"Intergenic"}' annotations/temp2.txt > annotations/temp3.txt
	# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_prom"; else print $1,$2,$3,$4,"Promoter"}' annotations/temp2b.txt >> annotations/temp3.txt
	# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_TTS"; else print $1,$2,$3,$4,"TTS"}' annotations/temp2c.txt >> annotations/temp3.txt
	# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_exon"; else print $1,$2,$3,$4,"Exon"}' annotations/temp2d.txt >> annotations/temp3.txt
	# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_intron"; else print $1,$2,$3,$4,"Intron"}' annotations/temp2e.txt >> annotations/temp3.txt
	# awk -v OFS="\t" '{if ($5=="TE_intron" || $5=="TE_exon") print $1,$2,$3,$4,"TE_gene"; else print $1,$2,$3,$4,$5}' annotations/temp3.txt > annotations/temp4.txt
	# sort -k1,1 -k2,2n annotations/temp4.txt | uniq | awk -v OFS="\t" -v s=$sample '{print $4,$5}' | sort -k1,1 > tables/annotated_peaks_${sample}.txt
	# head tables/annotated_peaks_${sample}.txt
	# awk -v OFS="\t" '{print $2}' tables/annotated_peaks_${sample}.txt | sort | uniq -c | awk -v OFS="\t" -v s=$sample '{print s,$2,$1}' >> annotations/annotated_peaks_stats.txt
	# rm annotations/temp*
# done

# cat annotations/annotated_peaks_stats.txt

# ########################################################################################################################################################################
# ### To have a complete file for each sample of all the details (including annotations and methylation) for each peak
# ### columns are: Peak_ID Chr Start End Summit FC -log10(Qvalue) Annotation avg_mCG avg_Cov_mCG Nb_mCG avg_mCHG avg_Cov_mCHG Nb_mCHG avg_mCHH avg_Cov_mCHH Nb_mCHH
# ### Also to load a peak file on AnnoJ where "Hyper" sample is the annotation and "Hypo" is avg_mCG | avg_mCHG | avg_mCHH 

# printf "chr;start;end;number_of_mcs;hypermethylated_samples;hypomethylated_samples\n" > tables/header_peaks_annoJ.csv
# printf "Sample\tPeak_ID\tChr\tStart\tEnd\tSummit\tFC\tlogQ\tAnnotation\tmCG\tCov_mCG\tNb_mCG\tmCHG\tCov_mCHG\tNb_mCHG\tmCHH\tCov_mCHH\tNb_mCHH\n" > tables/combined_complete_peaks.txt

# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# do
	# echo "complete for $sample"
	# awk -v OFS="\t" '{print $4,$1,$2,$3,$5,$6,$7}' tables/filtered_${sample}.txt | sort -k1,1 | join - tables/annotated_peaks_${sample}.txt | join - tables/peaks_mC_${sample}.txt | awk -v OFS="\t" '{print $1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16,$17}' > tables/complete_${sample}.txt
	# head tables/complete_${sample}.txt
	# awk -v OFS=";" '{print $2,$3,$4,$1,$8,$9" | "$12" | "$15}' tables/complete_${sample}.txt > tables/temp_peaks_${sample}.csv
	# cat tables/header_peaks_annoJ.csv tables/temp_peaks_${sample}.csv > tables/peaks_${sample}.csv
	# deepsea dmr -k="Ath_ChIP_peaks" -d 'Ath_mC_readers_peaks' tables/peaks_${sample}.csv --drop
	##### To create a single peak file for all samples
	# awk -v OFS=";" -v s=${sample} '{print $2,$3,$4,s,$1": "$8,$9" | "$12" | "$15}' tables/complete_${sample}.txt >> tables/annoJ_mix.csv
	#### To have a final file with the data from all peaks and all samples for plotting with R
	# awk -v OFS="\t" -v s=$sample '{print s,$0}' tables/complete_${sample}.txt >> tables/combined_complete_peaks.txt
# done
# rm tables/temp*
# cat tables/header_peaks_annoJ.csv tables/annoJ_mix.csv > tables/all_samples_peaks.csv
# deepsea dmr -k="Ath_ChIP_peaks" -d 'Ath_mC_readers_peaks' tables/all_samples_peaks.csv --drop
# rm tables/annoJ_mix*

# # ### After repeating this step with different methylation mutants (see Paper_ChIP_final_parallel.sh)

# # for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# # do
	# # awk -v OFS="\t" '{print $0, "WT"}' tables/peaks_mC_${sample}.txt > tables/peaks_mC_${sample}_mutants.txt
	# # awk -v OFS="\t" '{print $0, "mbd1_2_4"}' tables/peaks_mC_${sample}_mbd1_2_4.txt >> tables/peaks_mC_${sample}_mutants.txt
	# # awk -v OFS="\t" '{print $0, "mbd2_5_6"}' tables/peaks_mC_${sample}_mbd2_5_6.txt >> tables/peaks_mC_${sample}_mutants.txt
	# # awk -v OFS="\t" '{print $0, "mbd1_2_5_6"}' tables/peaks_mC_${sample}_mbd1_2_5_6.txt >> tables/peaks_mC_${sample}_mutants.txt
	# # awk -v OFS="\t" '{print $0, "suvh1_3"}' tables/peaks_mC_${sample}_suvh1_3.txt >> tables/peaks_mC_${sample}_mutants.txt
# # done

# # cat tables/peaks_mC_ChIP*_mutants.txt > tables/peaks_mC_mutants.txt


# # #######################################################################################################################################################################
# # ######## To get a single file of all the peaks, merging peaks that share 50bp, getting their annotation, loading it into annoJ and making it a matrix for Upset plots

# awk -F";" -v OFS="\t" 'NR>1 {print $1,$2,$3,$4}' tables/all_samples_peaks.csv | sort -k1,1n -k2,2n > tables/temp_all_peaks_start.bed

# bedmap --echo-map-range --echo-map-id-uniq --bp-ovr 50 --delim '\t' tables/temp_all_peaks_start.bed | sort-bed - | uniq > tables/temp_all_peaks_a.bed
# bedtools merge -i tables/temp_all_peaks_a.bed -d -50 -c 4 -o distinct | awk -v OFS="\t" '{print "Peak_"NR,$0}' | sort -k1,1 > tables/temp_all_peaks_0.bed

# # ######## To get the annotations at all the peaks

# awk -v OFS="\t" '{print $2,$3,$4,$1,".","."}' tables/temp_all_peaks_0.bed > tables/temp_simple_all_peaks.bed
# awk -v OFS="\t" '$3~"transposable_element" {print $0}' annotations/TAIR10_GFF3_genes_transposons.gff | sed 's/Chr//' > annotations/TE.gff
# annotatePeaks.pl tables/temp_simple_all_peaks.bed tair10 -gff annotations/TAIR10_GFF3_genes_transposons.gff -annStats annotations/stats_tair10_all_filtered_peaks.txt > annotations/tempA_annotated_all_filtered_peaks.txt
# awk -v OFS="\t" '(NR>1) && ($9=="Intergenic" || $9=="Chr") {print $2,$3,$4,$1}' annotations/tempA_annotated_all_filtered_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1_all_peaks.bed
# awk -v OFS="\t" '(NR>1) && $9=="promoter-TSS" {print $2,$3,$4,$1}' annotations/tempA_annotated_all_filtered_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1b_all_peaks.bed
# awk -v OFS="\t" '(NR>1) && $9=="TTS" {print $2,$3,$4,$1}' annotations/tempA_annotated_all_filtered_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1c_all_peaks.bed
# awk -v OFS="\t" '(NR>1) && ($9=="exon" || $9=="3'"'"'" || $9=="5'"'"'") {print $2,$3,$4,$1}' annotations/tempA_annotated_all_filtered_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1d_all_peaks.bed
# awk -v OFS="\t" '(NR>1) && $9=="intron" {print $2,$3,$4,$1}' annotations/tempA_annotated_all_filtered_peaks.txt | sort -k1,1 -k2,2n > annotations/temp1e_all_peaks.bed
# bedtools intersect -a annotations/temp1_all_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2_all.txt
# bedtools intersect -a annotations/temp1b_all_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2b_all.txt
# bedtools intersect -a annotations/temp1c_all_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2c_all.txt
# bedtools intersect -a annotations/temp1d_all_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2d_all.txt
# bedtools intersect -a annotations/temp1e_all_peaks.bed -b annotations/TE.gff -loj | sort -k1,1 -k2,2n > annotations/temp2e_all.txt
# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE"; else print $1,$2,$3,$4,"Intergenic"}' annotations/temp2_all.txt > annotations/temp3_all.txt
# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_prom"; else print $1,$2,$3,$4,"Promoter"}' annotations/temp2b_all.txt >> annotations/temp3_all.txt
# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_TTS"; else print $1,$2,$3,$4,"TTS"}' annotations/temp2c_all.txt >> annotations/temp3_all.txt
# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_exon"; else print $1,$2,$3,$4,"Exon"}' annotations/temp2d_all.txt >> annotations/temp3_all.txt
# awk -v OFS="\t" '{if ($7~"transposable_element") print $1,$2,$3,$4,"TE_intron"; else print $1,$2,$3,$4,"Intron"}' annotations/temp2e_all.txt >> annotations/temp3_all.txt
# awk -v OFS="\t" '{if ($5=="TE_intron" || $5=="TE_exon") print $1,$2,$3,$4,"TE_gene"; else print $1,$2,$3,$4,$5}' annotations/temp3_all.txt > annotations/temp4_all.txt
# sort -k1,1n -k2,2n annotations/temp4_all.txt | uniq | awk -v OFS="\t" '{print $4,$5}' | sort -k1,1 > annotations/temp_all_samples_annotated_peaks.txt

# # ###### To load the file of commun peaks on AnnoJ

# join tables/temp_all_peaks_0.bed annotations/temp_all_samples_annotated_peaks.txt | sed 's/;/|/g' | awk -v OFS=";" '{print $2,$3,$4,$1,$5,$6}' > tables/temp_annotated_all_peaks.bed
# cat tables/header_peaks_annoJ.csv tables/temp_annotated_all_peaks.bed > tables/all_samples_merged_peaks.csv
# deepsea dmr -k="Ath_ChIP_peaks" -d 'Ath_mC_readers_peaks' tables/all_samples_merged_peaks.csv --drop

# rm tables/temp*
# rm annotations/temp*

# # ######## To create a matrix where each row is a merged peak and each column is a sample, with value 0 for no and 1 for yes
# awk -F ";" -v OFS="\t" 'NR>1{print $1,$2,$3,$4,$5,$6}' tables/all_samples_merged_peaks.csv > tables/x_annotated_all_peaks_0.bed

# nb=0
# printf "Peak_ID\tChr\tStart\tEnd\tAnnotation" > tables/all_samples_annotated_peak_matrix_header.txt
# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP2_SUVH1 ChIP11_SUVH1 ChIP3_MBD6 ChIP7_MBD6 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4
# do
	# echo "intersecting peaks for $sample..." 
	# if [ "$nb" -lt 13 ]; then
		# printf "\t$sample" >> tables/all_samples_annotated_peak_matrix_header.txt
	# else
		# printf "\t$sample\n" >> tables/all_samples_annotated_peak_matrix_header.txt
	# fi
	# echo "$nb"
	# suf=$((nb+1))
	# echo "$suf"
	# awk -v OFS="\t" -v s=$sample -v n=$nb '{if ($5~s) $(7+n)=1; else $(7+n)=0; print $0}' tables/x_annotated_all_peaks_${nb}.bed > tables/x_annotated_all_peaks_${suf}.bed
	# ((nb++))
# done

# awk -v OFS="\t" '{print $4,$1,$2,$3,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$20}' tables/x_annotated_all_peaks_14.bed | sort -k1,1 > tables/x_all_peaks_matrix_final.txt

# cat tables/all_samples_annotated_peak_matrix_header.txt tables/x_all_peaks_matrix_final.txt > tables/all_samples_merged_peaks_matrix.txt

# rm tables/x_*


#######################################################################################################################################################################
######## For filtering, use the filtered_${sample} files on R and filter the complete_peaks_info_${sample} files based on Peak_ID
######## Process the filtered_${sample} files in R to filter on FC quantile >=20% !!! Need to remove the windows \r new line marker before processing these files !!! 
#######################################################################################################################################################################

##########################################################################################################################################################################
### To prepare the methylation files into BigWig for plotting heatmaps with deeptools

# ### Need a file containing the sizes of the chromosomes
# awk '$1 ~ /[1-9]$/ {print $0}' /home/jcahn/working_data/OpenData/Genomes/tair10/chrom.sizes | sed 's/chr//' > methyl/chromosome_sizes.txt

# ### To prepare the allC tables bgwig files (via bedGraph)
# ### Need bedfiles with methylation data with "ChrX" in the first column, first line works for gzip CGmap files from BSseeker2 output

# for metsample in WT_seedlings MBD1 MBD2 MBD4 MBD5 MBD6 SUVH1 SUVH3 SUVH1_SUVH3 MBD1_MBD2 MBD5_MBD6 MBD1_MBD4 mbd1_2_4 mbd2_5_6 mbd1_2_5_6
# do
	# for context in CG CHG CHH
	# do
		# echo "context $context $metsample"
		# zcat /home/jcahn/working_data/Runs/Map/At_MBDs/BS_seeker2/Hub/mm2_end_${metsample}.CGmap.gz | awk -v OFS="\t" -v t=$context '$4==t && $1 ~ /[1-9]$/ {print $1,$3-1,$3,$6*100}' > methyl/${context}_${metsample}.bedGraph
		# echo "making bigWig"
		# bedGraphToBigWig methyl/${context}_${metsample}.bedGraph methyl/chromosome_sizes.txt methyl/${context}_${metsample}.bw
	# done
# done
# rm methyl/*.bedGraph
# rm /home/jcahn/working_data/Runs/Map/At_MBDs/BS_seeker2/Hub/*

# ########################################################################################################################################################################
# ### Filter the peaks that intersect with genes (from promoter to TSS), keeping one instance of each gene and plot heatmaps with deeptools
# ### (WARNING: One peak that intersect several genes will be present several times)

# # v1= --scaleFactorsMethod "None" --normalizeUsing "CPM" --operation subtract --ignoreDuplicates --minMappingQuality 10
# # v2= --scaleFactorsMethod "None" --normalizeUsing "CPM" --operation subtract --minMappingQuality 10
# # v3= --scaleFactorsMethod "None" --normalizeUsing "CPM" --ignoreDuplicates --minMappingQuality 10
# # v4= --scaleFactorsMethod "None" --normalizeUsing "CPM" --minMappingQuality 10
# # v5= --scaleFactorsMethod "None" --normalizeUsing "CPM"

############################## REMOVE ChrM/Pt before normalization #####################################

# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2 ChIP4_WT
# do
	# # echo "preparing bigwig/bedgraph file for $sample..."
	# # echo "...v1..."
	# # bamCompare -b1 mapped/sorted_${sample}_HA.bam -b2 mapped/sorted_${sample}_INPUT.bam -o deeptools/${sample}_v1.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM" --operation subtract --ignoreDuplicates --minMappingQuality 10
	# # echo "...v2..."
	# # bamCompare -b1 mapped/sorted_${sample}_HA.bam -b2 mapped/sorted_${sample}_INPUT.bam -o deeptools/${sample}_v2.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM" --operation subtract --minMappingQuality 10
	# # echo "...v3..."
	# # bamCompare -b1 mapped/sorted_${sample}_HA.bam -b2 mapped/sorted_${sample}_INPUT.bam -o deeptools/${sample}_v3.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM" --ignoreDuplicates --minMappingQuality 10
	# # echo "...v4..."
	# # bamCompare -b1 mapped/sorted_${sample}_HA.bam -b2 mapped/sorted_${sample}_INPUT.bam -o deeptools/${sample}_v4.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM" --minMappingQuality 10
	# # echo "...v5..."
	# # bamCompare -b1 mapped/sorted_${sample}_HA.bam -b2 mapped/sorted_${sample}_INPUT.bam -o deeptools/${sample}_v5.bw -p 10 -bs 1 --scaleFactorsMethod "None" --normalizeUsing "CPM"
	# for type in HA INPUT
	# do
		# echo "preparing bigwig/bedgraph file for $sample $type dedup..."
		# samtools index -@10 dedupbam/${sample}_${type}.bam
		# bamCoverage -b dedupbam/${sample}_${type}.bam -o dedupbam/${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
		# echo "preparing bigwig/bedgraph file for $sample $type dedup unique..."
		# samtools index -@10 dedupbam/${sample}_${type}.bam
		# bamCoverage -b dedupbam/${sample}_${type}.bam -o dedupbam/${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
		# echo "preparing bigwig/bedgraph file for $sample $type dedup multi..."
		# samtools index -@10 dedupbam/${sample}_${type}.bam
		# bamCoverage -b dedupbam/${sample}_${type}.bam -o dedupbam/${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
		# echo "preparing bigwig/bedgraph file for $sample $type all..."
		# bamCoverage -b mapped/sorted_${sample}_${type}.bam -o mapped/sorted_${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
		# echo "preparing bigwig/bedgraph file for $sample $type all uniq..."
		# bamCoverage -b mapped/sorted_uniq_${sample}_${type}.bam -o mapped/sorted_uniq_${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
		# echo "preparing bigwig/bedgraph file for $sample $type all multi..."
		# bamCoverage -b mapped/sorted_multi_${sample}_${type}.bam -o mapped/sorted_multi_${sample}_${type}.bw --normalizeUsing "CPM" -p 5 --binSize 1
	# done
# done


#########################################################################################################################################################################
#### PlotPCA and correlation

# for vers in v1 v2 v3 v4 v5 
# for vers in v3 v4 v5 
# do
	# echo correlation for $vers
	# multiBigwigSummary bins -b deeptools/ChIP3_MBD1_${vers}.bw deeptools/ChIP6_MBD1_${vers}.bw deeptools/ChIP6_MBD2_rep1_${vers}.bw deeptools/ChIP6_MBD2_rep2_${vers}.bw deeptools/ChIP8_MBD4_rep2_${vers}.bw deeptools/ChIP11_MBD4_${vers}.bw deeptools/ChIP7_MBD5_rep1_${vers}.bw deeptools/ChIP7_MBD5_rep2_${vers}.bw deeptools/ChIP3_MBD6_${vers}.bw deeptools/ChIP7_MBD6_${vers}.bw deeptools/ChIP2_SUVH1_${vers}.bw deeptools/ChIP11_SUVH1_${vers}.bw deeptools/ChIP7_SUVH3_rep1_${vers}.bw deeptools/ChIP7_SUVH3_rep2_${vers}.bw -o deeptools/correlation_${vers}.npz
	# plotPCA -in deeptools/correlation_${vers}.npz -o plots/PCA_${vers}_12.pdf --PCs 1 2
	# plotPCA -in deeptools/correlation_${vers}.npz -o plots/PCA_${vers}_23.pdf --PCs 2 3
	# plotPCA -in deeptools/correlation_${vers}.npz -o plots/PCA_${vers}_13.pdf --PCs 1 3
	# plotCorrelation -in deeptools/correlation_${vers}.npz -c spearman -p heatmap -o plots/correlation_spear_heat_${vers}.pdf
# done

####### NOTES: v1 and v2 (substract) not to be used for plotting with deeptools

#########################################################################################################################################################################
#### All genes

# awk -v OFS="\t" '$3=="gene" {print $1,$4,$5,$9,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff | sed 's/Chr//' | sort -k1,1 -k2,2n > annotations/all_genes.bed

# for sample in MBD1 MBD2 MBD4 MBD5 MBD6 SUVH1 SUVH3
# do
	# for vers in v1 v2 v3 v4 v5 
	# do
		# echo "$sample $vers matrix"
		# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_genes.bed -S deeptools/*${sample}*${vers}.bw -bs 100 -a 4000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_genes_tss_${sample}_${vers}.gz
		# echo "$sample $version heatmap 1"
		# plotHeatmap -m deeptools/matrix_genes_tss_${sample}_${vers}.gz -out plots/heatmap_genes_tss_${sample}_${vers}_mean.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear
		# echo "$sample $version heatmap 2"
		# plotHeatmap -m deeptools/matrix_genes_tss_${sample}_${vers}.gz -out plots/heatmap_genes_tss_${sample}_${vers}_length.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear
		# echo "$sample $version heatmap 3"
		# plotHeatmap -m deeptools/matrix_genes_tss_${sample}_${vers}.gz -out plots/heatmap_genes_tss_${sample}_${vers}_length_k3.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 3 --outFileSortedRegions deeptools/regions_genes_${sample}_${vers}_k3.bed --interpolationMethod bilinear
		# echo "$sample $version heatmap 4"
		# plotHeatmap -m deeptools/matrix_genes_tss_${sample}_${vers}.gz -out plots/heatmap_genes_tss_${sample}_${vers}_length_k5.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 5 --outFileSortedRegions deeptools/regions_genes_${sample}_${vers}_k5.bed --interpolationMethod bilinear
	# done
# done

# for vers in v3 v4
# do
	# echo "SUVHs $vers matrix"
	# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_genes.bed -S deeptools/*SUVH1*${vers}.bw deeptools/*SUVH3*${vers}.bw -bs 100 -a 4000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_genes_tss_SUVHs_${vers}.gz
	# echo "SUVHs $version heatmap 1"
	# plotHeatmap -m deeptools/matrix_genes_tss_SUVHs_${vers}.gz -out plots/heatmap_genes_tss_SUVHs_${vers}_length_k3.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 3 --outFileSortedRegions deeptools/regions_genes_SUVHs_${vers}_k3.bed --interpolationMethod bilinear
	# echo "SUVHs $version heatmap 2"
	# plotHeatmap -m deeptools/matrix_genes_tss_SUVHs_${vers}.gz -out plots/heatmap_genes_tss_SUVHs_${vers}_length_k5.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 5 --outFileSortedRegions deeptools/regions_genes_SUVHs_${vers}_k5.bed --interpolationMethod bilinear
	
	## best
	# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_genes_SUVHs_${vers}_k3.bed -S deeptools/*SUVH1*${vers}.bw deeptools/*SUVH3*${vers}.bw deeptools/*MBD1*${vers}.bw deeptools/*MBD2*${vers}.bw deeptools/*MBD4*${vers}.bw deeptools/*MBD5*${vers}.bw deeptools/*MBD6*${vers}.bw -bs 100 -a 4000 -b 2000 -p 10 -o deeptools/matrix_genes_tss_based_on_suvhs_chip_${vers}.gz
	# plotHeatmap -m deeptools/matrix_genes_tss_based_on_suvhs_chip_${vers}.gz -out plots/heatmap_genes_tss_chip_${vers}.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear 
	# plotHeatmap -m deeptools/matrix_genes_tss_based_on_suvhs_chip_${vers}.gz -out plots/heatmap_genes_tss_chip_${vers}_2.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --zMin -1 -1 -1 --zMax 1 1 1
	
	# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_genes_SUVHs_${vers}_k3.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -a 4000 -b 2000 -p 10 -o deeptools/matrix_genes_tss_based_on_suvhs_met_${vers}.gz
	# plotHeatmap -m deeptools/matrix_genes_tss_based_on_suvhs_met_${vers}.gz -out plots/heatmap_genes_tss_met_${vers}.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges' --interpolationMethod nearest --zMin 0 0 0 --zMax 100 50 30

	
	# echo "MBD256 $vers matrix"
	# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_genes.bed -S deeptools/*MBD2*${vers}.bw deeptools/*MBD5*${vers}.bw deeptools/*MBD6*${vers}.bw -bs 100 -a 4000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_genes_tss_MBD256_${vers}.gz
	# echo "MBD256 $version heatmap 1"
	# plotHeatmap -m deeptools/matrix_genes_tss_MBD256_${vers}.gz -out plots/heatmap_genes_tss_MBD256_${vers}_length_k3.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 3 --outFileSortedRegions deeptools/regions_genes_MBD256_${vers}_k3.bed --interpolationMethod bilinear
	# echo "MBD256 $version heatmap 2"
	# plotHeatmap -m deeptools/matrix_genes_tss_MBD256_${vers}.gz -out plots/heatmap_genes_tss_MBD256_${vers}_length_k5.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 5 --outFileSortedRegions deeptools/regions_genes_MBD256_${vers}_k5.bed --interpolationMethod bilinear

	# echo "MBD124 $vers matrix"
	# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_genes.bed -S deeptools/*MBD1*${vers}.bw deeptools/*MBD2*${vers}.bw deeptools/*MBD4*${vers}.bw -bs 100 -a 4000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_genes_tss_MBD124_${vers}.gz
	# echo "MBD256 $version heatmap 1"
	# plotHeatmap -m deeptools/matrix_genes_tss_MBD124_${vers}.gz -out plots/heatmap_genes_tss_MBD124_${vers}_length_k3.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 3 --outFileSortedRegions deeptools/regions_genes_MBD124_${vers}_k3.bed --interpolationMethod bilinear
	# echo "MBD256 $version heatmap 2"
	# plotHeatmap -m deeptools/matrix_genes_tss_MBD124_${vers}.gz -out plots/heatmap_genes_tss_MBD124_${vers}_length_k5.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 5 --outFileSortedRegions deeptools/regions_genes_MBD124_${vers}_k5.bed --interpolationMethod bilinear
	
	# echo "MBDs $vers matrix"
	# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_genes.bed -S deeptools/*MBD1*${vers}.bw deeptools/*MBD2*${vers}.bw deeptools/*MBD4*${vers}.bw deeptools/*MBD5*${vers}.bw deeptools/*MBD6*${vers}.bw -bs 100 -a 4000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_genes_tss_MBDs_${vers}.gz
	# echo "MBDs $version heatmap 1"
	# plotHeatmap -m deeptools/matrix_genes_tss_MBDs_${vers}.gz -out plots/heatmap_genes_tss_MBDs_${vers}_length_k3.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 3 --outFileSortedRegions deeptools/regions_genes_MBDs_${vers}_k3.bed --interpolationMethod bilinear
	# echo "MBD256 $version heatmap 2"
	# plotHeatmap -m deeptools/matrix_genes_tss_MBDs_${vers}.gz -out plots/heatmap_genes_tss_MBDs_${vers}_length_k5.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 5 --outFileSortedRegions deeptools/regions_genes_MBDs_${vers}_k5.bed --interpolationMethod bilinear
# done

#########################################################################################################################################################################
### To get genes with GbM

# echo "computing met matrix..."
# computeMatrix scale-regions -R annotations/all_genes.bed -S methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -p 10 -o deeptools/matrix_CH_genes.gz
# plotHeatmap -m deeptools/matrix_CH_genes.gz -out plots/heatmap_CH_genes_v1.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'Oranges' --outFileSortedRegions deeptools/regions_CH_genes_v1.bed --kmeans 2
# plotHeatmap -m deeptools/matrix_CH_genes.gz -out plots/heatmap_CH_genes_v2.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'Oranges' --outFileSortedRegions deeptools/regions_CH_genes_v2.bed --kmeans 3
# plotHeatmap -m deeptools/matrix_CH_genes.gz -out plots/heatmap_CH_genes_v3.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'Oranges' --outFileSortedRegions deeptools/regions_CH_genes_v3.bed --kmeans 4
# plotHeatmap -m deeptools/matrix_CH_genes.gz -out plots/heatmap_CH_genes_v4.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'Oranges' --outFileSortedRegions deeptools/regions_CH_genes_v4.bed --kmeans 5

# computeMatrix scale-regions -R deeptools/regions_CH_genes_v1.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -p 10 -o deeptools/matrix_CN_genes_v1.gz
# plotHeatmap -m deeptools/matrix_CN_genes_v1.gz -out plots/heatmap_CN_genes_v1.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges'
# computeMatrix scale-regions -R deeptools/regions_CH_genes_v2.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -p 10 -o deeptools/matrix_CN_genes_v2.gz
# plotHeatmap -m deeptools/matrix_CN_genes_v2.gz -out plots/heatmap_CN_genes_v2.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges'
# computeMatrix scale-regions -R deeptools/regions_CH_genes_v4.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -p 10 -o deeptools/matrix_CN_genes_v4.gz
# plotHeatmap -m deeptools/matrix_CN_genes_v4.gz -out plots/heatmap_CN_genes_v4.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges'

# ## best
# computeMatrix scale-regions -R deeptools/regions_CH_genes_v3.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -p 10 -o deeptools/matrix_CN_genes_v3.gz

# awk -v OFS="\t" 'NR>1 && $13=="cluster_4" {print $1,$2,$3,$4,$5,$6}' deeptools/regions_CH_genes_v3.bed > annotations/GbM_genes.bed

# computeMatrix scale-regions -R annotations/GbM_genes.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw --skipZeros -p 10 -o deeptools/matrix_GbM_met.gz
# plotHeatmap -m deeptools/matrix_GbM_met.gz -out plots/heatmap_GbM_met.pdf --sortRegions descend --sortUsing mean --sortUsingSamples 1 --missingDataColor 0.9 --colorMap 'Oranges' --whatToShow 'heatmap and colorbar' --zMin 0 0 0 --zMax 100 10 10 --interpolationMethod nearest --outFileSortedRegions deeptools/regions_CG_genes_sorted.bed
# plotHeatmap -m deeptools/matrix_GbM_met.gz -out plots/heatmap_GbM_met2.pdf --sortRegions descend --sortUsing sum --sortUsingSamples 1 --missingDataColor 0.9 --colorMap 'Oranges' --whatToShow 'heatmap and colorbar' --zMin 0 0 0 --zMax 100 10 10 --interpolationMethod nearest --outFileSortedRegions deeptools/regions_CG_genes_sorted_2.bed

# computeMatrix scale-regions -R deeptools/regions_CG_genes_sorted.bed -S deeptools/*MBD1*v3.bw deeptools/*MBD2*v3.bw deeptools/*MBD4*v3.bw deeptools/*MBD5*v3.bw deeptools/*MBD6*v3.bw deeptools/*SUVH1*v3.bw deeptools/*SUVH3*v3.bw -p 10 -o deeptools/matrix_GbM_chip_v3.gz
# plotHeatmap -m deeptools/matrix_GbM_chip_v3.gz -out plots/heatmap_GbM_chip_v3.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --whatToShow 'heatmap and colorbar' --zMin -1 --zMax 1 --interpolationMethod bilinear

# computeMatrix scale-regions -R deeptools/regions_CG_genes_sorted.bed -S deeptools/*MBD1*v4.bw deeptools/*MBD2*v4.bw deeptools/*MBD4*v4.bw deeptools/*MBD5*v4.bw deeptools/*MBD6*v4.bw deeptools/*SUVH1*v4.bw deeptools/*SUVH3*v4.bw -p 10 -o deeptools/matrix_GbM_chip_v4.gz
# plotHeatmap -m deeptools/matrix_GbM_chip_v4.gz -out plots/heatmap_GbM_chip_v4.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --whatToShow 'heatmap and colorbar' --zMin -1 --zMax 1 --interpolationMethod bilinear

# computeMatrix scale-regions -R deeptools/regions_CG_genes_sorted_2.bed -S deeptools/*MBD1*v3.bw deeptools/*MBD2*v3.bw deeptools/*MBD4*v3.bw deeptools/*MBD5*v3.bw deeptools/*MBD6*v3.bw deeptools/*SUVH1*v3.bw deeptools/*SUVH3*v3.bw -p 10 -o deeptools/matrix_GbM_chip_v3_2.gz
# plotHeatmap -m deeptools/matrix_GbM_chip_v3_2.gz -out plots/heatmap_GbM_chip_v3_2.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --whatToShow 'heatmap and colorbar' --zMin -1 -1 -1 --zMax 1 1 1 --interpolationMethod bilinear

# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_CG_genes_sorted_2.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -p 10 -a 6000 -b 2000 -o deeptools/matrix_GbM_met_tss.gz
# plotHeatmap -m deeptools/matrix_GbM_met_tss.gz -out plots/heatmap_GbM_met_tss.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'Oranges' --whatToShow 'heatmap and colorbar' --zMin 0 0 0 --zMax 100 50 30 --interpolationMethod nearest --outFileSortedRegions deeptools/GbM_genes_length.bed

# computeMatrix reference-point --referencePoint "TSS" -R deeptools/GbM_genes_length.bed -S deeptools/*MBD1*v3.bw deeptools/*MBD2*v3.bw deeptools/*MBD4*v3.bw deeptools/*MBD5*v3.bw deeptools/*MBD6*v3.bw deeptools/*SUVH1*v3.bw deeptools/*SUVH3*v3.bw -p 10 -a 6000 -b 2000 -o deeptools/matrix_GbM_chip_v3_tss.gz
# plotHeatmap -m deeptools/matrix_GbM_chip_v3_tss.gz -out plots/heatmap_GbM_chip_v3_tss.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --whatToShow 'heatmap and colorbar' --zMin -1 -1 -1 --zMax 1 1 1 --interpolationMethod bilinear

# computeMatrix reference-point --referencePoint "TSS" -R deeptools/GbM_genes_length.bed -S deeptools/*MBD1*v4.bw deeptools/*MBD2*v4.bw deeptools/*MBD4*v4.bw deeptools/*MBD5*v4.bw deeptools/*MBD6*v4.bw deeptools/*SUVH1*v4.bw deeptools/*SUVH3*v4.bw -p 10 -a 6000 -b 2000 -o deeptools/matrix_GbM_chip_v4_tss.gz
# plotHeatmap -m deeptools/matrix_GbM_chip_v4_tss.gz -out plots/heatmap_GbM_chip_v4_tss.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --whatToShow 'heatmap and colorbar' --zMin -1 -1 -1 --zMax 1 1 1 --interpolationMethod bilinear

#################################################################################################################################################################################
### Bound genes

# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# do
	# echo "$sample"
	# awk -v OFS="\t" '$8=="Promoter" || $8=="Exon" || $8=="Intron" || $8=="TTS" {print $2,$3,$4,$1}' tables/complete_${sample}.txt > annotations/${sample}_peaks_in_genes.bed
# done

# cat annotations/ChIP*_peaks_in_genes.bed | sort -k1,1n -k2,2n > annotations/all_peaks_in_genes.bed
# bedtools intersect -a annotations/all_peaks_in_genes.bed -b annotations/all_genes.bed -wa -wb -loj | awk -v OFS="\t" '$5!="." {print $5,$6,$7,$8,$9,$10}' | sort -k1,1 -k2,2n | uniq > annotations/all_bound_genes.txt

# echo "matrix genes"
# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_bound_genes.txt -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP11_MBD4_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -a 6000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_bound_genes_best.gz
# echo "heatmap genes"
# plotHeatmap -m deeptools/matrix_bound_genes_best.gz -out plots/heatmap_bound_genes_k5.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 5 --interpolationMethod bilinear --outFileSortedRegions deeptools/regions_bound_genes_k5.bed
# plotHeatmap -m deeptools/matrix_bound_genes_best.gz -out plots/heatmap_bound_genes_k4.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 4 --interpolationMethod bilinear --outFileSortedRegions deeptools/regions_bound_genes_k4.bed
# plotHeatmap -m deeptools/matrix_bound_genes_best.gz -out plots/heatmap_bound_genes_k3.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 3 --interpolationMethod bilinear --outFileSortedRegions deeptools/regions_bound_genes_k3.bed

# echo "matrix genes chip"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_genes_k5.bed -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP11_MBD4_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -a 6000 -b 2000 -p 10 -o deeptools/matrix_bound_genes_best_k5_chip.gz
# plotHeatmap -m deeptools/matrix_bound_genes_best_k5_chip.gz -out plots/heatmap_bound_genes_k5_chip.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --zMin -1 -1 --zMax 1 1 --whatToShow 'heatmap and colorbar'
# echo "matrix genes met"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_genes_k5.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -a 6000 -b 2000 -p 10 -o deeptools/matrix_bound_genes_best_k5_met.gz
# plotHeatmap -m deeptools/matrix_bound_genes_best_k5_met.gz -out plots/heatmap_bound_genes_k5_met.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges' --zMin 0 0 0 --zMax 100 50 30 --interpolationMethod nearest --whatToShow 'heatmap and colorbar'


# echo "matrix genes"
# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_bound_genes.txt -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP8_MBD4_rep2_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -a 6000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_bound_genes_bestB.gz
# echo "heatmap genes"
# plotHeatmap -m deeptools/matrix_bound_genes_bestB.gz -out plots/heatmap_bound_genes_k5B.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 5 --interpolationMethod bilinear --outFileSortedRegions deeptools/regions_bound_genes_k5B.bed

# echo "matrix genes chip"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_genes_k5B.bed -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP8_MBD4_rep2_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -a 6000 -b 2000 -p 10 -o deeptools/matrix_bound_genes_best_k5_chipB.gz
# plotHeatmap -m deeptools/matrix_bound_genes_best_k5_chipB.gz -out plots/heatmap_bound_genes_k5_chipB.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --zMin -1 -1 --zMax 1 1 --whatToShow 'heatmap and colorbar'
# echo "matrix genes met"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_genes_k5B.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -a 6000 -b 2000 -p 10 -o deeptools/matrix_bound_genes_best_k5_metB.gz
# plotHeatmap -m deeptools/matrix_bound_genes_best_k5_metB.gz -out plots/heatmap_bound_genes_k5_metB.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges' --zMin 0 0 0 --zMax 100 50 30 --interpolationMethod nearest --whatToShow 'heatmap and colorbar'

# echo "matrix genes"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_genes_k5B.bed -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP8_MBD4_rep2_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw rna/WT_a.bw -bs 100 -a 6000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_bound_genes_combB.gz
# echo "heatmap genes"
# plotHeatmap -m deeptools/matrix_bound_genes_combB.gz -out plots/heatmap_bound_genes_combB.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' 'viridis' --interpolationMethod nearest --zMin -1 -1 -1 -1 -1 -1 -1 0 0 0 0 --zMax 1 1 1 1 1 1 1 100 50 30 5 --whatToShow 'heatmap and colorbar'


# for rnasample in WT suvh1_3 mbd1_2_4 mbd1_2_5_6 mbd2_5_6
# do
	# path="/home/jcahn/working_data/Runs/RNAseq/At_MBD/RS5/mapstar"
	# echo "$rnasample in $path"
	# for rep in a b c
	# do
		# echo "$rep"
		# bamCoverage --bam ${path}/x2_${rnasample}_${rep}*.bam -o rna/${rnasample}_${rep}_rev.bw -p 5 --binSize 10 --normalizeUsing CPM --filterRNAstrand reverse
		# bamCoverage --bam ${path}/x2_${rnasample}_${rep}*.bam -o rna/${rnasample}_${rep}_for.bw -p 5 --binSize 10 --normalizeUsing CPM --filterRNAstrand forward
		# bamCoverage --bam ${path}/x2_${rnasample}_${rep}*.bam -o rna/${rnasample}_${rep}.bw -p 5 --binSize 10 --normalizeUsing CPM
	# done
# done

#################################################################################################################################################################################
#### Bound TEs
# awk -v OFS="\t" '$3~"transposable_element" {print $1,$4,$5,$9,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff | sed 's/Chr//' | sort -k1,1 -k2,2n > annotations/all_TEs.bed

# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# do
	# echo "$sample"
	# awk -v OFS="\t" '$8=="TE" || $8=="TE_prom" || $8=="TE_gene" || $8=="TE_TTS" {print $2,$3,$4,$1}' tables/complete_${sample}.txt > annotations/${sample}_peaks_in_TEs.bed
# done

# cat annotations/ChIP*_peaks_in_TEs.bed | sort -k1,1n -k2,2n > annotations/all_peaks_in_TEs.bed
# bedtools intersect -a annotations/all_peaks_in_TEs.bed -b annotations/all_TEs.bed -wa -wb -loj | awk -v OFS="\t" '$5!="." {print $5,$6,$7,$8,$9,$10}' | sort -k1,1 -k2,2n | uniq > annotations/all_bound_TEs.txt

# awk -v OFS="\t" '$3-$2>=2000' annotations/all_bound_TEs.txt > annotations/all_bound_long_TEs.txt
# awk -v OFS="\t" '$3-$2<2000' annotations/all_bound_TEs.txt > annotations/all_bound_short_TEs.txt

#### Long bound TEs
# # echo "matrix long TEs"
# # computeMatrix scale-regions -R annotations/all_bound_long_TEs.txt -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP11_MBD4_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -m 2000 --unscaled5prime 1000 --unscaled3prime 1000 -a 3000 -b 3000 -p 10 --skipZeros -o deeptools/matrix_bound_long_TEs_best.gz
# echo "heatmap long TEs"
# plotHeatmap -m deeptools/matrix_bound_long_TEs_best.gz -out plots/heatmap_bound_long_TEs_best_k2.pdf --sortRegions descend --sortUsing sum --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 2 --outFileSortedRegions deeptools/regions_bound_long_TEs_k2.bed --interpolationMethod bilinear
# # plotHeatmap -m deeptools/matrix_bound_long_TEs_best.gz -out plots/heatmap_bound_long_TEs_best_k4.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 4 --outFileSortedRegions deeptools/regions_bound_long_TEs_k4.bed --interpolationMethod bilinear

# echo "matrix long TEs chip"
# computeMatrix scale-regions -R deeptools/regions_bound_long_TEs_k2.bed -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP11_MBD4_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -m 2000 --unscaled5prime 1000 --unscaled3prime 1000 -a 3000 -b 3000 -p 10 -o deeptools/matrix_bound_long_TEs_best_k2_chip.gz
# echo "heatmap long TEs"
# plotHeatmap -m deeptools/matrix_bound_long_TEs_best_k2_chip.gz -out plots/heatmap_bound_long_TEs_best_k2_chip.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --whatToShow 'heatmap and colorbar'
# echo "matrix long TEs chip"
# computeMatrix scale-regions -R deeptools/regions_bound_long_TEs_k2.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -m 2000 --unscaled5prime 1000 --unscaled3prime 1000 -a 3000 -b 3000 -p 10 -o deeptools/matrix_bound_long_TEs_best_k2_met.gz
# echo "heatmap long TEs"
# plotHeatmap -m deeptools/matrix_bound_long_TEs_best_k3_met.gz -out plots/heatmap_bound_long_TEs_best_k2_met.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar'


# echo "heatmap long TEs"
# plotHeatmap -m deeptools/matrix_bound_long_TEs_best.gz -out plots/heatmap_bound_long_TEs_best_k1_chip.pdf --sortRegions descend --sortUsing sum --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --whatToShow 'heatmap and colorbar' --outFileSortedRegions deeptools/regions_bound_long_TEs_k1.bed
# echo "matrix long TEs chip"
# computeMatrix scale-regions -R deeptools/regions_bound_long_TEs_k1.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -m 2000 --unscaled5prime 1000 --unscaled3prime 1000 -a 3000 -b 3000 -p 10 -o deeptools/matrix_bound_long_TEs_best_k1_met.gz
# echo "heatmap long TEs"
# plotHeatmap -m deeptools/matrix_bound_long_TEs_best_k1_met.gz -out plots/heatmap_bound_long_TEs_best_k1_met.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar'

# echo "matrix long TEs chip"
# computeMatrix scale-regions -R deeptools/regions_bound_long_TEs_k1.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -m 2000 --unscaled5prime 1000 --unscaled3prime 1000 -a 3000 -b 3000 -p 10 -o deeptools/matrix_bound_long_TEs_best_k1_met.gz
# echo "heatmap long TEs"
# plotHeatmap -m deeptools/matrix_bound_long_TEs_best_k1_met.gz -out plots/heatmap_bound_long_TEs_best_k1_met.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar'

# echo "matrix long TEs chip"
# computeMatrix scale-regions -R annotations/all_bound_long_TEs.txt -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP8_MBD4_rep2_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -m 2000 --unscaled5prime 1000 --unscaled3prime 1000 -a 3000 -b 3000 --skipZeros -p 10 -o deeptools/matrix_bound_long_TEs_comb.gz
# echo "heatmap long TEs"
# plotHeatmap -m deeptools/matrix_bound_long_TEs_comb.gz -out plots/heatmap_bound_long_TEs_comb.pdf --sortRegions descend --sortUsing sum --sortUsingSamples 8 9 10 --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar' --zMin -1 -1 -1 -1 -1 -1 -1 0 0 0 --zMax 1 1 1 1 1 1 1 100 50 30
# plotHeatmap -m deeptools/matrix_bound_long_TEs_comb.gz -out plots/heatmap_bound_long_TEs_comb2.pdf --sortRegions descend --sortUsing mean --sortUsingSamples 8 9 10 --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar' --zMin -1 -1 -1 -1 -1 0 0 0 --zMax 1 1 1 1 1 1 1 100 50 30
# plotHeatmap -m deeptools/matrix_bound_long_TEs_comb.gz -out plots/heatmap_bound_long_TEs_comb3.pdf --sortRegions descend --sortUsing median --sortUsingSamples 8 9 10 --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar' --zMin -1 -1 -1 -1 -1 -1 -1 0 0 0 --zMax 1 1 1 1 1 1 1 100 50 30



#### Short bound TEs
# echo "matrix short TEs"
# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_bound_short_TEs.txt -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP11_MBD4_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -a 4000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_bound_short_TEs_best.gz
# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best.gz -out plots/heatmap_bound_short_TEs_best_k3.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 3 --outFileSortedRegions deeptools/regions_bound_short_TEs_k3.bed --interpolationMethod bilinear
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best.gz -out plots/heatmap_bound_short_TEs_best_k4.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 4 --outFileSortedRegions deeptools/regions_bound_short_TEs_k4.bed --interpolationMethod bilinear

# echo "matrix short TEs chip"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_short_TEs_k3.bed -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP11_MBD4_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -a 4000 -b 2000 -p 10 -o deeptools/matrix_bound_short_TEs_best_k3_chip.gz
# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best_k3_chip.gz -out plots/heatmap_bound_short_TEs_best_k3_chip.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --zMin -1 -1 --zMax 1 1 --whatToShow 'heatmap and colorbar'

# echo "matrix short TEs met"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_short_TEs_k3.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -a 4000 -b 2000 -p 10 -o deeptools/matrix_bound_short_TEs_best_k3_met.gz
# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best_k3_met.gz -out plots/heatmap_bound_short_TEs_best_k3_met.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar'


# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best.gz -out plots/heatmap_bound_short_TEs_best_k3.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'coolwarm' --kmeans 2 --outFileSortedRegions deeptools/regions_bound_short_TEs_k2.bed --interpolationMethod bilinear
# echo "matrix short TEs chip"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_short_TEs_k2.bed -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP11_MBD4_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw -bs 100 -a 4000 -b 2000 -p 10 -o deeptools/matrix_bound_short_TEs_best_k2_chip.gz
# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best_k2_chip.gz -out plots/heatmap_bound_short_TEs_best_k2_chip.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --zMin -1 -1 --zMax 1 1 --whatToShow 'heatmap and colorbar'

# echo "matrix short TEs met"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_short_TEs_k2.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -a 4000 -b 2000 -p 10 -o deeptools/matrix_bound_short_TEs_best_k2_met.gz
# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best_k2_met.gz -out plots/heatmap_bound_short_TEs_best_k2_met.pdf --sortRegions descend --sortUsing mean --missingDataColor 0.9 --colorMap 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar' --zMin 0 0 0 --zMax 100 50 30

# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best.gz -out plots/heatmap_bound_short_TEs_best_k1_chip.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' --interpolationMethod bilinear --zMin -1 -1 --zMax 1 1 --whatToShow 'heatmap and colorbar' --outFileSortedRegions deeptools/regions_bound_short_TEs_k1.bed

# echo "matrix short TEs met"
# computeMatrix reference-point --referencePoint "TSS" -R deeptools/regions_bound_short_TEs_k1.bed -S methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -a 4000 -b 2000 -p 10 -o deeptools/matrix_bound_short_TEs_best_k1_met.gz
# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_best_k1_met.gz -out plots/heatmap_bound_short_TEs_best_k1_met.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'Oranges' --interpolationMethod nearest --whatToShow 'heatmap and colorbar' --zMin 0 0 0 --zMax 100 50 30

# echo "matrix short TEs"
# computeMatrix reference-point --referencePoint "TSS" -R annotations/all_bound_short_TEs.txt -S deeptools/ChIP3_MBD1_v3.bw deeptools/ChIP6_MBD2_rep1_v3.bw deeptools/ChIP8_MBD4_rep2_v3.bw deeptools/ChIP7_MBD5_rep1_v3.bw deeptools/ChIP3_MBD6_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw -bs 100 -a 4000 -b 2000 -p 10 --skipZeros -o deeptools/matrix_bound_short_TEs_comb.gz
# echo "heatmap short TEs"
# plotHeatmap -m deeptools/matrix_bound_short_TEs_comb.gz -out plots/heatmap_bound_short_TEs_comb.pdf --sortRegions descend --sortUsing sum --sortUsingSamples 8 9 10 --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' --interpolationMethod nearest --zMin -1 -1 -1 -1 -1 -1 -1 0 0 0 --zMax 1 1 1 1 1 1 1 100 50 30 --whatToShow 'heatmap and colorbar'
# plotHeatmap -m deeptools/matrix_bound_short_TEs_comb.gz -out plots/heatmap_bound_short_TEs_comb2.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' --interpolationMethod nearest --zMin -1 -1 -1 -1 -1 -1 -1 0 0 0 --zMax 1 1 1 1 1 1 1 100 50 30 --whatToShow 'heatmap and colorbar'
# plotHeatmap -m deeptools/matrix_bound_short_TEs_comb.gz -out plots/heatmap_bound_short_TEs_comb3.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' --interpolationMethod bilinear --zMin -1 -1 -1 -1 -1 -1 -1 0 0 0 --zMax 1 1 1 1 1 1 1 100 50 30



#########################################################################################################################################################################
## To plot profiles of histone mods around ChIPseq peaks

# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6
# do
	# awk -v OFS="\t" '{print $2,$5,$5+1,$1,".","."}' tables/complete_${sample}.txt > tables/summits_${sample}.bed
# done

# for mark in H2AKub H3K27ac H3K27me3 H3K36me3 H3K4me1 H3K4me2 H3K4me3 H3K9me2
# do
	# echo "MBD1 $mark"
	# computeMatrix reference-point --referencePoint "TSS" -R tables/summits_ChIP3_MBD1.bed tables/summits_ChIP6_MBD1.bed -S histones/WT_${mark}_vsH3.bw histones/MBD1_${mark}_vsH3.bw histones/MBD1_4_${mark}_vsH3.bw histones/MBD2_${mark}_vsH3.bw -p 15 -a 2000 -b 2000 -o histones/matrix_MBD1_${mark}.gz
	# plotProfile -m histones/matrix_MBD1_${mark}.gz -out plots/profiles_MBD1_${mark}.pdf --plotType 'lines' --averageType 'mean' --perGroup
# done

# for mark in H2AKub H3K27ac H3K27me3 H3K36me3 H3K4me1 H3K4me2 H3K4me3 H3K9me2
# do
	# echo "MBD2 $mark"
	# computeMatrix reference-point --referencePoint "TSS" -R tables/summits_ChIP6_MBD2_rep1.bed tables/summits_ChIP6_MBD2_rep2.bed -S histones/WT_${mark}_vsH3.bw histones/MBD1_${mark}_vsH3.bw histones/MBD1_4_${mark}_vsH3.bw histones/MBD2_${mark}_vsH3.bw -p 15 -a 2000 -b 2000 -o histones/matrix_MBD2_${mark}.gz
	# plotProfile -m histones/matrix_MBD2_${mark}.gz -out plots/profiles_MBD2_${mark}.pdf --plotType 'lines' --averageType 'mean' --perGroup
# done

# for mark in H2AKub H3K27ac H3K27me3 H3K36me3 H3K4me1 H3K4me2 H3K4me3 H3K9me2
# do
	# echo "MBD4 $mark"
	# computeMatrix reference-point --referencePoint "TSS" -R tables/summits_ChIP8_MBD4_rep2.bed tables/summits_ChIP11_MBD4.bed -S histones/WT_${mark}_vsH3.bw histones/MBD1_${mark}_vsH3.bw histones/MBD1_4_${mark}_vsH3.bw histones/MBD2_${mark}_vsH3.bw -p 15 -a 2000 -b 2000 -o histones/matrix_MBD4_${mark}.gz
	# plotProfile -m histones/matrix_MBD4_${mark}.gz -out plots/profiles_MBD4_${mark}.pdf --plotType 'lines' --averageType 'mean' --perGroup
# done


# echo "MBD5_6 H3K9me2"
# computeMatrix reference-point --referencePoint "TSS" -R tables/summits_ChIP7_MBD5_rep1.bed tables/summits_ChIP7_MBD5_rep2.bed tables/summits_ChIP3_MBD6.bed tables/summits_ChIP7_MBD6.bed -S histones/WT_H3K9me2_vsH3.bw histones/MBD1_H3K9me2_vsH3.bw histones/MBD1_4_H3K9me2_vsH3.bw histones/MBD2_H3K9me2_vsH3.bw histones/MBD5_6_H3K9me2_vsH3.bw -p 15 -a 2000 -b 2000 -o histones/matrix_MBD5_6_${mark}.gz
# plotProfile -m histones/matrix_MBD5_6_${mark}.gz -out plots/profiles_MBD5_6_${mark}.pdf --plotType 'lines' --averageType 'mean' --perGroup




#########################################################################################################################################################################
#########################################################################################################################################################################

###

# for clust in 1 2 3 4 5
# do
	# awk -v OFS="\t" -v c=$clust 'NR>1 && $13~c {print $1,$2,$3,$4,$5,$6}' deeptools/all_genes_k5_regions.bed > deeptools/genes_cluster_${clust}.bed
# done

# echo "computing genes other matrix..."
# computeMatrix scale-regions -R deeptools/genes_cluster_*.bed deeptools/genes_for_profiles.bed -S histones/H2A.bw histones/H2AW.bw histones/H2AX.bw histones/H2AZ_2.bw histones/WT_H1.bw histones/H3.bw histones/H31.bw histones/H33.bw histones/H3K4me2_rep2.bw histones/WT_H3K4me3.bw histones/WT_H3K36me3.bw histones/seedlings_H3K4me1_rep1.bw histones/H2AK121ub_rep1.bw histones/H3K9ac_rep1.bw histones/H3K23ac.bw histones/H3K9me2.bw histones/H3K27me3_rep1.bw methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw rna/WT_c.bw -bs 200 -m 4000 -a 3000 -b 3000 -p 10 --sortRegions keep -o deeptools/matrix_genes_chip.gz
# plotProfile -m deeptools/matrix_genes_chip.gz -out plots/profiles_genes_chip.pdf --yMin -2 -2 -2 -1.5 0 -1 -2.5 -1.5 -1 -10 0 0 0 -1 0 0 0 0 0 0 0 --yMax 2 2 1.5 2 25 2 1.5 2 5 50 50 50 40 4 40 15 5 100 50 30 80 --plotType 'lines' --averageType 'median' --numPlotsPerRow 4

# echo "computing genes other matrix..."
# computeMatrix scale-regions -R deeptools/genes_cluster_*.bed deeptools/genes_for_profiles.bed -S deeptools/ChIP3_MBD1.bw deeptools/ChIP6_MBD1.bw deeptools/ChIP6_MBD2_rep1.bw deeptools/ChIP6_MBD2_rep2.bw deeptools/ChIP8_MBD4_rep1.bw deeptools/ChIP8_MBD4_rep2.bw deeptools/ChIP7_MBD5_rep1.bw deeptools/ChIP7_MBD5_rep2.bw deeptools/ChIP3_MBD6.bw deeptools/ChIP7_MBD6.bw deeptools/ChIP2_SUVH1.bw deeptools/ChIP3_SUVH1.bw deeptools/ChIP7_SUVH3_rep1.bw deeptools/ChIP7_SUVH3_rep2.bw -bs 200 -m 4000 -a 3000 -b 3000 -p 10 --sortRegions keep -o deeptools/matrix_genes_candidates.gz
# plotProfile -m deeptools/matrix_genes_candidates.gz -out plots/profiles_genes_candidates.pdf --plotType 'lines' --averageType 'median' --numPlotsPerRow 4 --yMin -1 --yMax 2 2 1.5 1.5 1 1 2.5 2.5 2 2 1 1 1.5 1.5


###########################################################################################################################################################################

### test heatmaps per gene cluster

# computeMatrix reference-point --referencePoint "TSS" -R deeptools/genes_cluster_*.bed deeptools/genes_for_profiles.bed -S histones/H2A.bw histones/H2AW.bw histones/H2AX.bw histones/H2AZ_2.bw histones/WT_H1.bw histones/H3.bw histones/H31.bw histones/H33.bw histones/seedlings_H3K4me1_rep1.bw histones/H3K4me2_rep2.bw histones/WT_H3K4me3.bw histones/WT_H3K36me3.bw histones/H2AK121ub_rep1.bw histones/H3K9ac_rep1.bw histones/H3K23ac.bw histones/H3K9me2.bw histones/H3K27me3_rep1.bw methyl/CG_WT_seedlings.bw methyl/CHG_WT_seedlings.bw methyl/CHH_WT_seedlings.bw rna/WT_c.bw -bs 100 -a 6000 -b 3000 -p 10 --skipZeros -o deeptools/matrix_clusters_others.gz

# plotHeatmap -m deeptools/matrix_clusters_others.gz -out plots/heatmap_clusters_others.pdf --sortRegions descend --sortUsing region_length --missingDataColor 0.9 --colorList 'white,black' 'white,red' 'white,blue' 'white,blue' 'white,purple' 'white,black' 'white,black' 'white,red' 'white,blue' 'white,blue' 'white,blue' 'white,blue' 'white,blue' 'white,blue' 'white,purple' 'white,blue' 'white,red' 'white,brown' 'white,brown' 'white,brown' 'white,purple' --whatToShow 'heatmap and colorbar' --zMin -2 -2 -1.5 -1.5 0 -1 -2 -1.5 -1 -10 0 0 0 -1 0 0 0 0 0 0 0 --zMax 2 2 2.5 2.5 30 2 2 2 15 20 50 50 40 4 40 15 15 100 50 30 100

# plotProfile -m deeptools/matrix_clusters_others.gz -out plots/profiles_clusters_others.pdf --yMin -2 -2 -1.5 -1.5 0 -1 -2.5 -1.5 0 -1 0 0 0 -1 0 0 0 0 0 0 0 --yMax 2 2 1.5 2 25 2 1.5 2 25 5 50 50 45 4 45 10 5 100 50 10 60 --plotType 'lines' --averageType 'median' --numPlotsPerRow 4

###### Peaks and motifs finding with the Homer suite

# for sample in ChIP3_MBD6_HA ChIP3_MBD6_INPUT ChIP2_SUVH1_HA ChIP2_SUVH1_INPUT ChIP3_SUVH1_HA ChIP3_SUVH1_INPUT ChIP3_MBD1_HA ChIP3_MBD1_INPUT ChIP6_MBD1_HA ChIP6_MBD1_INPUT ChIP6_MBD2_rep1_HA ChIP6_MBD2_rep1_INPUT ChIP6_MBD2_rep2_HA ChIP6_MBD2_rep2_INPUT ChIP7_SUVH3_rep1_HA ChIP7_SUVH3_rep1_INPUT ChIP7_SUVH3_rep2_HA ChIP7_SUVH3_rep2_INPUT ChIP7_MBD5_rep1_HA ChIP7_MBD5_rep1_INPUT ChIP7_MBD5_rep2_HA ChIP7_MBD5_rep2_INPUT ChIP7_MBD6_HA ChIP7_MBD6_INPUT ChIP8_MBD4_rep1_HA ChIP8_MBD4_rep1_INPUT ChIP8_MBD4_rep2_HA ChIP8_MBD4_rep2_INPUT
# do
	# echo "sample $sample"
	# makeTagDirectory homer/${sample}/ mapped/sorted_${sample}.bam
# done

# for sample in ChIP3_MBD6 ChIP2_SUVH1 ChIP3_SUVH1 ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP7_MBD6 ChIP8_MBD4_rep1 ChIP8_MBD4_rep2
# do
	# echo "sample $sample"	
	# findPeaks homer/${sample}_HA/ -style factor -o homer/peaks_${sample}.txt -i homer/${sample}_INPUT/
	# findMotifsGenome.pl homer/peaks_${sample}.txt tair10 homer/motifs/${sample}/ -size 200 -len 4,6,8,10 -p 15 -S 10
	# findMotifsGenome.pl tables/start_${sample}.bed tair10 homer/motifs_macs/${sample}/ -size given -len 4,6,8,10 -p 15 -S 10
# done


##############################################################################################################################################################################
### To plot genes on DEG found by edgeR

# echo "suvhs deg"
# rm rna/temp*
# sed 's/"//g' rna/DEG_SUVHs_RS4.txt > rna/temp_DEG_SUVHs_RS4.txt
# while read AGI logFC1 logCPM1 PValue1 FDR1 DEG1 Sample1 logFC2 logCPM2 PValue2 FDR2 DEG2 Sample2 logFC logCPM PValue FDR DEG Sample 
# do
	# awk -v OFS="\t" -v a=$AGI '$9~a {print $1,$4,$5,a,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff >> rna/tempdeg_suvhs_RS3.bed
# done < rna/temp_DEG_SUVHs_RS4.txt
# sed 's/Chr//' rna/tempdeg_suvhs_RS3.bed | sort -k1,1 -k2,2n > rna/tempdeg3.bed
# bedtools merge -i rna/tempdeg3.bed -c 4,5,6 -o distinct,distinct,distinct > rna/deg2_suvhs_RS3.bed
# head rna/deg2_suvhs_RS3.bed

# echo "all deg"
# rm rna/temp*
# sed 's/"//g' rna/DEG_all_seedlings_RS3_RS4.txt > rna/temp_DEG_all_seedlings_RS3_RS4.txt
# while read logFC logCPM PValue FDR AGI DEG Sample
# do
	# awk -v OFS="\t" -v a=$AGI '$9~a {print $1,$4,$5,a,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff >> rna/tempdeg_all_RS3_4.bed
# done < rna/temp_DEG_all_seedlings_RS3_RS4.txt
# sed 's/Chr//' rna/tempdeg_all_RS3_4.bed | sort -k1,1 -k2,2n > rna/tempdeg3.bed
# bedtools merge -i rna/tempdeg3.bed -c 4,5,6 -o distinct,distinct,distinct > rna/deg2_all_RS3_4.bed
# head rna/deg2_all_RS3_4.bed
# rm rna/temp*

# for rnasample in WT SUVH1 SUVH3 SUVH1_SUVH3
# do
	# path="/home/jcahn/working_data/Runs/RNAseq/At_MBD/RS4/mapstar"
	# echo "$rnasample in $path"
	# for rep in a b c
	# do
		# echo "$rep"
		# samtools index ${path}/${rnasample}_${rep}*.bam
		# bamCoverage --bam ${path}/${rnasample}_${rep}*.bam -o rna/${rnasample}_${rep}_rev.bw --binSize 1 --normalizeUsing CPM --filterRNAstrand reverse
		# bamCoverage --bam ${path}/${rnasample}_${rep}*.bam -o rna/${rnasample}_${rep}_for.bw --binSize 1 --normalizeUsing CPM --filterRNAstrand forward
		# bamCoverage --bam ${path}/${rnasample}_${rep}*.bam -o rna/${rnasample}_${rep}.bw --binSize 1 --normalizeUsing CPM
	# done
# done

# for metsample in SUVH1_SUVH3 SUVH1 SUVH3
# do
	# path="/home/jcahn/working_data/Runs/Map/At_MBDs/BS_seeker2/methylcall_ML10"
	# for context in CG CHG CHH
	# do
		# zcat ${path}/mm2_end_${metsample}.ATCGmap.gz | awk -v OFS="\t" -v t=$context '$4==t && $1 ~ /[1-9]$/ {print $1,$3-1,$3,$16*100}' | sed 's/chr//' | sort -k1,1 -k2,2n > methyl/${context}_${metsample}.bedGraph
		# echo "making bigWig"
		# bedGraphToBigWig methyl/${context}_${metsample}.bedGraph methyl/chromosome_sizes.txt methyl/${context}_${metsample}.bw
	# done
# done
# rm methyl/*.bedGraph

# for folder in DEG_stranded DEG
# do
	# for sample in HDG11_HDG12 MBD1 MBD2 MBD1_MBD2 MBD4 MBD1_MBD4 mbd1_2_4 MBD5 MBD6 MBD5_MBD6 mbd2_5_6 mbd1_2_5_6 SUVH1 SUVH3 SUVH1_SUVH3 suvh1_3 mbd1_2_5_6_stress
	# do
		# # rm rna/${folder}/temp*
		# sed 's/"//g' rna/${folder}/DEG_${sample}.txt > rna/${folder}/temp1.txt
		# # while read logFC logCPM PValue FDR AGI DEG Sample
		# # do
			# # echo $AGI $DEG $Sample
			# # if [ $DEG == "DOWN" ]
			# # then
				# # awk -v OFS="\t" -v a=$AGI '$9~a {print $1,$4,$5,a,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff >> rna/${folder}/temp2_down.bed
			# # elif [ $DEG == "UP" ]
			# # then
				# # awk -v OFS="\t" -v a=$AGI '$9~a {print $1,$4,$5,a,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff >> rna/${folder}/temp2_up.bed
			# # else
				# # echo "Let's start... or Ooops..!"
			# # fi
		# # done < rna/${folder}/temp1.txt
		# # sed 's/Chr//' rna/${folder}/temp2_down.bed | sort -k1,1 -k2,2n > rna/${folder}/temp3_down.bed
		# # bedtools merge -i rna/${folder}/temp3_down.bed -c 4,5,6 -o distinct,distinct,distinct > rna/${folder}/DEG_${sample}_down.bed
		# # sed 's/Chr//' rna/${folder}/temp2_up.bed | sort -k1,1 -k2,2n > rna/${folder}/temp3_up.bed
		# # bedtools merge -i rna/${folder}/temp3_up.bed -c 4,5,6 -o distinct,distinct,distinct > rna/${folder}/DEG_${sample}_up.bed
		# echo $folder $sample
		# sort -k4,4n rna/${folder}/temp1.txt | awk -v OFS="\t" '{print i,$5,$6,$7; i+=1}' | sort -k2,2 > rna/${folder}/temp2.txt
		# head rna/${folder}/temp2.txt
		# join -1 4 -2 2 rna/${folder}/DEG_${sample}_up.bed rna/${folder}/temp2.txt | sort -k7,7n | awk -v OFS="\t" '{print $2,$3,$4,$1,$5,$6}' > rna/${folder}/DEG_${sample}_up_sorted.bed
		# join -1 4 -2 2 rna/${folder}/DEG_${sample}_down.bed rna/${folder}/temp2.txt | sort -k7,7n | awk -v OFS="\t" '{print $2,$3,$4,$1,$5,$6}' > rna/${folder}/DEG_${sample}_down_sorted.bed
		# head rna/${folder}/DEG_${sample}_up_sorted.bed
		# head rna/${folder}/DEG_${sample}_down_sorted.bed
	# done
# done

# echo "empty files that will be deleted:"
# find rna/DEG/*.bed -size 0 -print
# find rna/DEG/*.bed -size 0 -delete
# find rna/DEG_stranded/*.bed -size 0 -print
# find rna/DEG_stranded/*.bed -size 0 -delete

# sed 's/"//g' rna/DEG_stranded/Res_MOps2.tab > rna/DEG_stranded/temp1.txt
# while read logFC logCPM PValue FDR AGI DEG Sample
# do
	# echo $AGI $DEG $Sample
	# if [ $DEG == "DOWN" ]
	# then
		# awk -v OFS="\t" -v a=$AGI '$9~a {print $1,$4,$5,a,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff >> rna/DEG_stranded/temp2_down.bed
	# elif [ $DEG == "UP" ]
	# then
		# awk -v OFS="\t" -v a=$AGI '$9~a {print $1,$4,$5,a,".",$7}' annotations/TAIR10_GFF3_genes_transposons.gff >> rna/DEG_stranded/temp2_up.bed
	# else
		# echo "Let's start... or Ooops..!"
	# fi
# done < rna/DEG_stranded/temp1.txt
# rm rna/DEG_stranded/temp*

# echo "computing suvhs deg matrix..."
# computeMatrix reference-point --referencePoint "TSS" -R rna/DEG/DEG_SUVH1_down_sorted.bed rna/DEG/DEG_SUVH3_down_sorted.bed rna/DEG/DEG_SUVH1_SUVH3_down_sorted.bed rna/DEG/DEG_suvh1_3_down_sorted.bed rna/DEG/DEG_SUVH1_SUVH3_up_sorted.bed rna/DEG/DEG_suvh1_3_up_sorted.bed -S deeptools/ChIP2_SUVH1_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw methyl/CG_WT_seedlings.bw methyl/CG_SUVH1_SUVH3.bw methyl/CHG_WT_seedlings.bw methyl/CHG_SUVH1_SUVH3.bw methyl/CHH_WT_seedlings.bw methyl/CHH_SUVH1_SUVH3.bw rna/WT_a.bw rna/WT_b.bw rna/WT_c.bw rna/SUVH1_SUVH3_a.bw rna/SUVH1_SUVH3_b.bw rna/SUVH1_SUVH3_c.bw -p 10 -a 6000 -b 2000 --skipZeros -o deeptools/matrix_DEG_suvhs.gz

# echo "computing suvhs deg matrix..."
# computeMatrix reference-point --referencePoint "TSS" -R rna/DEG/DEG_suvh1_3_down_sorted.bed rna/DEG/DEG_suvh1_3_up_sorted.bed -S deeptools/ChIP2_SUVH1_v3.bw deeptools/ChIP11_SUVH1_v3.bw deeptools/ChIP7_SUVH3_rep1_v3.bw deeptools/ChIP7_SUVH3_rep2_v3.bw methyl/CG_WT_seedlings.bw methyl/CG_SUVH1_SUVH3.bw methyl/CHG_WT_seedlings.bw methyl/CHG_SUVH1_SUVH3.bw methyl/CHH_WT_seedlings.bw methyl/CHH_SUVH1_SUVH3.bw rna/WT_a.bw rna/WT_b.bw rna/WT_c.bw rna/SUVH1_SUVH3_a.bw rna/SUVH1_SUVH3_b.bw rna/SUVH1_SUVH3_c.bw -p 10 -a 6000 -b 2000 --skipZeros -o deeptools/matrix_DEG_suvhs13.gz

# plotHeatmap -m deeptools/matrix_DEG_suvhs13.gz -out plots/heatmap_DEG_suvhs13_v1.pdf --sortRegions descend --sortUsing mean --sortUsingSamples 1 3 --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' 'Oranges' 'Oranges' 'Oranges' 'viridis' 'viridis' 'viridis' 'viridis' 'viridis' 'viridis' --zMin -2 -2 -2 -2 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 --zMax 2 2 2 2 100 100 50 50 30 30 5 5 5 5 5 5 --whatToShow 'heatmap and colorbar'

# plotHeatmap -m deeptools/matrix_DEG_suvhs13.gz -out plots/heatmap_DEG_suvhs13_v2.pdf --sortRegions keep --missingDataColor 0.9 --colorMap 'coolwarm' 'coolwarm' 'coolwarm' 'coolwarm' 'Oranges' 'Oranges' 'Oranges' 'Oranges' 'Oranges' 'Oranges' 'viridis' 'viridis' 'viridis' 'viridis' 'viridis' 'viridis' --zMin -2 -2 -2 -2 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 --zMax 2 2 2 2 100 100 50 50 30 30 10 10 10 10 10 10 --whatToShow 'heatmap and colorbar'

# plotProfile -m deeptools/matrix_DEG_suvhs13.gz -out plots/profile_DEG_suvhs13_v1.pdf --averageType median --yMin -2.5 -2.5 -2.5 -2.5 0 0 0 0 0 0 0 0 0 0 0 0 --yMax 2.5 2.5 2.5 2.5 100 100 80 80 25 25 2 2 2 2 2 2 --numPlotsPerRow 4
# plotProfile -m deeptools/matrix_DEG_suvhs13.gz -out plots/profile_DEG_suvhs13_v2.pdf --averageType mean --yMin -2.5 -2.5 -2.5 -2.5 0 0 0 0 0 0 0 0 0 0 0 0 --yMax 2.5 2.5 2.5 2.5 100 100 50 50 30 30 10 20 20 20 20 20 --numPlotsPerRow 4

# plotProfile -m deeptools/matrix_DEG_suvhs.gz -out plots/profile_DEG_suvhs_v1.pdf --averageType median --yMin -2.5 -2.5 -2.5 -2.5 0 0 0 0 0 0 0 0 0 0 0 0 --yMax 2.5 2.5 2.5 2.5 100 100 80 80 25 25 2 2 2 2 2 2 --numPlotsPerRow 4
# plotProfile -m deeptools/matrix_DEG_suvhs.gz -out plots/profile_DEG_suvhs_v2.pdf --averageType mean --yMin -2.5 -2.5 -2.5 -2.5 0 0 0 0 0 0 0 0 0 0 0 0 --yMax 2.5 2.5 2.5 2.5 100 100 50 50 30 30 10 20 20 20 20 20 --numPlotsPerRow 4

## To get the distance between the DEG and peaks
## ChIP samples: ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH1_rep1 ChIP7_SUVH1_rep2
## RNA samples: SUVH1_SUVH3 suvh1_3 mbd1_2_4 mbd2_5_6 mbd1_2_5_6 MBD5_MBD6

# for sample in ChIP3_MBD1 ChIP6_MBD1 ChIP6_MBD2_rep1 ChIP6_MBD2_rep2 ChIP8_MBD4_rep2 ChIP11_MBD4 ChIP7_MBD5_rep1 ChIP7_MBD5_rep2 ChIP3_MBD6 ChIP7_MBD6 ChIP2_SUVH1 ChIP11_SUVH1 ChIP7_SUVH3_rep1 ChIP7_SUVH3_rep2
# do
	# echo "$sample"
	# awk -v OFS="\t" '{print $2,$3,$4,$1}' tables/complete_${sample}.txt > annotations/${sample}_summits.bed
	# bedtools closest -a annotations/all_genes.bed -b annotations/${sample}_summits.bed -D a | awk -v OFS="\t" -v s=$sample '{print s,$11,$4}' | awk -F"=" -v OFS="\t" '{print $1,$4}' | awk -v OFS="\t" '{print $1,$2,$4}' > tables/temp1_distance_${sample}.txt 
	# bedtools closest -a annotations/${sample}_summits.bed -b annotations/all_genes.bed -D a | awk -v OFS="\t" -v s=$sample '{print s,$11,$4}' | awk -F"=" -v OFS="\t" '{print $1,$4}' | awk -v OFS="\t" '{print $1,$2,$4}' > tables/temp2_distance_${sample}.txt
# done

# cat tables/temp1_distance_*.txt > tables/distance_genes_peaks.txt
# cat tables/temp2_distance_*.txt > tables/distance_peaks_genes.txt


			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=mbd1_2_5_6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
		# elif [[ $sample == *"MBD2"* ]] 
		# then 
			# mut=mbd1_2_4
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=mbd2_5_6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=mbd1_2_5_6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
		# elif [[ $sample == *"MBD4"* ]]
		# then 
			# mut=mbd1_2_4
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
		# elif [[ $sample == *"MBD5"* ]]
		# then 
			# mut=MBD5_MBD6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=mbd2_5_6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=mbd1_2_5_6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
		# elif [[ $sample == *"MBD6"* ]]
		# then 
			# mut=MBD5_MBD6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=mbd2_5_6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=mbd1_2_5_6
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
		# elif [[ $sample == *"SUVH"* ]]
		# then 
			# mut=SUVH1_SUVH3
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
			# mut=suvh1_3
			# echo "MBD1 sample $sample RNA $mut $dir"
			# bedtools closest -a rna/DEG_stranded/DEG_${mut}_${dir}.bed -b tables/start_${sample}.bed -D a | awk -v OFS="\t" -v s=$sample -v d=$dir -v m=$mut '{print m,s,d,$16,$4}' | sort -k5,5 > tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt
			# sed 's/"//g' rna/DEG_stranded/DEG_${mut}.txt | sort -k5,5 | join -1 5 -2 5 tables/temp1_distance_deg_${dir}_${sample}_${mut}.txt - | awk -v OFS="\t" '{print $1,$2,$3,$6,$5,$10}' | uniq > tables/temp2_distance_deg_${dir}_${sample}_${mut}.txt
		# else
			# echo "OOOPSI!"
		# fi
	# done
# done

# cat tables/temp2_distance_deg_* > tables/total_distance_deg_peaks_matrix.txt
# rm tables/temp*




















