use strict;
use Bio::Align::DNAStatistics;
use Bio::SeqIO::fasta;
#use Data::Dumper;
#print(Dumper $Bio::Align::DNAStatistics::synsites);

my $in=Bio::SeqIO::fasta->new(-file => @ARGV);
while (my $seq=$in->next_seq){
  my $name=$seq->id;
  $seq=$seq->seq;
  my $length=length($seq);
  $seq=substr($seq,0,$length-($length % 3));
  my $syn=Bio::Align::DNAStatistics::count_syn_sites($seq,$Bio::Align::DNAStatistics::synsites);
  my $non_syn=$length-$syn;
  print("$name\t$syn\t$non_syn\t$length\n")
}