library(tidyverse)
# next section not used
load("/net/waterston/vol9/ChipSeqPipeline/young.adult.cell.classes.RData")
df  <- tibble(cell=YA_cil,tissue="Ciliated_neurons")
df <- bind_rows(df,tibble(cell=YA_emb,tissue="Embryonic"))
df <- bind_rows(df,tibble(cell=YA_germ,tissue="Germline"))
df <- bind_rows(df,tibble(cell=YA_glia_exc,tissue="Glia_and_excretory_cells"))
df <- bind_rows(df,tibble(cell=YA_hyp,tissue="Hypodermis_and_seam_cells"))
df <- bind_rows(df,tibble(cell=YA_int,tissue="Intestine"))
df <- bind_rows(df,tibble(cell=YA_mm,tissue="Muscle_and_mesoderm"))
df <- bind_rows(df,tibble(cell=YA_noncil,tissue="Non-ciliated_neurons"))
df <- bind_rows(df,tibble(cell=YA_pha,tissue="Pharynx"))
chau <- mutate(df,subtissue=tissue)


# get the adult expression matrix and correct the cell types to computer friendly
YA <-  select(read_csv("/net/waterston/vol6/files_for_lou/YA.prcnt_tpm_bootstrap_v2.csv"),
              wbgene=gene_ID,Abbas=cell_type,gene=gene_short_name,TPM=bootstrap_median_scaled_TPM)

YA_table <- read_tsv(file="/net/waterston/vol9/ChipSeqPipeline/YA_cell_names.txt") %>% 
  select(Abbas,Chau,CellType,Tissue)
YA_table <- replace_na(YA_table,list(Tissue="Germline"))
YA <- left_join(YA,YA_table) %>% select(-Abbas,-Chau,-Tissue)
write_csv(YA,file="/net/waterston/vol6/files_for_lou/YA.prcnt_tpm_bootstrap_v2_corrected.csv")

YA_table <- mutate(YA_table,Tissue=str_replace_all(Tissue," ","_")) 
YA_table <- mutate(YA_table,SubTissue=Tissue) %>% select(-Abbas,-Chau)
write_csv(YA_table,file="/net/waterston/vol6/Adult.cell.types.csv",col_names = FALSE)



