library(tidyverse)
library(ggplot2)

stages <-c("emb","larva","adult","lineage")
for (stage in stages){
  entropyfile = str_c("/net/waterston/vol9/ChipSeqPipeline/Entropy/worm_",stage,"_Entropy.tsv",sep="")
  entropypdf = str_c("/net/waterston/vol9/ChipSeqPipeline/Entropy/worm_",stage,"_Entropy.pdf",sep="")
  entropyDF <- read_tsv(entropyfile, col_names = FALSE)
  entropyDF <- rename(entropyDF,HotTarget=X3,Entropy=X2)
  ggplot(filter(entropyDF,Entropy>0) ) + geom_histogram(aes(x=Entropy,color=HotTarget),bins = 100) + 
    labs(y="Number of target genes",title=stage)
  ggsave(filename = entropypdf)  
}


ggplot(filter(entropyDF,X2>0,X3=="-") )+ geom_histogram(aes(x=X2), bins = 100)

ggplot(filter(entropyDF,X2>0,X3=="+") ) + geom_histogram(aes(x=X2), bins = 100)


ggplot(filter(entropyDF,X2>0) )+ geom_histogram(aes(x=X2), bins = 100)

ggplot(filter(entropyDF,X2>0) )+ geom_freqpoly(aes(x=X2))
ggplot(filter(entropyDF,X2>0,X3=="+") ) + geom_freqpoly(aes(x=X2))

ggplot(filter(entropyDF,X2>0) ) +  geom_density(aes(x=X2))
ggplot(filter(entropyDF,X2>0,X3=="-") )+ geom_density(aes(x=X2))
ggplot(filter(entropyDF,X2>0,X3=="+") ) + geom_density(aes(x=X2))

ggplot(filter(entropyDF,X2>0) ) + geom_histogram(aes(x=X2,color=X3),bins = 100)
ggplot(filter(entropyDF,X2>0) ) + geom_histogram(aes(x=X2),bins = 100)

