library(tidyverse)
library(ggplot2)
library(hrbrthemes)
library(plotly)
library(heatmaply)
library(d3heatmap)
library(htmlwidgets)
library(RColorBrewer)
library(pheatmap)

strCat <- function(v){
  r <- v[1]
  if (length(v)>1){
    for (i in 2:length(v)){
      r <- str_c(r,v[i],sep=" : ")
    } 
  }
  return(r)
}
# mToS <- read_tsv(file="/net/waterston/vol9/Classify/MurrayToSulston")
# mToS <- mutate(mToS,Murray=str_replace_all(Murray,"/","_"))

mToS <- read_tsv(file="/net/waterston/vol9/ChipSeqPipeline/MurrayToCellClass.tsv",col_names=FALSE)
mToS <- dplyr::rename(mToS,Murray=X1,Sulston=X2,Terminal=X3,CellType=X4,CellClass=X5)
mToS <- mutate(mToS,Murray=str_replace_all(Murray,"/","_"))
mToC <- select(mToS,Sulston,CellClass)

cellClasses <- read_tsv(file="/net/waterston/vol9/ChipSeqPipeline/LineageCellClasses.csv",col_names=FALSE)
cellClasses <- dplyr::rename(cellClasses,Label=X1,CellClass=X2)

j <- left_join(mToS,cellClasses,by="CellClass")
nrow(dplyr::distinct(j,Sulston,Terminal))
nrow(dplyr::distinct(j,Terminal,CellType))

write_tsv(left_join(mToS,cellClasses,by="CellClass"),
          file="/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/MurraySulstonTerminalCellClass.tsv")
write_tsv(pivot_wider(left_join(mToS,cellClasses,by="CellClass"),names_from = Label,values_from = "Label"),
          file="/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/MurraySulstonCellClass.tsv")

mToC <- left_join(mToC,cellClasses,by="CellClass") %>% distinct(Sulston,Label)
s <- filter(mToC,Label!="CellDeath") 
s <- dplyr::group_by(s,Sulston) %>% summarise(n=n(),cells=strCat(Label))
mToC <- filter(mToC,!is.na(Label))

mToC <- pivot_wider(mToC,names_from = Label,values_from = "Label")
write_tsv(mToC,file="/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/SulstonCellClass.tsv")
names <- mToC$Sulston
mToC <- select(mToC,-Sulston)
mToC <- as.data.frame(mToC)
rownames(mToC) <- names

stage <- "lineage"
#modelLabel <-
#  str_c(stage,"expressing5pct/noHotClusterTargets/distanceModified/closeAlternates",sep="/")
#resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_Results_2",modelLabel,sep="/")

modelLabel <-
    str_c(stage,"expressing_5pct/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
  resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_4_Results",modelLabel,sep="/") 

vimpFile <- "Cell_TF_Vimp_Matrix"
matFile <- str_c(str_c(resultDir,vimpFile,sep="/"),".tsv",sep="")
r <- read_tsv(file=matFile) %>% rename(Murray=CellType)
r <- left_join(r,dplyr::distinct(mToS,Murray,Sulston), by="Murray")
r <- dplyr::distinct(r,Sulston,.keep_all=TRUE) %>% select(-Murray) %>% mutate(CellType=Sulston,.before=1) %>% 
  select(-Sulston)

# compute log(vimp) , all vimps less than one go to zero log, NaN go to NA
r <- pivot_longer(r,cols = 2:ncol(r),names_to = "TF",values_to = "Vimp") %>%
  mutate(Vimp = if_else(Vimp<=1,1.0,Vimp)) %>%
  mutate(logVimp = log(Vimp))

g <- group_by(r,CellType) %>% 
  summarise(maxVimp = max(Vimp,na.rm=TRUE),maxLogVimp = max(logVimp,na.rm=TRUE))
r <- left_join(r,g,by="CellType")

r <- mutate(r,Heat=if_else(is.na(Vimp),-1.0,logVimp/maxLogVimp)) %>%
  select(CellType,TF,Heat)

# nrow(dplyr::distinct(r,CellType))



# entire heatmap static and interactive
m <- pivot_wider(r,names_from=TF,values_from = Heat)
write_tsv(m,file="/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/lineageSulston.tsv")
names <- m$CellType
mat <- as.matrix(m[,2:ncol(m)])
rownames(mat) <- names
write_tsv(select(m,CellType),file="/net/waterston/vol9/ChipSeqPipeline/MurrayLabels",col_names = FALSE)  

# static heatmap
ramp = colorRampPalette(c("Lightblue","Lightyellow","Red"))(100)
colScheme <- "LightBlue"
staticFile <- str_c("/net/waterston/vol9/ChipSeqPipeline/",stage,colScheme,"sulston.pdf",sep="")
#dev.off()
ph <- pheatmap(mat, cellwidth = 10, cellheight = 10 ,color = ramp,
               treeheight_row=0,treeheight_col=0,annotation_row = mToC,annotation_legend = TRUE,annotation_names_row=TRUE,
               filename=staticFile)

#colorRampPalette((brewer.pal(n = 7, name ="RdYlBu")))(100)

#mat <-t(mat)
#staticFile <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,"sulston.pdf",sep="")
#dev.off()
#ph <- pheatmap(mat, cellwidth = 10, cellheight = 10 ,color = ramp,
#               treeheight_row=0,treeheight_col=0,annotation_col = mToC,annotation_legend = TRUE,annotation_names_col=TRUE,
#               filename=staticFile)

# reorder the matrix
mm <- matrix(0,nrow=nrow(mat),ncol=ncol(mat))
rNames <- vector(mode="character",length=nrow(mat))
cNames <- vector(mode="character",length=ncol(mat))
for (rm in 1:nrow(mat)){
  rr <- ph$tree_row$order[rm]
  rNames[rm] <- row.names(mat)[rr]
  for (cm in 1:ncol(mat)){
    cc <- ph$tree_col$order[cm]  
    mm[rm,cm] <- mat[rr,cc]
  }  
}
for (cm in 1:ncol(mat)){
  cc <- ph$tree_col$order[cm]  
  cNames[cm] <- colnames(mat)[cc]
}
row.names(mm) <- rNames
colnames(mm) <- cNames
cellNote <- matrix("a",nrow=nrow(mm),ncol=ncol(mm))
row.names(cellNote) <- rNames
colnames(cellNote) <- cNames
for (rm in 1:nrow(mm)){
  l <- filter(s,Sulston==row.names(mm)[rm])$cells[1]
  for (cm in 1:ncol(mm)){
    cellNote[rm,cm] <- str_c(l,format(x=mm[rm,cm],digits=3),sep=":")
  }
}
d3 <- d3heatmap(mm,width=20*length(cNames),height=20*length(rNames),cexCol=1,cexRow=1.0,anim_duration = 0,xlab="TF",ylab="Cell",
                cellnote = cellNote)
d3 <- hmAxis(d3,axis="y",size=500)
d3 <- hmAxis(d3,axis="x",angle=90,labels=cNames)
d3 <- hmDendrogram(d3,dendrogram="none")
d3 <- hmColors(d3,colors=ramp,color.bins = 100)
#saveWidget(d3,file=str_c("/net/waterston/vol2/home/gevirl/",stage,"CelltypeTFheatmap.html",sep=""))
saveWidget(d3,file= str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,colScheme,"sulston.html",sep=""),
           selfcontained = TRUE,title=stage)
# save the matrix
write_tsv(as.data.frame(mat) %>% mutate(Sulston=names,.before=1),
          file= str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,".tsv",sep=""))
# save the color ramp
write_tsv(tibble(color = colorRampPalette(c("LightBlue","Lightyellow","Red"))(100)),
          file="/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/colorRamp")

colorRampPalette(c("Blue","Lightyellow","Firebrick"))(100)
