library("tidyverse")

tf <- read_tsv(file="/net/waterston/vol9/ChipSeqPipeline/AllWormPeaks.TF.tsv", col_names = TRUE)

species <- "Worm"

species <- "Fly"

item <- "ranked"
rankedPrefix <- str_c("/net/waterston/vol9/ChipSeqPipeline/All",species,"Peaks.TF.noDups.",item,sep="")

item <-"clusters"
metaPrefix <- str_c("/net/waterston/vol9/ChipSeqPipeline/All",species,"Peaks.TF.noDups.",item,sep="")

rankedPrimary <- read_tsv(file=str_c(rankedPrefix,".distance.tsv",sep=""), col_names = TRUE)  %>% dplyr::mutate(peakApex=chromStart+peak) %>% 
  mutate(peakID=str_c(chrom,chromStart,chromEnd,experiment,sep="_"),.before =5 ) %>%
  select(-strand,-peak) %>% dplyr::rename(targetDist = distance)

rankedAlt <- read_tsv(file=str_c(rankedPrefix,".altdist.tsv",sep=""), col_names = TRUE)  %>% dplyr::mutate(peakApex=chromStart+peak) %>% 
  mutate(peakID=str_c(chrom,chromStart,chromEnd,experiment,sep="_"),.before =5 ) %>%
  select(-strand,-peak) %>% dplyr::rename(targetDist = distance)

rankedTargets <- read_tsv(file=str_c(rankedPrefix,".target.tsv",sep=""), col_names = TRUE)


meta <- read_tsv(file=str_c(metaPrefix,".tsv",sep=""), col_names = TRUE) %>% mutate(metaPeakApex=(thickStart+thickEnd)/2) %>%
  select(-strand,-itemRgb,-thickStart,-thickEnd) %>% dplyr::rename(metaPeakStart=chromStart,metaPeakEnd=chromEnd)

metaPrimary <- read_tsv(file=str_c(metaPrefix,".distance.tsv",sep=""), col_names = TRUE)  %>% dplyr::mutate(meatPeakApex=(thickStart+thickEnd)/2) %>% 
  select(-strand,-thickStart,-thickEnd,-itemRgb) %>% dplyr::rename(targetDist = distance)

metaAlt <- read_tsv(file=str_c(metaPrefix,".altdist.tsv",sep=""), col_names = TRUE)  %>% dplyr::mutate(meatPeakApex=(thickStart+thickEnd)/2) %>% 
  select(-strand,-thickStart,-thickEnd,-itemRgb) %>% dplyr::rename(targetDist = distance)

metaTargets <- read_tsv(file=str_c(metaPrefix,".target.tsv",sep=""), col_names = TRUE)


primeJoin <- left_join(rankedPrimary,meta,by=c("chrom","metaPeak")) %>% left_join(rankedTargets,by=c("target"="TargetID"))
write_tsv(primeJoin,file=str_c(rankedPrefix,".primary.tsv",sep=""),col_names = TRUE)

altJoin <- left_join(rankedAlt,meta,by=c("chrom","metaPeak")) %>% left_join(rankedTargets,by=c("target"="TargetID"))
write_tsv(altJoin,file=str_c(rankedPrefix,".alternate.tsv",sep=""),col_names = TRUE)



write_tsv( left_join(metaPrimary,metaTargets,by=c("target"="TargetID")),file=str_c(metaPrefix,".primary.tsv",sep=""),col_names = TRUE)

write_tsv( left_join(metaAlt,metaTargets,by=c("target"="TargetID")),file=str_c(metaPrefix,".alternate.tsv",sep=""),col_names = TRUE)

