
library(tidyverse)
library(ggplot2)
library(hrbrthemes)
library(plotly)
library(heatmaply)
library(d3heatmap)
library(htmlwidgets)
library(RColorBrewer)
library(pheatmap)

#stages <- c("emb","larva","adult")
#runLabel <- "meansd"

#runLabel <- "MeanSd"
#runLabel <- "test1"
#stages <- c("flyemb2")
#stages <-c("adult")

#stage <- "adult"
stage <- "flyemb5"
#stage <- "emb"

#stages <- c("larva1","larva2","larva3","larva4","larva3Hypo","larva3Seam","larva4Sperm")
stages <- c("flyemb5")
for (stage in stages){

  runLabel <- "WithMotif"
  modelLabel <-  
    str_c(stage,"ExprTF_MeanSd_1.0/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
  resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_flyMotif_Results",modelLabel,sep="/")   

  
  vimpFile <- "Cell_TF_Vimp_Matrix"
  matFile <- str_c(str_c(resultDir,vimpFile,sep="/"),".tsv",sep="")
  r <- read_tsv(file=matFile)
  
  r <- pivot_longer(r,cols = 2:ncol(r),names_to = "TF",values_to = "Vimp")
  r <- mutate(r,Vimp = if_else(Vimp<=1,1.0,Vimp))
  r <- mutate(r,logVimp = log(Vimp))
  g <- group_by(r,CellType) %>% 
    summarise(maxVimp = max(Vimp,na.rm=TRUE),maxLogVimp = max(logVimp,na.rm=TRUE))
  r <- left_join(r,g,by="CellType")
  
  m <- mutate(r,Heat=if_else(is.na(Vimp),-1.0,if_else(maxLogVimp>0,logVimp/maxLogVimp,0))) %>%
    select(CellType,TF,Heat)
  
  mat <- pivot_wider(m,names_from=TF,values_from = Heat)
  write_tsv(mat,file= str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,runLabel,".tsv",sep=""))
  names <- mat$CellType
  mat <- as.matrix(mat[,2:ncol(mat)])
  rownames(mat) <- names 
  
  # static heatmap\
  #mat <- t(mat)
  staticFile <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,runLabel,".pdf",sep="")
  ph <- pheatmap(mat, cellwidth = 10, cellheight = 10 ,color = colorRampPalette(c("Lightblue","Lightyellow","Red"))(100),
                 treeheight_row=0,treeheight_col=0,filename=staticFile)
                 
#  staticFile <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,runLabel,".pdf",sep="")
#  ph <- pheatmap(mat, cellwidth = 10, cellheight = 10 ,color = colorRampPalette(c("Blue3","Lightyellow","Red"))(100),
 #                treeheight_row=0,treeheight_col=0,filename=staticFile)
  
  # reorder the matrix
  mm <- matrix(0,nrow=nrow(mat),ncol=ncol(mat))
  rNames <- vector(mode="character",length=nrow(mat))
  cNames <- vector(mode="character",length=ncol(mat))
  for (r in 1:nrow(mat)){
    rr <- ph$tree_row$order[r]
    rNames[r] <- row.names(mat)[rr]
    for (c in 1:ncol(mat)){
      cc <- ph$tree_col$order[c]  
      mm[r,c] <- mat[rr,cc]
    }  
  }
  for (c in 1:ncol(mat)){
    cc <- ph$tree_col$order[c]  
    cNames[c] <- colnames(mat)[cc]
  }
  row.names(mm) <- rNames
  colnames(mm) <- cNames
  
  # interactive headtmap
  d3 <- d3heatmap(mm,width=25*length(cNames),height=20*length(rNames),cexCol=1,cexRow=1.0,anim_duration = 0,xlab="TF",ylab="Cell",
                  key=TRUE,key.location="tr") %>%
  hmAxis(axis="y",size=1500)  %>% hmAxis(axis="x",angle=90,size=100) %>% hmDendrogram(dendrogram = "none") %>%
  hmColors(colors=colorRampPalette(c("Lightblue","Lightyellow","Red"))(11),color.bins = 100)
  saveWidget(d3,file= str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,runLabel,".html",sep=""),
             title=stage)
}

#  hmAxis(axis="x",angle=90,labels = cNames) 



#  d3 <- heatmaply(mat,width=7000,height=2000,cexCol=1,cexRow=1.0,anim_duration = 0,xlab="TF",ylab="Cell")
#  d3 <- d3heatmap(mm,width=3000,height=2000,cexCol=1,cexRow=1.0,anim_duration = 0,xlab="TF",ylab="Cell")
#  d3 <- hmAxis(d3,axis="y",size=300)
#  modelLabel <-
#    str_c(stage,"MeanExprTF100/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
#  resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly4_Results",modelLabel,sep="/")

#  modelLabel <-
#    str_c(stage,"ExprTF_MeanSd_1.0/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
#  resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly4_Results",modelLabel,sep="/")  

modelLabel <-  
  str_c(stage,"ExprTF_MeanSd_1.0/noHotClusterTargetsNoAlt84max/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly5_Results",modelLabel,sep="/") 

modelLabel <-
  str_c(stage,"expressing_5pct/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_4_Results",modelLabel,sep="/")  

runLabel <- "MeanSD_84_LTBlue"
modelLabel <-  
  str_c(stage,"ExprTF_MeanSd_1.0/noHotClusterTargetsNoAlt84max/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly5_Results",modelLabel,sep="/") 

runLabel <- "MeanSD_277_LtBlue"
modelLabel <-  
  str_c(stage,"ExprTF_MeanSd_1.0/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly5_Results",modelLabel,sep="/") 

runLabel <- "Mean_84_LtBlue"
modelLabel <-  
  str_c(stage,"ExprTF_Mean/noHotClusterTargetsNoAlt84max/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly5_Results",modelLabel,sep="/") 

runLabel <- "Mean_277_LtBlue"
modelLabel <-  
  str_c(stage,"ExprTF_Mean/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly5_Results",modelLabel,sep="/") 


runLabel <- "test1"
modelLabel <-
  str_c(stage,"expressing5pct/noHotClusterTargets/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_Results",modelLabel,sep="/")   

runLabel <- "test2"
modelLabel <-
  str_c(stage,"expressing5pct/noHotClusterTargets/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_Results_Save",modelLabel,sep="/") 

runLabel <- "test3"
modelLabel <-
  str_c(stage,"expressing5pct/noHotClusterTargets/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_Results_2",modelLabel,sep="/")  

runLabel <- "test4"
modelLabel <-
  str_c(stage,"expressing5pct/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_3_Results",modelLabel,sep="/")




modelLabel <-
  str_c(stage,"expressing_10pct/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly4_Results",modelLabel,sep="/")

modelLabel <-
  str_c(stage,"MeanExprTF100/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly4_Results",modelLabel,sep="/")

modelLabel <-
  str_c(stage,"ExprTF_MeanSd_1.0/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly4_Results",modelLabel,sep="/")  

modelLabel <-
  str_c(stage,"ExprTF_MeanSd_1.0/noHotClusterTargetsNoAlt/distanceModified/closeAlternates",sep="/")
resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_fly5_Results",modelLabel,sep="/")    

#  modelLabel <- str_c(stage,"expressing_5pct/Entropy_4.000000/distanceModified/closeAlternates",sep="/")
#  resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_4_Results",modelLabel,sep="/")

#  modelLabel <- str_c(stage,"expressing_5pct/EntropyNotHot_4.000000/distanceModified/closeAlternates",sep="/")
#  resultDir <- str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_4_Results",modelLabel,sep="/")















tmm <- t(mm)
d3 <- d3heatmap(t(mm),height=15*length(cNames),width=20*length(rNames),cexCol=1,cexRow=1.0,anim_duration = 0,ylab="TF",xlab="Cell",dendrogram="none") %>%
  
  hmAxis(axis="y",size=300) %>% hmAxis(axis="x",angle=90,size=300) 

saveWidget(d3,file= str_c("/net/waterston/vol9/ChipSeqPipeline/RF_Model_heatmaps/",stage,runLabel,".html",sep=""),
           selfcontained = TRUE,title=stage)




#d3 <- hmDendrogram(d3,dendrogram="none")



pheatmap(mat, cellwidth = 10, cellheight = 10 ,color = colorRampPalette((brewer.pal(n = 7, name ="RdYlBu")))(100),
         treeheight_row=0,treeheight=0,
         file="~/line.pdf")

p <- ggplot(m, aes(TF, CellType, fill= Heat)) + 
  geom_tile() + theme(axis.text.x = element_text(angle=-45))
ggplotly(p)


heatmaply(mat)




theme_ipsum()

# Dummy data
x <- LETTERS[1:20]
y <- paste0("var", seq(1,20))
data <- expand.grid(X=x, Y=y)
data$Z <- runif(400, 0, 5)

# new column: text for tooltip:
data <- data %>%
  mutate(text = paste0("x: ", x, "\n", "y: ", y, "\n", "Value: ",round(Z,2), "\n", "What else?"))

# classic ggplot, with text in aes
p <- ggplot(data, aes(X, Y, fill= Z, text=text)) + 
  geom_tile() + theme(axis.text.x = element_text(angle=-45))
  theme_ipsum()

ggplotly(p, tooltip="text")