library("tidyverse")
library("monocle3")

cellType <- "Epicuticle"
args <- commandArgs(trailingOnly = TRUE)
cellType <- args[1]

tsvFile <- str_c("/net/waterston/vol9/ChipSeqPipeline/BootstrapTPM/",cellType,".tsv",sep="")
cds <-  readRDS(file="/net/waterston/vol6/files_for_lou/cds_fly_pca300_vers3.final.annotation.rds")
allCells <- as.data.frame(colData(cds) ) %>% mutate(cell.type.3=if_else(is.na(cell.type.3),"NotAssigned",cell.type.3)) %>%
  mutate(cell.type.3=str_replace_all(cell.type.3," ","_"))
expMat <- t(exprs(cds))
cds <- 1

cells <- filter(allCells,cell.type.3==cellType)
allCells <- 1
l <- list()
i <- 1
for (i in 1:1000){
  sampleCells <- sample(cells$cell,replace=TRUE)
  
  exp <- as.data.frame(as.matrix(expMat[sampleCells,]) )  # cells x genes
  
  exp <-  pivot_longer(exp,cols=1:ncol(exp),names_to = "gene",values_to = "count")
  
  g <- dplyr::group_by(exp,gene) %>% dplyr::summarise(countSum=sum(count))
  total <- sum(g$countSum)
  g <- mutate(g,tpm=1000000.0*countSum/total) %>% select(-countSum) 
  g <- pivot_wider(g,names_from = "gene",values_from = "tpm")
  l[[i]] <- g
}
ll <- bind_rows(l)
ll <- pivot_longer(ll,cols=1:ncol(ll),values_to = "TPM", names_to = "gene")
ll <- dplyr::group_by(ll,gene) %>% dplyr::summarise(bootstrapTPM=median(TPM))
write_tsv(ll,file=tsvFile,col_names =TRUE)


gl <- list()
for (i in 1:10){
  sampleCells <- sample(cells$cell,replace=TRUE)
  
  exp <- as.data.frame(as.matrix(expMat[sampleCells,]) )  # cells x genes
  
  exp <-  pivot_longer(exp,cols=1:ncol(exp),names_to = "gene",values_to = "count")
  
  g <- dplyr::group_by(exp,gene) %>% dplyr::summarise(countSum=sum(count))
  genes <- g$gene
  g <- select(g,-gene)
  gl[[i]] <- g
}
df <- bind_cols(gl)























t <- readRDS("/net/waterston/vol6/files_for_lou/fly_exp_matrix_renamed_and_clean_with_83_cell_types.rds")
tCellTypes <- tibble(name=colnames(t)[2:84]) %>% mutate(source="RDS")

j <- full_join(cellTypes,tCellTypes,by=c("cell.type.3"="name"))
