library("tidyverse")
library("monocle3")

cds <-  readRDS(file="/net/waterston/vol6/files_for_lou/cds_fly_pca300_vers3.final.annotation.rds")
allCells <- as.data.frame(colData(cds) ) %>% mutate(cell.type.3=if_else(is.na(cell.type.3),"NotAssigned",cell.type.3)) %>%
  mutate(cell.type.3=str_replace_all(cell.type.3," ","_"))
cellTypes <- dplyr::distinct(allCells,cell.type.3) 

for (cellType in cellTypes$cell.type.3){
  lines <- c("source /net/waterston/vol6/activateConda.sh",
  "conda activate rstudio",
  "cd /net/waterston/vol9/ChipSeqPipeline/BootstrapTPM",
  str_c("Rscript BootstrapTPM.R",cellType,sep=" " ))
  write_lines(lines,file=str_c("/net/waterston/vol9/ChipSeqPipeline/BootstrapTPM/",cellType,".sge",sep=""))
}

l <- list()
for (i in 1:nrow(cellTypes)){
  l[i] <- str_c("qsub -l mfree=25G ",cellTypes$cell.type.3[i],".sge")  
}
write_lines(l,file="/net/waterston/vol9/ChipSeqPipeline/BootstrapTPM/submitAll.sh")



