library(RERconverge)

# Read in gene trees
mammalia.trees <- readTrees(file"path/to/genetrees.txt", minTreesAll = 60)

# Read in diet data
diet.data <- read.csv("carnivory_scores.csv")
diet.value.mammalia <- diet.data$carnivory_score
names(diet.value.mammalia) <- diet.data$species

# Estimate RERs
RER.mammalia <- getAllResiduals(mammalia.trees, transform = "sqrt", weighted = T, scale = T, min.sp=60)

#### BINARY TRAIT ANALYSIS ####
hypercarnivore.foreground = c("Antechinus_flavipes","Balaenoptera_edeni","Canis_lupus","Carlito_syrichta","Cryptoprocta_ferox",
				"Dasypus_novemcinctus","Desmodus_rotundus","Felis_catus","Lutra_lutra","Manis_javanica",
				"Megaderma_lyra","Microgale_talazaci","Molossus_molossus","Mustela_putorius","Noctilio_leporinus",
				"Onychomys_torridus","Pipistrellus_pipistrellus","Pteronotus_parnellii","Sarcophilus_harrisii",
				"Sorex_araneus","Suricata_suricatta","Tamandua_tetradactyla","Tonatia_saurophila","Tupaia_belangeri",
				"Tursiops_truncatus","Ursus_maritimus","Zalophus_californianus")
hypercarnivore.tree <- foreground2Tree(hypercarnivore.foreground, mammalia.trees, clade = "all", transition = "bidirectional")

#hyperherbivore.foreground = c("Bos_taurus","Catagonus_wagneri","Hippopotamus_amphibius","Ailuropoda_melanoleuca","Ailurus_fulgens",
				"Potos_flavus","Pteropus_rufus","Rousettus_madagascariensis","Sturnira_hondurensis",
				"Galeopterus_variegatus","Macropus_fuliginosus","Phalanger_gymnotis","Lepus_timidus",
				"Rhinoceros_unicornis","Choloepus_hoffmanni","Alouatta_palliata","Cheirogaleus_medius",
				"Eulemur_mongoz","Macaca_fuscata","Rhinopithecus_roxellana","Theropithecus_gelada","Elephas_maximus",
				"Microtus_ochrogaster","Muscardinus_avellanarius","Neotoma_lepida","Rhombomys_opimus","Sciurus_vulgaris")

# Correlate RERs with carnivory score
charpaths=tree2Paths(hypercarnivore.tree, mammalia.trees)

res=correlateWithBinaryPhenotype(RER.mammalia, charpaths, min.sp=60, min.pos=2, weighted="auto")

stats=getStat(res)

# Run permulations
phenvec <- diet.value.mammalia
phenvec <- ifelse(names(phenvec) %in% hypercarnivore.foreground,1,0)
names(phenvec) <- names(diet.value.mammalia)

perms = getPermsBinaryFudged(ntrees = 10000, fgdspecs = hypercarnivore.foreground, root=c("Monodelphis_domestica",
	"Sarcophilus_harrisii", "Antechinus_flavipes", "Phalanger_gymnotis", "Macropus_fuliginosus", "Gymnobelideus_leadbeateri"),
	RERs = RER.mammalia, trees = mammalia.trees, transition="bidirectional", useSpecies=mt$tip.label, phenvec=phenvec, cors=res)