## Introduction

Open Repository of Scripts and Resources for Nanopore (R1041 simplex/ R1041 duplex/ R941) and NGS Sequencing of Eight Bacteria.



## Quick links

### Scripts and pipeline

- The comparison of read quality is available [here](https://github.com/lrslab/Bacteria-Multisequencing/tree/main/code/read_quality).
- The comparison of assembly quality is available [here](https://github.com/lrslab/Bacteria-Multisequencing/tree/main/code/genome_assembly).
- The frequency stats of substitution type in assemblies are available [here](https://github.com/lrslab/Bacteria-Multisequencing/tree/main/code/mismatch_fre).
- The statistics of read numbers and proportions for correct and incorrect matches at error-prone sites are available [here](https://github.com/lrslab/Bacteria-Multisequencing/tree/main/code/modification_test).
- The identification of potential modification sites in the genome is available [here](https://github.com/lrslab/Hammerhead).
- The genome polishing script is available [here](https://hammerhead-documentation.readthedocs.io/en/latest/#assemblies-polish).



### Resource

- The published paper featuring the presented results can be accessed here.
- The raw data in *fastq* file is available [here](https://dataview.ncbi.nlm.nih.gov/object/PRJNA980403?reviewer=nm3jupm7mho19rrbhoborf8ec2) (Reviewer link).
- The high-quality genome references are here (NCBI processing).
- The assembled drafts are available are [here](https://figshare.com/s/32dd2eb0f16e31a1dd2f) for *Acinetobacter  pittii*.
- The assembled drafts are available are [here](https://figshare.com/s/804637fed3ad7f6d5a9c) for *Bacillus  cereus*.
- The assembled drafts are available are [here](https://figshare.com/s/f0c05b7de5340f7d61a3) for *Enterococcus  faecium*.
- The assembled drafts are available are [here](https://figshare.com/s/db4681817ea86477c67a) for *Escherichia  coli*.
- The assembled drafts are available are [here](https://figshare.com/s/168c1217d8c9c6c61ed0) for *Klebsiella pneumoniae*.
- The assembled drafts are available are [here](https://figshare.com/s/14e6f7004443ce8e5bf8) for *Pseudomonas  aeruginosa*.
- The assembled drafts are available are  [here](https://figshare.com/s/6a99c108b21fd0c74d3c) for *Salmonella  enterica*.
- The assembled drafts are available are [here](https://figshare.com/s/85a579eaa45fb4ddf20e) for *Staphylococcus  aureus*.



### Taxonomy

| Kingdom   |     Phylum     |        Class        |      Order       |       Family       |     Genes      |         Species          |
| -------- | :------------: | :-----------------: | :--------------: | :----------------: | :------------: | :----------------------: |
| Bacteria | Proteobacteria | Gammaproteobacteria | Pseudomonadales  |   Moraxellaceae    | Acinetobacter  |  *Acinetobacter pittii*  |
| Bacteria | Proteobacteria | Gammaproteobacteria | Enterobacterales | Enterobacteriaceae |  Escherichia   |    *Escherichia coli*    |
| Bacteria | Proteobacteria | Gammaproteobacteria | Enterobacterales | Enterobacteriaceae |   Klebsiella   | *Klebsiella pneumoniae*  |
| Bacteria | Proteobacteria | Gammaproteobacteria | Pseudomonadales  |  Pseudomonadaceae  |  Pseudomonas   | *Pseudomonas aeruginosa* |
| Bacteria | Proteobacteria | Gammaproteobacteria | Enterobacterales | Enterobacteriaceae |   Salmonella   |  *Salmonella enterica*   |
| Bacteria |   Firmicutes   |       Bacilli       |    Bacillales    |    Bacillaceae     |    Bacillus    |    *Bacillus  cereus*    |
| Bacteria |   Firmicutes   |       Bacilli       | Lactobacillales  |  Enterococcaceae   |  Enterococcus  |  *Enterococcus faecium*  |
| Bacteria |   Firmicutes   |       Bacilli       |    Bacillales    | Staphylococcaceae  | Staphylococcus | *Staphylococcus aureus*  |



