import sys
import numpy as np
import matplotlib.pyplot as plt
import numpy as np
import scipy as sp
import scipy.stats as stats
import matplotlib.image as mpimg

import matplotlib.patches as mplpatches
#import BME163_Plot_functions_Vollmers_Christopher as Plots

iYellow=(248/255,174/255,51/255)
iBlue=(88/255,85/255,120/255)
iPurple=(60/255,62/255,100/255)
iRed=(192/255,41/255,46/255)
iOrange=(230/255,87/255,43/255)
iYellow=(248/255,174/255,51/255)
iGreen=(81/255,116/255,95/255)

plasma5 = (237/255, 252/255, 27/255)
plasma4 = (245/255, 135/255, 48/255)
plasma3 = (190/255, 48/255, 101/255)
plasma2 = (87/255, 0/255, 151/255)
plasma1 = (15/255, 0/255, 118/255)

R1=np.linspace(plasma1[0],plasma2[0],26)
G1=np.linspace(plasma1[1],plasma2[1],26)
B1=np.linspace(plasma1[2],plasma2[2],26)

R2=np.linspace(plasma2[0],plasma3[0],26)
G2=np.linspace(plasma2[1],plasma3[1],26)
B2=np.linspace(plasma2[2],plasma3[2],26)

R3=np.linspace(plasma3[0],plasma4[0],26)
G3=np.linspace(plasma3[1],plasma4[1],26)
B3=np.linspace(plasma3[2],plasma4[2],26)

R4=np.linspace(plasma4[0],plasma5[0],26)
G4=np.linspace(plasma4[1],plasma5[1],26)
B4=np.linspace(plasma4[2],plasma5[2],26)

R=np.concatenate((R1[:-1],R2[:-1],R3[:-1],R4),axis=None)
G=np.concatenate((G1[:-1],G2[:-1],G3[:-1],G4),axis=None)
B=np.concatenate((B1[:-1],B2[:-1],B3[:-1],B4),axis=None)


plt.style.use('BME163')
figureWidth=8.8
figureHeight=8


fig_1 = plt.figure(figsize=(figureWidth,figureHeight))

panelWidth=2.2
panelHeight=2.2
panel1 = plt.axes([0.2/figureWidth , 0.2/figureHeight , panelWidth/figureWidth , panelHeight/figureHeight],frameon=False)
panel2 = plt.axes([2.8/figureWidth , 0.2/figureHeight , panelWidth/figureWidth , panelHeight/figureHeight],frameon=False)
panel4 = plt.axes([5.4/figureWidth , 0.2/figureHeight , panelWidth/figureWidth , panelHeight/figureHeight],frameon=False)
panel3 = plt.axes([7.8/figureWidth , 1.3/figureHeight , 0.1/figureWidth , 1/figureHeight],frameon=True)


tito=[]
tissues=['testis','brain','spinalCord','eye','stomach','smoothMuscle','heart','spleen','liver','kidney','lung','salivaryGland']
for tissue in tissues:
    for tool in['iso','mando']:
        tito.append(tissue+'_'+tool)
xpos=0
self=-1
for tissue in tito:

  others=range(0,24,1)
  self+=1
#  if 'Annot' in tool:
#      panel=panel1
#  else:
  panel=panel1
  all=0
  same=0
  different=[0]*24
  differentAll=[0]*24
  for line in open('all3.tracking'):
    a=line.strip().split('\t')[4:]
    if a[self]!='-':
        all+=1
        for index in others:
            if a[index]!='-':
                different[index]+=1
    for index in others:
        if a[index]!='-':
            differentAll[index]+=1

#  panel.plot([1-0.3,1+0.3],[same/all,same/all],color=color, lw =1)
  if self%2==0:
        panel=panel2
  else:
        panel=panel1

  for i in range(0,len(different),1):
    print(i,self,tissue,tito[i],different[i]/(all+differentAll[i]-different[i]))
    norm=min(100,int((different[i]/(all+differentAll[i]-different[i]))*200))
    color=(R[norm],G[norm],B[norm])
    ioffset=i%2
    soffset=self%2
    if i%2==self%2:

      if i>self:
        rectangle = mplpatches.Rectangle([self-soffset,24-(i-ioffset)],2,2,
                                 facecolor=color,
                                 edgecolor='black',
                                 linewidth=0.75
                                 )
        panel.add_patch(rectangle)

    if self%2==1:
        if i%2==0:
#          if self<=i+1:
            rectangle = mplpatches.Rectangle([self-soffset,24-(i-ioffset)],2,2,
                                 facecolor=color,
                                 edgecolor='black',
                                 linewidth=0.75
                                 )
            panel4.add_patch(rectangle)


for i in range(0,101,1):
    rectangle = mplpatches.Rectangle([0,i],1,1,
                                 facecolor=(R[i],G[i],B[i]),
                                 edgecolor='black',
                                 linewidth=0
                                 )
    panel3.add_patch(rectangle)


for panel in [panel1,panel2,panel4]:
    panel.set_xlim(-0.5,24.5)
    panel.set_ylim(-0.5,24.5)

panel.set_xlim(-0.5,26.5)
panel.set_ylim(-0.5,26.5)



#panel2.set_xlim(0,8)
#panel2.set_ylim(1,9)

panel3.set_xlim(0,1)
panel3.set_xticks([])
panel3.set_yticks([0.5,50.5,100.5],['0','0.25','≥0.5'])
panel3.tick_params(bottom=False, labelbottom=False,\
                   left=False, labelleft=False, \
                   right=True, labelright=True,\
                   top=False, labeltop=False)

panel3.set_ylim(0,101)

panel1.set_xticks([])
panel2.set_xticks([])
panel4.set_xticks([])

panel1.set_yticks([])
panel2.set_yticks([])
panel4.set_yticks([])

#panel1.set_yticks(np.arange(1.5,9,1))
#panel2.set_yticks(np.arange(1.5,5,1))

plt.savefig('overlap_atonce.png',dpi=600)


#print(len(mOnly),len(mShared),len(sShared),len(sOnly))
