import argparse

def get_args():
    
    parser = argparse.ArgumentParser(description='Figure creator for majiq transcripts comparison')
    
    ### Optinal arguments ###
    
    parser.add_argument('--gene-id', type=str, required=False,
                        help='process only this Gene Id for MAJIQ gene')
    parser.add_argument('--gene-id-lr', type=str, required=False,
                        help='Gene id to use for lr input file, if omitted, will use the majiq gene id')
    parser.add_argument('--gene-ids-file', type=str, required=False,
                        help='Path to a file to read a list of specific gene_ids from')
    parser.add_argument('-v', '--verbose', action='count', default=0)
    parser.add_argument('--fuzziness5', type=int, default=0,
                        help='Reduce 5 prime fuzziness of long-read sequencing')
    parser.add_argument('--fuzziness3', type=int, default=0,
                        help='Reduce 3 prime fuzziness of long-read sequencing')
    parser.add_argument('--debug', action='store_true',
                        help='Break and display full message on error')
    parser.add_argument('--debug-num-genes', type=int, default=0,
                        help='If specified, will only process this many genes')
    parser.add_argument('--max-paths', type=int, default=10000,
                        help='The maximum number of paths permissible per gene (or module in --per-module mode, '
                             'after which that gene/module will be skipped. set to 0 for no skipping')
    parser.add_argument('-j', '--threads', type=int, default=1,
                        help='If greater than 1, will use multiple processes')
    
    ### Required named arguments ###
    required_named = parser.add_argument_group('required named arguments')

    required_named.add_argument('--majiq-splicegraph-path', type=str, required=True,
                        help='path to MAJIQ splicegraph output file')
    required_named.add_argument('--lr-gtf-path', type=str, required=True,
                        help='path to lr output file')
    required_named.add_argument('--compare', action='store_true', required=True,
                        help='compare MAJIQ splicegraph and LR gtf file')
    required_named.add_argument('--output-path', type=str, required=True,
                        help='path to place output files in, will be created if it does not exist')

    args = parser.parse_args()

    return args