# DOTNB Distribution: the Difference Of Two Negative Binomial Distributions.
The DOTNB repository is a collection of code files that implement DOTNB across several programming languages. The DOTNB is the distribution for the Difference Of Two Negative Binomial distributions, i.e., Z=X-Y ~ DOTNB (λ_1,λ_2,p_1,p_2), where X ~ NB(λ_1,p_1 ) and Y ~ NB(λ_2,p_2 ). We aim for these code files to assist users in implementing DOTNB in their own models and methods.   

As a state-of-the-art application of DOTNB, we have introduced DEGage, a computational method for detecting differentially expressed genes (DEGs) in scRNA-seq data. We believe DOTNB has extensive applicability not only in comparative analysis of NGS data but also in other overdispersed count data in STEM fields.. 
https://github.com/chenyongrowan/DEGage.git

# Citation
If you use the code and/or the DOTNB distribution, please cite the following paper:

Petrany A., Chen R., Zhang S. and Chen, Y. "Theoretical framework for the difference of two negative binomial distributions and its application in comparative analysis of sequencing data". Genome Research, 2024. doi: 10.1101/gr.278843.124.
# Download
## Github
Run the following code in a terminal to retreive the DOTNB files, or download the file containing functions in your desired language.
  ```
  $ git clone https://github.com/chenyongrowan/DOTNB.git
  ```

# Requirements
Requirements differ between language. See the README files under each language for more details.


## Instructions

In the folder of each language, the calculation of Mean, Variance, Probability Density Function (PDF), Cumulative Density Function (CDF) of DOTNB are provided.


