% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multitest_functions.R
\name{run.multitest}
\alias{run.multitest}
\title{run.multitest}
\usage{
run.multitest(
  allcounts,
  group,
  perm.preprocess,
  gene.filter.threshold,
  nperms,
  nsubsample,
  perm.pval,
  ncores,
  maxiter,
  mean.ratio,
  subsampled.k,
  writing.dir
)
}
\arguments{
\item{allcounts}{the entire matrix of counts for all cells}

\item{group}{A factor which assigns conditions to cells as in Deseq2.}

\item{perm.preprocess}{A logical indicating whether or not to perform the permutation prefiltering step. Setting it to TRUE increases runtimes.}

\item{gene.filter.threshold}{A value between 0-1 which represents the maximum proportion of zeros a gene can have before being filtered out.}

\item{nperms}{An integer greater than 0 that indicates how many permutations will be carried out during the permutation test}

\item{nsubsample}{The number of cells to subsample for each condition}

\item{perm.pval}{P value for the permutation test to filter out genes with}

\item{ncores}{the number of cores to allocated for parallel computing}

\item{maxiter}{The maxiumum number of iterations to perform while calculating the cdf}

\item{mean.ratio}{The minimum ratio between the count means for each group for a gene with an incalculable p-value to be considered differentially expressed}

\item{subsampled.k}{If true the subsampling procedure is used to estimate k. If false, the random assignment procedure is used.}

\item{counts}{A dataframe with cells as columns and genes as rows.}
}
\value{
Nothing if a directory is provided.
}
\description{
calls DEGage for every comparison necessary in the DEGage_complete workflow
}
