% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_functions.R
\name{DEGage_preprocess}
\alias{DEGage_preprocess}
\title{DEGage_preprocess}
\usage{
DEGage_preprocess(
  counts,
  min.transcripts.per.gene = 200,
  max.transcripts.per.gene = 10000,
  min.transcripts.per.cell = 500,
  max.transcripts.per.cell = 20000,
  min.cells.per.gene = 3,
  max.dropout.prop = 0.8,
  max.mt.percent = 0.2,
  mt.prefix = "MT-",
  max.rRna.percent = 0.2,
  rRna.prefix = "rr"
)
}
\arguments{
\item{counts}{A dataframe of counts}

\item{min.transcripts.per.gene}{The minimum number of transcripts a gene can have}

\item{max.transcripts.per.gene}{The maximum number of transcripts a gene can have}

\item{min.transcripts.per.cell}{The the minimum number of transcripts required for a cell to be retained}

\item{max.transcripts.per.cell}{The maximum number of transcripts required for a cell to be retained}

\item{min.cells.per.gene}{The number of cells a gene must be present in to be retained}

\item{max.dropout.prop}{Removes genes with zero counts present in a number of cells greater than the specified proportion}

\item{max.mt.percent}{The maximum proportion of transcripts from mitochondrial genes that can be present in a cell}

\item{mt.prefix}{The prefix for mitochondrial genes}

\item{rRna.prefix}{the prefix for ribosomal genes}

\item{max.rRna.precent}{The maximum proportion of transcripts from ribosomal RNAs that can be present in a cell}
}
\value{
A dataframe of filtered counts
}
\description{
A simple preprocessing workflow to preprocess and generate SingleR cell type
annotations for scRNA-seq data.
}
