% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_functions.R
\name{DEGage_multitest}
\alias{DEGage_multitest}
\title{DEGage_multitest}
\usage{
DEGage_multitest(
  counts,
  group,
  perm.preprocess = TRUE,
  gene.filter.threshold = 0.9,
  nperms = 2000,
  nsubsample = NA,
  perm.pval = 0.1,
  ncores = 4,
  maxiter = 100,
  mean.ratio = 4,
  subsampled.k = T,
  writing.dir = NULL
)
}
\arguments{
\item{counts}{A dataframe with cells as columns and genes as rows.}

\item{group}{A factor which assigns conditions to cells as in Deseq2.}

\item{perm.preprocess}{A logical indicating whether or not to perform the permutation prefiltering step. Setting it to TRUE increases runtimes.}

\item{gene.filter.threshold}{A value between 0-1 which represents the maximum proportion of zeros a gene can have before being filtered out.}

\item{nperms}{An integer greater than 0 that indicates how many permutations will be carried out during the permutation test}

\item{nsubsample}{The number of cells to subsample for each condition}

\item{perm.pval}{P value for the permutation test to filter out genes with}

\item{ncores}{the number of cores to allocated for parallel computing}

\item{maxiter}{The maxiumum number of iterations to perform while calculating the cdf}

\item{mean.ratio}{The minimum ratio between the count means for each group for a gene with an incalculable p-value to be considered differentially expressed}

\item{subsampled.k}{If true the subsampling procedure is used to estimate k. If false, the random assignment procedure is used.}

\item{writing.dir}{A directory to write the results of each comparison to. It is HIGHLY reccomended to provide a directory.}
}
\value{
If a writing directory is not provided, a list of dataframes containing all comparisons is returned
}
\description{
Tests for differential expression across more than two conditions
}
