library("DEsingle")

# This file performs the comparative analysis for DESingle on real positive
# controls, negative controls, and simulated data

### Positive Controls real da

PositiveControl <-read.delim("Comparative Analysis/PositiveControl.csv", header = TRUE, sep = ",")
rownames(PositiveControl) <-PositiveControl[,1]
PositiveControl <- PositiveControl[,-1]
Goldstandard <-read.delim("Comparative Analysis/goldstandard_top1000DEGs.txt", header = TRUE, sep = "\n")
PositiveControl <- PositiveControl[-1:-8,-1:-6]
PositiveControl <- PositiveControl[substr(rownames(PositiveControl),1,2) != "r_",]
PositiveControl <- PositiveControl[,-93:-96]

#Positive Controls#########################################################################################

pcgroups <- factor(c(rep(1,48), rep(2,44)))
pc.starttime <- Sys.time()
pcDEGresults <- DEsingle(PositiveControl, pcgroups)
pc.endtime <- Sys.time()
pc.runtime <- pc.endtime - pc.starttime

pcresults.classified <- DEtype(pcDEGresults, threshold = 0.05)
pc.degs <- pcresults.classified[pcresults.classified$pvalue.adj.FDR <= 0.05,]

pcngenes <- nrow(pc.degs)
pc.deglist <- rownames(pc.degs)

Goldstandard <- unlist(Goldstandard)
commongenes <- c("Filler")
for(i in 1:length(pc.deglist)){
  if (pc.deglist[i] %in% Goldstandard ){
    commongenes <- c(commongenes, pc.deglist[i])
  }
}
commongenes <-commongenes[-1]

sensitivity <- length(commongenes)/1000

# Negative Controls############################################################################################
path <- "Comparative Analysis/Datasets/"
ncfiles <- list.files(path)
ncfiles <- ncfiles[grep("NC", ncfiles)]
ncdf <- data.frame()
for(i in 1:length(ncfiles)){
  groups <- c(rep(1,38), rep(2,38))
  nc.starttime <- Sys.time()
  ncDEGresults <- DEsingle(NegativeControl, factor(groups))
  nc.endtime <- Sys.time()
  nc.runtime <- nc.endtime - nc.starttime
  ncresults.classified <- DEtype(ncDEGresults, threshold = 0.05)

  ncngenes <- nrow(ncDEGresults[ncDEGresults$pvalue.adj.FDR <= 0.05,])
  fprate <- ncngenes/nrow(NegativeControl)
  specificity <- (nrow(NegativeControl)- ncngenes)/nrow(NegativeControl)

  ncngenes.classified <- nrow(ncresults.classified[ncresults.classified$pvalue.adj.FDR <= 0.05,])
  fprate.classified <- ncngenes.classified/nrow(NegativeControl)
  specificity.classified <- (nrow(NegativeControl)- ncngenes.classified)/nrow(NegativeControl)
  tempdf <- data.frame(spec = specificity.classified, fprate = fprate.classified, ndegs = ncngenes.classified)
  ncdf <- rbind(ncdf, tempdf)
}
write.csv(ncdf, "Comparative Analysis/ncresults/DEsingle.csv")

#Simulated Data###############################################################################################

path <- "Comparative Analysis/Datasets/"
files <- list.files(path)
files <- files[32:41]
finaldesingledf <- data.frame()
for (i in 1:length(files)){
  print(files[i])
  SD <- read.delim(paste(path,files[i], sep = ""), header = TRUE, sep = ",")
  rownames(SD) <- SD$X
  SD <- SD[,-1]

simgroups <- factor(c(rep(1,75), rep(2,75)))
sim.starttime <- Sys.time()
simresults <- DEsingle(SD, simgroups)
sim.endtime <- Sys.time()
sim.runtime <- sim.endtime -sim.starttime

simresults <- DEtype(simresults, threshold = 0.05)

expDEs <- simresults[is.na(simresults$pvalue.adj.FDR) == FALSE,]
expDEs <- rownames(expDEs[expDEs$pvalue.adj.FDR <= 0.05,])

trueDEs <- rownames(SD[1:2000,])
trueEEs <- rownames(SD[2001:20000,])

tp <- sum(trueDEs %in% expDEs)
fp <- sum(trueEEs %in% expDEs)
tn <- sum(!(trueEEs %in% expDEs))
fn <- sum(!(trueDEs %in% expDEs))

sim.sensitivity <- tp/(tp+fn)
sim.specificity <- tn/(tn+fp)
precision <- tp/(tp+fp)
accuracy <- (tp +tn)/20000
f1 <- (2*tp)/(2*tp+fp+fn)

simdf <- data.frame("Trial" = files[i], DEGs= length(expDEs), "Sensitivity" = sim.sensitivity, "Specificity" = sim.specificity, "Precision" = precision,
                    "Accuracy" = accuracy, "F1" = f1, "Runtime" = as.double(sim.runtime*60), "Returned" = nrow(simresults))

finaldesingledf <- rbind(finaldesingledf , simdf)
write.csv(finaldesingledf , "Comparative Analysis/EE_results/Desingle.csv")
}




