#This file generates imbalanced datasets
setwd("~/Documents/DEGage_stuff/DEGage_Testing/Comparative Analysis/imbalanced_resutls/")

library(DEGage)
group <-factor(c(rep(1,100), rep(2,100)))
lfcs <- runif(2000, min = 2, max = 5)
SD <- DEGage_Simulation(ngenes = 18000, 2000, lfc = lfcs, cellgroups = group, prop.zeros =0.6 )
write.csv(SD, "data/100v100.csv")

ncond1 <- c(100, 100, 100, 75,50, 25 )
ncond2 <- c(75, 50, 25, 75, 50, 25)

for(i in 1:length(ncond1)){
  tempcount1 <- SD[,1:100][,sample(1:100, ncond1[i])]
  tempcount2 <- SD[,101:200][,sample(1:100, ncond2[i])]
  fname <- paste("data/", ncond1[i], "v", ncond2[i], ".csv", sep = "")
  write.csv(cbind(tempcount1, tempcount2), fname)
}

