setwd("~/Documents/DEGage_stuff/DEGage_testing_2/review_round_2")

library(ggplot2)
library(ggpubr)

degage_results <- read.csv("degage_imbalance_stats_3.csv")
degage_results <- degage_results[,-1]
degage_results$imbalance <- factor(degage_results$imbalance, levels = unique(degage_results$imbalance))
degage_results$effect <- factor(degage_results$effect)

#degage - random assignment
degager_results <- read.csv("degage_random_imbalance_stats_3.csv")
degager_results <- degager_results[,-1]
degager_results$imbalance <- factor(degager_results$imbalance, levels = unique(degager_results$imbalance))
degager_results$effect <- factor(degager_results$effect)

#deseq2
deseq2_results <- read.csv("deseq2_imbalance_stats_3.csv")
deseq2_results <- deseq2_results[,-1]
deseq2_results$imbalance <- factor(deseq2_results$imbalance, levels = unique(deseq2_results$imbalance))
deseq2_results$effect <- factor(deseq2_results$effect)

#edger
edger_results <- read.csv("edger_imbalance_stats_3.csv")
edger_results <- edger_results[,-1]
edger_results$imbalance <- factor(edger_results$imbalance, levels = unique(edger_results$imbalance))
edger_results$effect <- factor(edger_results$effect)

#glm
glm_results <- read.csv("glm_imbalance_stats_3.csv")
glm_results <- glm_results[,-1]
glm_results$imbalance <- factor(glm_results$imbalance, levels = unique(glm_results$imbalance))
glm_results$effect <- factor(glm_results$effect)

#wilcoxon
wilcoxon_results <- read.csv("wilcoxon_imbalance_stats_3.csv")
wilcoxon_results <- wilcoxon_results[,-1]
wilcoxon_results$imbalance <- factor(wilcoxon_results$imbalance, levels = unique(wilcoxon_results$imbalance))
wilcoxon_results$effect <- factor(wilcoxon_results$effect)


degage_results$package <- "DEGage - S"
degager_results$package <- "DEGage - RA"
deseq2_results$package <- "DESeq2"
edger_results$package <- "edgeR"
wilcoxon_results$package <- "wilcoxon"
glm_results$package <- "glm.nb"


x <- rbind(degage_results, degager_results, deseq2_results, edger_results, glm_results, wilcoxon_results)


ggplot(x, aes(x = imbalance, y = effect, fill = F1)) +
  geom_tile(color = "grey10") +
  facet_grid(package~ disp, scales = "free") +
  scale_fill_gradientn(colours = c("#440154FF", "#414487FF", "#2A788EFF", "#22A884FF",
                                   "#7AD151FF", "#FDE725FF"),
                       limits = c(0, 1))+
  theme(
    axis.line = element_blank(),
    panel.background = element_blank(),
    plot.title = element_text(hjust = 0.5),
    axis.text.x = element_text(angle = 90, vjust = 0.5)
  ) +
  xlab("Sample Size Imbalance") +
  ylab("Effect Size")

ggsave("F1_effectvdisp_heatmap.svg", units = "in", width = 8, height = 10)
ggsave("F1_effectvdisp_heatmap.png", units = "in", width = 8, height = 10)
ggsave("F1_effectvdisp_heatmap.pdf", units = "in", width = 8, height = 10)

ggplot(x, aes(x = imbalance, y = effect, fill = Sensitivity)) +
  geom_tile(color = "grey10") +
  facet_grid(package~ disp, scales = "free") +
  scale_fill_gradientn(colours = c("#440154FF", "#414487FF", "#2A788EFF", "#22A884FF",
                                   "#7AD151FF", "#FDE725FF"),
                       limits = c(0, 1))+
  theme(
    axis.line = element_blank(),
    panel.background = element_blank(),
    plot.title = element_text(hjust = 0.5),
    axis.text.x = element_text(angle = 90, vjust = 0.5)
  ) +
  xlab("Sample Size Imbalance") +
  ylab("Effect Size")

ggsave("Sensitivity_effectvdisp_heatmap.svg", units = "in", width = 8, height = 10)
ggsave("Sensitivity_effectvdisp_heatmap.png", units = "in", width = 8, height = 10)
ggsave("Sensitivity_effectvdisp_heatmap.pdf", units = "in", width = 8, height = 10)

ggplot(x, aes(x = imbalance, y = effect, fill = Specificity)) +
  geom_tile(color = "grey10") +
  facet_grid(package~ disp, scales = "free") +
  scale_fill_gradientn(colours = c("#440154FF", "#414487FF", "#2A788EFF", "#22A884FF",
                                   "#7AD151FF", "#FDE725FF"),
                       limits = c(0, 1))+
  theme(
    axis.line = element_blank(),
    panel.background = element_blank(),
    plot.title = element_text(hjust = 0.5),
    axis.text.x = element_text(angle = 90, vjust = 0.5)
  ) +
  xlab("Sample Size Imbalance") +
  ylab("Effect Size")

ggsave("Specificity_effectvdisp_heatmap.svg", units = "in", width = 8, height = 10)
ggsave("Specificity_effectvdisp_heatmap.png", units = "in", width = 8, height = 10)
ggsave("Specificity_effectvdisp_heatmap.pdf", units = "in", width = 8, height = 10)










