library(MASS)
#testing

fs <- list.files("data/")
allsims <- data.frame()
for(f in fs){
  counts <- read.csv(paste("data/", f, sep = ""))
  rownames(counts) <- counts[,1]
  counts <- counts[,-1]
  t <- strsplit(f, "v")[[1]]
  w <- strsplit(t[2], "_")[[1]]
  t[2] <- w[1]
  t[3] <- substr(w[2], 1, nchar(w[2]) - 3)
  t <- as.numeric(t)

  trial_id <- paste(t[1], "_", t[2], "_", t[3], sep = "")
  print(trial_id)

    sim.starttime <- Sys.time()
    pvals <- c()
    for( i in 1:nrow(counts)){
      design <- data.frame(counts = as.numeric(counts[i,]),
                           group = c(rep(1, t[1]), rep(2, t[2])))
      res <- tryCatch({res<-glm.nb(counts~group, design)},
                      error = function(e){return(NA)})
      if(length(res) == 1){
        p <- NA
      }else{
        lrt.res <- anova(res)
        p <- lrt.res$`Pr(>Chi)`[2]
      }

      pvals <- c(pvals, p)
    }

    simresults <- data.frame(gene = rownames(counts), pval = pvals, FDR = p.adjust(pvals, method = "fdr"))
    sim.endtime <- Sys.time()
    sim.runtime <- difftime(Sys.time(), sim.starttime, units = "sec")

    simresults<- simresults[!is.na(simresults$FDR),]
    expDEs<- simresults[simresults$FDR <= 0.05,]$gene

    trueDEs <- rownames(counts[1:2000,])
    trueEEs <- rownames(counts[2001:nrow(counts),])

    tp <- sum(trueDEs %in% expDEs)
    fp <- sum(trueEEs %in% expDEs)
    tn <- sum(!(trueEEs %in% expDEs))
    fn <- sum(!(trueDEs %in% expDEs))

    sim.sensitivity <- tp/(tp+fn)
    sim.specificity <- tn/(tn+fp)
    precision <- tp/(tp+fp)
    accuracy <- (tp +tn)/12000
    f1 <- (2*tp)/(2*tp+fp+fn)

    simdf <- data.frame("Trial" = trial_id,
                        DEGs= length(expDEs),
                        "Sensitivity" = sim.sensitivity,
                        "Specificity" = sim.specificity,
                        "Precision" = precision,
                        "Accuracy" = accuracy,
                        "F1" = f1,
                        g1 = t[1],
                        g2 = t[2])
    allsims <- rbind(allsims, simdf)
    print(simdf)

    simresults$trial_id <- trial_id
    simresults$g1 <- t[1]
    simresults$g2 <- t[2]

    fname <- paste("glm/", trial_id, ".csv", sep="")
    write.csv(simresults, fname)
    write.csv(allsims, "glm/allsims.csv")

}

