# This script was used to generate the gene ontology  figures based on the
# panther output

path <- "DEGage_C/DEGage_results/go_analysis/"
files <- list.files(path)
files <- files[c(3,4,5)]
dfs <- lapply(paste(path, files, sep = ""), read.csv)

nterms <- unlist(lapply(dfs, nrow))

dfs[[1]] <- dfs[[1]][order(dfs[[1]]$Client.Text.Box.Input..FDR.),]
dfs[[2]] <- dfs[[2]][order(dfs[[2]]$Client.Text.Box.Input..FDR.),]
dfs[[3]] <- dfs[[3]][order(dfs[[3]]$Client.Text.Box.Input..FDR.),]

dfs[[1]] <- dfs[[1]][dfs[[1]]$Client.Text.Box.Input..fold.Enrichment. > 1,]
dfs[[2]] <- dfs[[2]][dfs[[2]]$Client.Text.Box.Input..fold.Enrichment. > 1,]
dfs[[3]] <- dfs[[3]][dfs[[3]]$Client.Text.Box.Input..fold.Enrichment. > 1,]

df1 <- as.data.frame(dfs[[1]])
df2 <- as.data.frame(dfs[[2]])
df3 <- as.data.frame(dfs[[3]])

colnames(df1)<- c("term", "x", "y", "z", "a", "b", "c", "FDR")
colnames(df2)<- c("term", "x", "y", "z", "a", "b", "c", "FDR")
colnames(df3)<- c("term", "x", "y", "z", "a", "b", "c", "FDR")
plotdf <- rbind(df1[1:5,],
                df2[1:5,],
                df3[1:5,])
plotdf <- plotdf[,c(1, 8)]

temp <- plotdf$term
for(i in 1:length(temp)){
  temp[i] <- substr(temp[i], 1, nchar(temp[i])-13 )
}

plotdf$term <- temp
plotdf$condition <- c(rep("DEGage only", 5),
                     rep("RaoRuiz only", 5),
                     rep("Both analyses", 5))
library(ggplot2)
library(ggsci)
library(ggpubr)
p1 <- ggplot(plotdf, aes(x = factor(term, levels = term), y = -log(FDR), fill = condition))+
  geom_bar(stat = "identity")+
  coord_flip()+
  theme_minimal()+
  scale_fill_npg()+
  labs(x = "GO Biological Process")

plotdf2 <- data.frame( nhits = nterms, condition= c("DEGage only", "RaoRuiz only",
                                                    "Both analyses"))

p2 <- ggplot(plotdf2, aes(plotdf2, x = nhits, y = condition, fill = condition))+
  geom_bar(stat = "identity")+
  coord_flip()+
  theme_minimal()+
  theme(axis.text.x = element_text(angle=30, vjust=1, hjust=1))+
  scale_fill_npg()+
  labs(x = "Number of GO hits", y = element_blank())
p2
ggarrange(p1, p2, widths = c(7,2), common.legend = TRUE)
