import timeit
import numpy as np
import pandas as pd
from netZooPy.ligress.bonobo import Bonobo
from bonobo_competitors_scaled import lioness
from bonobo_competitors_scaled import spcc
from bonobo_competitors_scaled import sweet


def simulate_bonobo(sim_mean, sim_cov, ngene = 100, nsample = 100, nsample_ind = 100):
  sim_mean = sim_mean["x"].to_numpy()

  # Simulate individual gene expression and save individual mean and covariance matrix
  ind_mean = []
  ind_cor = []
  for i in range(nsample):
    expr_sim = np.random.multivariate_normal(sim_mean, sim_cov, nsample_ind).T
    expr_mean = np.mean(expr_sim, 1)
    expr_cor = np.corrcoef(expr_sim)
    ind_mean.append(expr_mean)
    ind_cor.append(expr_cor)

  expression = pd.DataFrame(np.array(ind_mean).transpose())

  start = timeit.default_timer()
  bonobo_obj = Bonobo(expression)
  bonobo_obj.run_bonobo(keep_in_memory=True, output_folder = "")
  stop = timeit.default_timer()
  time_bonobo = stop - start
  
  start = timeit.default_timer()
  bonobo_obj = Bonobo(expression)
  bonobo_obj.run_bonobo(keep_in_memory=True, output_folder = "", sparsify=True)
  stop = timeit.default_timer()
  time_bonobo_sparse = stop - start
  
  start = timeit.default_timer()
  sweet_output = sweet(expression.T)
  stop = timeit.default_timer()
  time_sweet = stop - start

  ind_lioness = []
  start = timeit.default_timer()
  for i in range(nsample):
    lioness_net = lioness(expression, i)
    ind_lioness.append(lioness_net)
    
  stop = timeit.default_timer()
  time_lioness = stop - start
    
  ind_spcc = []
  start = timeit.default_timer()
  for i in range(nsample):
    spcc_net = spcc(expression, i)
    ind_spcc.append(spcc_net)
    
  stop = timeit.default_timer()
  time_spcc = stop - start

  return time_bonobo, time_bonobo_sparse, time_lioness, time_spcc, time_sweet

