import random

import numpy as np
import pandas as pd
from netZooPy.ligress.bonobo import Bonobo
from bonobo_competitors_scaled import lioness
from bonobo_competitors_scaled import spcc
from bonobo_competitors_scaled import sweet
from bonobo_simulation_module_scaledCompetitors import simulate_bonobo

random.seed(10)

### Compute MSE for Nsim-many Simulated Data
sim_mean = pd.read_csv("/home/esaha/BONOBO/data/simulation_simple/simulation_mean2000.csv")
sim_cov = pd.read_csv("/home/esaha/BONOBO/data/simulation_simple/simulation_covariance2000.csv", sep = " ")

Nsim = 2
nsample = 100
ngene = 2000
mse_bonobo = []
mse_bonobo_sparse = []
mse_lioness = []
mse_spcc = []
mse_sweet = []
for i in range(Nsim):
  mse_b, mse_bs, mse_l, mse_s, mse_sw = simulate_bonobo(sim_mean, sim_cov, ngene, nsample, nsample_ind = 100)
  mse_b = sum(mse_b)/len(mse_b)
  mse_bs = sum(mse_bs)/len(mse_bs)
  mse_l = sum(mse_l)/len(mse_l)
  mse_s = sum(mse_s)/len(mse_s)
  mse_sw = sum(mse_sw)/len(mse_sw)
  mse_bonobo.append(mse_b)
  mse_bonobo_sparse.append(mse_bs)
  mse_lioness.append(mse_l)
  mse_spcc.append(mse_s)
  mse_sweet.append(mse_sw)

# Combine the lists using pandas
results = pd.DataFrame({
    "mse_bonobo": mse_bonobo,
    "mse_bonobo_sparse": mse_bonobo_sparse,
    "mse_lioness": mse_lioness,
    "mse_spcc": mse_spcc,
    "mse_sweet": mse_sweet
})

# Save the combined DataFrame to a text file
results.to_csv("bonobo_simulation_scaledCompetitors_sample" + str(nsample) + "_gene2000.txt", sep="\t", index=False)

results.mean(axis=0)



